/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.core.model.workspace;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.StringReader;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.fao.fi.fishstat.core.CoreCommons;
import org.fao.fi.fishstat.core.CoreUtils;
import org.fao.fi.fishstat.core.ICoreConstants;
import org.fao.fi.fishstat.core.MultilingualStringWrapper;
import org.fao.fi.fishstat.core.VersionId;
import org.fao.fi.fishstat.core.model.workspace.WorkspaceModel;
import org.fao.fi.fishstat.data.common.jdbc.JdbcDriverDescriptor;
import org.fao.fi.fishstat.data.common.jdbc.JdbcDriverRegistry;
import org.osgi.framework.Bundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class WorkspaceModelImpl
implements WorkspaceModel,
ICoreConstants,
Cloneable,
PropertyChangeListener {
    private WorkspaceModel originalInstance;
    private File locationDir;
    private File propertiesDir;
    private File attachmentsDir;
    private File jarPath;
    private File sessionDir;
    private File descriptor;
    private String acronym;
    private VersionId version;
    private VersionId compatibility;
    private Date date;
    private Date importedOn;
    private MultilingualStringWrapper name = new MultilingualStringWrapper("name", this);
    private MultilingualStringWrapper description = new MultilingualStringWrapper("description", this);
    private MultilingualStringWrapper provider = new MultilingualStringWrapper("provider", this);
    private String dbId;
    private int dbType;
    private File dbDir;
    private JdbcDriverDescriptor dbDriver;
    private String dbUrl;
    private String dbSchema;
    private String dbUsername;
    private String dbPassword;
    protected PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public WorkspaceModelImpl() {
        this.setDefaults();
    }

    public WorkspaceModelImpl(File descriptor) throws Exception {
        this.descriptor = descriptor;
        this.importedOn = new Date(descriptor.lastModified());
        this.locationDir = descriptor.getParentFile();
        this.propertiesDir = new File(this.locationDir, "properties");
        this.jarPath = new File(this.locationDir, "jar" + File.separatorChar + "fishstatj-jdbc-dao.jar");
        this.dbDir = new File(this.locationDir, "db");
        this.attachmentsDir = new File(this.locationDir, "att");
        this.sessionDir = new File(this.locationDir, "session");
        this.loadMetadataFromDescriptor(descriptor, false);
        this.originalInstance = this.clone();
    }

    @Override
    public void loadMetadataFromDescriptor(File descriptor, boolean incrementVersionNumber) throws Exception {
        DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document doc = documentBuilder.parse(descriptor);
        this.parseDescriptor(doc, incrementVersionNumber);
    }

    public WorkspaceModelImpl(String xmlMessage) throws Exception {
        DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        StringReader reader = new StringReader(xmlMessage);
        InputSource inputSource = new InputSource(reader);
        Document doc = documentBuilder.parse(inputSource);
        this.parseDescriptor(doc, false);
        reader.close();
        this.originalInstance = this.clone();
    }

    @Override
    public String getAcronym() {
        return this.acronym;
    }

    @Override
    public boolean isNative() {
        return this.originalInstance != null;
    }

    @Override
    public boolean isSynchronised() {
        if (this.originalInstance == null) {
            return true;
        }
        if (!this.originalInstance.getAcronym().equals(this.acronym)) {
            return false;
        }
        if (!this.originalInstance.getVersion().equals(this.version)) {
            return false;
        }
        if (!this.originalInstance.getName().getInstance().equals((Object)this.name.getInstance())) {
            return false;
        }
        if (!this.originalInstance.getDescription().getInstance().equals((Object)this.description.getInstance())) {
            return false;
        }
        return this.originalInstance.getProvider().getInstance().equals((Object)this.provider.getInstance());
    }

    @Override
    public WorkspaceModel getInstance() {
        return this.originalInstance;
    }

    @Override
    public File getJarPath() {
        return this.jarPath;
    }

    @Override
    public void persistModel(IProgressMonitor progressMonitor) throws Exception {
        if (this.descriptor != null) {
            File bak_file = new File(String.valueOf(this.locationDir.getAbsolutePath()) + File.separatorChar + "ws.bak");
            if (bak_file.exists() && !bak_file.delete()) {
                throw new Exception("File system error: cannot delete workspace .bak file!");
            }
            if (!this.descriptor.renameTo(bak_file)) {
                throw new Exception("File system error: cannot rename workspace .bak file!");
            }
        }
        this.descriptor = new File(this.getLocationDir(), "ws.xml");
        if (!this.descriptor.createNewFile()) {
            throw new Exception("File system error: cannot create a ws.xml desriptor file");
        }
        this.saveOnXml(this.descriptor);
        this.originalInstance = this.clone();
    }

    @Override
    public void setAcronym(String acronym) {
        this.acronym = acronym;
        this.propertyChangeSupport.firePropertyChange("acronym", this.acronym, this.acronym);
    }

    @Override
    public void setVersion(VersionId version) {
        this.version = version;
        this.propertyChangeSupport.firePropertyChange("version", this.version, this.version);
    }

    @Override
    public Date getDate() {
        return this.date;
    }

    @Override
    public String getDbId() {
        return this.dbId;
    }

    @Override
    public void setDbId(String dbId) {
        this.dbId = dbId;
    }

    @Override
    public File getDbDir() {
        return this.dbDir;
    }

    public void setDbDir(File dbDir) {
        this.dbDir = dbDir;
    }

    @Override
    public File getAttachmentsDir() {
        return this.attachmentsDir;
    }

    @Override
    public String getDescription(String locale) {
        return this.description.getValue(locale);
    }

    public File getDescriptor() {
        return this.descriptor;
    }

    public Date getImportedOn() {
        return this.importedOn;
    }

    @Override
    public File getLocationDir() {
        return this.locationDir;
    }

    @Override
    public void setLocationDir(File locationDir) {
        this.locationDir = locationDir;
        this.propertyChangeSupport.firePropertyChange("locationDir", this.locationDir, this.locationDir);
        this.dbDir = new File(locationDir, "db");
    }

    @Override
    public MultilingualStringWrapper getName() {
        return this.name;
    }

    @Override
    public void setName(MultilingualStringWrapper name) {
        this.name = name;
        this.propertyChangeSupport.firePropertyChange("name", this.name, this.name);
    }

    @Override
    public MultilingualStringWrapper getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(MultilingualStringWrapper description) {
        this.description = description;
        this.propertyChangeSupport.firePropertyChange("description", this.description, this.description);
    }

    @Override
    public MultilingualStringWrapper getProvider() {
        return this.provider;
    }

    @Override
    public void setProvider(MultilingualStringWrapper provider) {
        this.provider = provider;
        this.propertyChangeSupport.firePropertyChange("provider", this.provider, this.provider);
    }

    @Override
    public String getName(String locale) {
        return this.name.getValue(locale);
    }

    @Override
    public File getPropertiesDir() {
        return this.propertiesDir;
    }

    @Override
    public String getProvider(String locale) {
        return this.provider.getValue(locale);
    }

    @Override
    public VersionId getVersion() {
        return this.version;
    }

    @Override
    public VersionId getCompatibility() {
        return this.compatibility;
    }

    @Override
    public File getSessionDir() {
        return this.sessionDir;
    }

    @Override
    public boolean hasAcronym() {
        return this.acronym != null;
    }

    @Override
    public void setDate(Date date) {
        this.date = date;
        this.propertyChangeSupport.firePropertyChange("date", this.date, this.date);
    }

    public boolean hasDate() {
        return this.date != null;
    }

    @Override
    public boolean hasDescription(String locale) {
        return this.description.getValue(locale) != null;
    }

    public boolean hasImportedOn() {
        return this.importedOn != null;
    }

    @Override
    public boolean hasName(String locale) {
        return this.name.getValue(locale) != null;
    }

    @Override
    public boolean hasProvider(String locale) {
        return this.provider.getValue(locale) != null;
    }

    @Override
    public boolean hasVersion() {
        return this.version != null;
    }

    @Override
    public int getDbType() {
        return this.dbType;
    }

    @Override
    public void setDbType(int dbType) {
        this.dbType = dbType;
        if (dbType == 1) {
            this.defineEmbeddedDbms();
        }
    }

    @Override
    public JdbcDriverDescriptor getDbDriver() {
        return this.dbDriver;
    }

    @Override
    public void setDbDriver(JdbcDriverDescriptor dbDriver) {
        this.dbDriver = dbDriver;
    }

    @Override
    public String getDbUrl() {
        return this.dbUrl;
    }

    @Override
    public void setDbUrl(String dbUrl) {
        this.dbUrl = dbUrl;
    }

    @Override
    public String getDbSchema() {
        return this.dbSchema;
    }

    @Override
    public void setDbSchema(String dbSchema) {
        this.dbSchema = dbSchema;
    }

    @Override
    public String getDbUsername() {
        return this.dbUsername;
    }

    @Override
    public void setDbUsername(String dbUsername) {
        this.dbUsername = dbUsername;
    }

    @Override
    public String getDbPassword() {
        return this.dbPassword;
    }

    @Override
    public void setDbPassword(String dbPassword) {
        this.dbPassword = dbPassword;
    }

    private void setDefaults() {
        this.acronym = "NEW_WORKSPACE";
        this.acronym = "FAO_FI_GLOBAL_PROD";
        try {
            SimpleDateFormat df = new SimpleDateFormat("yyyy");
            this.version = new VersionId(String.valueOf(df.format(new Date())) + ".0.1");
            this.compatibility = CoreCommons.COMPATIBILITY_MAX.clone();
        }
        catch (Exception e) {
            Platform.getLog((Bundle)Platform.getBundle((String)"org.eclipse.core.runtime")).log((IStatus)new Status(4, this.getClass().getName(), "Version setDefaults()", (Throwable)e));
        }
        this.date = new Date();
        this.locationDir = CoreUtils.proposeEmptyFolder();
        this.dbDir = new File(this.locationDir, "db");
        this.dbDriver = JdbcDriverRegistry.getDriverDescriptor((String)"Apache Derby - embedded");
    }

    public boolean equals(Object obj) {
        if (obj instanceof WorkspaceModelImpl) {
            return ((WorkspaceModelImpl)obj).getLocationDir().equals(this.getLocationDir()) && ((WorkspaceModelImpl)obj).getAcronym().equals(this.getAcronym());
        }
        return false;
    }

    protected WorkspaceModelImpl clone() throws CloneNotSupportedException {
        WorkspaceModelImpl res = new WorkspaceModelImpl();
        if (this.acronym != null) {
            res.acronym = new String(this.acronym);
        }
        if (this.compatibility != null) {
            res.compatibility = this.compatibility.clone();
        }
        if (this.date != null) {
            res.date = (Date)this.date.clone();
        }
        if (this.description != null) {
            res.description = this.description.clone();
        }
        if (this.importedOn != null) {
            res.importedOn = (Date)this.importedOn.clone();
        }
        if (this.locationDir != null) {
            res.locationDir = this.locationDir;
        }
        if (this.name != null) {
            res.name = this.name.clone();
        }
        if (this.propertiesDir != null) {
            res.propertiesDir = this.propertiesDir;
        }
        if (this.dbDir != null) {
            res.dbDir = this.dbDir;
        }
        if (this.dbDriver != null) {
            res.dbDriver = this.dbDriver;
        }
        if (this.dbUrl != null) {
            res.dbUrl = this.dbUrl;
        }
        if (this.dbSchema != null) {
            res.dbSchema = this.dbSchema;
        }
        if (this.dbUsername != null) {
            res.dbUsername = this.dbUsername;
        }
        if (this.dbPassword != null) {
            res.dbPassword = this.dbPassword;
        }
        if (this.provider != null) {
            res.provider = this.provider.clone();
        }
        if (this.sessionDir != null) {
            res.sessionDir = this.sessionDir;
        }
        if (this.version != null) {
            res.version = this.version != null ? this.version.clone() : null;
        }
        return res;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.propertyChangeSupport.firePropertyChange(evt);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    private void parseDescriptor(Document doc, boolean incrementVersion) throws Exception {
        Element rootElement = doc.getDocumentElement();
        this.acronym = rootElement.getAttribute("acronym");
        this.version = new VersionId(rootElement.getAttribute("version"));
        if (incrementVersion) {
            this.version.setMajor(this.version.getMajor() + 1);
        }
        this.compatibility = incrementVersion ? CoreCommons.COMPATIBILITY_MAX.clone() : new VersionId(rootElement.getAttribute("compatibility"));
        NodeList namesList = rootElement.getElementsByTagName("name");
        int i = 0;
        while (i < namesList.getLength()) {
            Element nameElement = (Element)namesList.item(i);
            if (nameElement.getParentNode() == rootElement) {
                this.name.setValue(nameElement.getAttribute("xml:lang"), nameElement.getTextContent());
            }
            ++i;
        }
        NodeList descriptionsList = rootElement.getElementsByTagName("description");
        int i2 = 0;
        while (i2 < descriptionsList.getLength()) {
            Element descriptionElement = (Element)descriptionsList.item(i2);
            this.description.setValue(descriptionElement.getAttribute("xml:lang"), descriptionElement.getTextContent());
            ++i2;
        }
        NodeList providersList = rootElement.getElementsByTagName("provider");
        int i3 = 0;
        while (i3 < providersList.getLength()) {
            Element providerElement = (Element)providersList.item(i3);
            this.provider.setValue(providerElement.getAttribute("xml:lang"), providerElement.getTextContent());
            ++i3;
        }
        this.defineEmbeddedDbms();
    }

    private void defineEmbeddedDbms() {
        this.dbId = "EMBEDDED_DB";
        this.dbType = 1;
        this.dbUrl = this.getEmbeddedDbUrl();
        this.dbSchema = "FISHSTAT";
        this.dbUsername = "FISHSTAT";
        this.dbPassword = "";
        this.dbDriver = JdbcDriverRegistry.getDriverDescriptor((String)"Apache Derby - embedded");
    }

    private String getEmbeddedDbUrl() {
        return this.dbDir != null ? "jdbc:derby:" + this.getDbDir().getAbsolutePath() : null;
    }

    private void saveOnXml(File xml_file) throws Exception {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        DOMSource source = new DOMSource(this.toXml(""));
        StreamResult result = new StreamResult(xml_file);
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.transform(source, result);
    }

    public Document toXml(String protocol) throws Exception {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document res = documentBuilder.newDocument();
        Element rootElement = res.createElement("workspace");
        this.buildXmlElement(rootElement);
        res.appendChild(rootElement);
        return res;
    }

    private void buildXmlElement(Element rootElement) {
        rootElement.setAttribute("acronym", this.acronym);
        rootElement.setAttribute("version", this.version.toString());
        rootElement.setAttribute("compatibility", this.compatibility.toString());
        this.name.toXml(rootElement, "name");
        this.description.toXml(rootElement, "description");
        this.provider.toXml(rootElement, "provider");
        Element dateElement = rootElement.getOwnerDocument().createElement("date");
        dateElement.setTextContent(this.date != null ? this.date.toString() : "");
        rootElement.appendChild(dateElement);
        Element dbmsElement = rootElement.getOwnerDocument().createElement("dbms");
        dbmsElement.setAttribute("id", this.dbId != null ? this.dbId : "");
        dbmsElement.setAttribute("type", this.dbType == 1 ? "embedded" : "remote");
        dbmsElement.setAttribute("driver", this.dbDriver.getId());
        if (this.dbUrl != null && this.dbType != 1) {
            Element urlElement = rootElement.getOwnerDocument().createElement("url");
            urlElement.setTextContent(this.dbUrl);
            dbmsElement.appendChild(urlElement);
        }
        if (this.dbSchema != null) {
            Element schemaElement = rootElement.getOwnerDocument().createElement("schema");
            schemaElement.setTextContent(this.dbSchema);
            dbmsElement.appendChild(schemaElement);
        }
        if (this.dbUsername != null) {
            Element usernameElement = rootElement.getOwnerDocument().createElement("username");
            usernameElement.setTextContent(this.dbUsername);
            dbmsElement.appendChild(usernameElement);
        }
        if (this.dbPassword != null) {
            Element passwordElement = rootElement.getOwnerDocument().createElement("password");
            passwordElement.setTextContent(this.dbPassword);
            dbmsElement.appendChild(passwordElement);
        }
        rootElement.appendChild(dbmsElement);
    }
}

