/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.core.workspaces;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.fao.fi.fishstat.core.CoreCommons;
import org.fao.fi.fishstat.core.ICoreConstants;
import org.fao.fi.fishstat.core.model.workspace.WorkspaceModel;
import org.fao.fi.fishstat.core.model.workspace.WorkspaceModelImpl;
import org.fao.fi.fishstat.data.common.Commons;
import org.fao.fi.fishstat.data.common.api.ResourceManager;
import org.fao.fi.fishstat.data.common.api.workspace.Workspace;
import org.fao.fi.fishstat.data.common.api.workspace.WorkspaceManager;
import org.fao.fi.fishstat.data.common.classloader.ClassLoaderFactory;
import org.fao.fi.fishstat.data.common.register.RegistryFactory;
import org.fao.fi.fishstat.data.common.register.StructuralChangeEvent;
import org.fao.fi.fishstat.data.reference.api.ReferenceServiceFactory;
import org.osgi.framework.Bundle;

public class WorkspacesManager
extends Observable
implements ICoreConstants {
    public static final String MSG_OPEN_WORKSPACE = "MSG_OPEN_WORKSPACE";
    public static final String MSG_CLOSE_WORKSPACE = "MSG_CLOSE_WORKSPACE";
    public static final String MSG_REFRESH_WORKSPACE = "MSG_REFRESH_WORKSPACE";
    public static final String MSG_SCAN_REGISTRY = "MSG_SCAN_REGISTRY";
    private File root;
    private HashMap<String, WorkspaceModel> workspacesFolderRegistry = new HashMap(10);
    private WorkspaceModel currentWorkspace;

    public WorkspacesManager(String wsPath) {
        ILog log = Platform.getLog((Bundle)Platform.getBundle((String)"org.eclipse.core.runtime"));
        log.log((IStatus)new Status(1, this.getClass().getName(), "ROOT_WORKSPACES_FOLDER: " + wsPath));
        this.root = new File(wsPath);
        if (!this.root.exists()) {
            try {
                this.createRoot();
            }
            catch (Exception e) {
                log.log((IStatus)new Status(4, this.getClass().getName(), "creating root foler", (Throwable)e));
            }
        } else {
            this.rebuildWsRegistry();
        }
    }

    public void closeCurrentWorkspace() {
        if (this.currentWorkspace != null) {
            this.currentWorkspace = null;
            this.setChanged();
            this.notifyObservers(MSG_CLOSE_WORKSPACE);
            ResourceManager.closeDriver();
            ClassLoaderFactory.dispose();
            Commons.fireMethodsMapReset();
            RegistryFactory.fireStructuralChangeEvent((StructuralChangeEvent)StructuralChangeEvent.WORKSPACE_CHANGE);
        }
    }

    public void refreshMenuHandlers() {
        this.setChanged();
        this.notifyObservers(MSG_REFRESH_WORKSPACE);
    }

    public WorkspaceModel getCurrentWorkspace() {
        return this.currentWorkspace;
    }

    public List<WorkspaceModel> getDeployedWorkspaces() {
        LinkedList<WorkspaceModel> res = new LinkedList<WorkspaceModel>();
        File[] folders = this.root.listFiles();
        if (folders != null) {
            File[] fileArray = folders;
            int n = folders.length;
            int n2 = 0;
            while (n2 < n) {
                File ws_folder = fileArray[n2];
                File wsDesc = new File(ws_folder, "ws.xml");
                if (wsDesc.exists() && wsDesc.isFile()) {
                    try {
                        res.add(new WorkspaceModelImpl(wsDesc));
                    }
                    catch (Exception e) {
                        ILog log = Platform.getLog((Bundle)Platform.getBundle((String)"org.eclipse.core.runtime"));
                        log.log((IStatus)new Status(4, this.getClass().getName(), "error get workspace", (Throwable)e));
                    }
                }
                ++n2;
            }
        }
        this.sortWorkspaceModels(res);
        return res;
    }

    private void sortWorkspaceModels(List<WorkspaceModel> wsList) {
        Collections.sort(wsList, (e1, e2) -> {
            String o1 = null;
            String o2 = null;
            if (e1.getAcronym().equals(e2.getAcronym())) {
                o2 = e1.getVersion().toString();
                o1 = e2.getVersion().toString();
            } else {
                o1 = e1.getAcronym();
                o2 = e2.getAcronym();
            }
            return o1.compareTo(o2);
        });
    }

    public File getRoot() {
        return this.root;
    }

    public boolean hasCurrentWorkspace() {
        return this.currentWorkspace != null;
    }

    public boolean hasWorkspaceFolderRegistered(String wsPath) {
        return this.workspacesFolderRegistry.containsKey(wsPath);
    }

    public List<WorkspaceModel> getRegisteredWorkspaces(String wsAcronym) {
        LinkedList<WorkspaceModel> res = new LinkedList<WorkspaceModel>();
        Collection<WorkspaceModel> workspaces = this.workspacesFolderRegistry.values();
        for (WorkspaceModel workspaceMetadata : workspaces) {
            if (!workspaceMetadata.getAcronym().equals(wsAcronym)) continue;
            res.add(workspaceMetadata);
        }
        return res;
    }

    public void openWorkspace(String wsPath) throws Exception {
        WorkspaceModel workspaceModel = this.getWorkspaceMeta(wsPath);
        ResourceManager.setJdbcDriver((String)workspaceModel.getDbDriver().getDriverClassName());
        ResourceManager.setJdbcUser((String)workspaceModel.getDbUsername());
        ResourceManager.setJdbcPassword((String)workspaceModel.getDbPassword());
        ResourceManager.setJdbcSchema((String)workspaceModel.getDbSchema());
        File wsRootFolder = workspaceModel.getLocationDir();
        File jarFilePath = new File(String.valueOf(wsRootFolder.getAbsolutePath()) + File.separator + "jar" + File.separator + "fishstatj-jdbc-dao.jar");
        File dbFolderPath = new File(workspaceModel.getLocationDir(), "db");
        if (jarFilePath.exists() && dbFolderPath.exists()) {
            Workspace ws = WorkspaceManager.instance().createWorkspace(workspaceModel.getDbUrl(), jarFilePath.toURI().toURL());
            WorkspaceManager.instance().setActiveWorkspace(ws);
        }
        ILog log = Platform.getLog((Bundle)Platform.getBundle((String)"org.eclipse.core.runtime"));
        log.log((IStatus)new Status(1, this.getClass().getName(), "WS_path=" + workspaceModel.getLocationDir() + ", JDBC_URL=" + ResourceManager.getJdbcUrl() + ", JDBC_DRV=" + ResourceManager.getJdbcDriver()));
        this.currentWorkspace = workspaceModel;
        this.setChanged();
        this.notifyObservers(MSG_OPEN_WORKSPACE);
        ReferenceServiceFactory.getService().getConcept("PREDEFINED");
        CoreCommons.getWorkspaceStatus().currentWorkspace = wsPath;
        CoreCommons.getWorkspaceStatus().setStatus(10);
    }

    public void registerWorkspace(String wsPath) throws Exception {
        File wsDesciptorFile;
        if (!this.workspacesFolderRegistry.containsKey(wsPath) && this.isWsDescriptorCompatible(wsDesciptorFile = new File(wsPath, "ws.xml"))) {
            WorkspaceModelImpl wmd = new WorkspaceModelImpl(wsDesciptorFile);
            this.workspacesFolderRegistry.put(wsPath, wmd);
        }
    }

    private boolean isWsDescriptorCompatible(File wsDescriptor) {
        if (wsDescriptor.exists() && wsDescriptor.isFile()) {
            WorkspaceModelImpl wmd = null;
            try {
                wmd = new WorkspaceModelImpl(wsDescriptor);
            }
            catch (Exception e) {
                return false;
            }
            if (CoreCommons.COMPATIBILITY_MIN.getMajor() >= wmd.getCompatibility().getMajor()) {
                return true;
            }
        }
        return false;
    }

    public void switchWorkspace(String wsPath) throws Exception {
        if (this.currentWorkspace != null) {
            this.closeCurrentWorkspace();
        }
        this.openWorkspace(wsPath);
    }

    protected WorkspaceModel getWorkspaceMeta(String wsFolder) {
        return this.workspacesFolderRegistry.get(wsFolder);
    }

    public List<WorkspaceModel> getWorkspacesByAcronym(String wsAcronym) {
        LinkedList<WorkspaceModel> res = new LinkedList<WorkspaceModel>();
        Collection<WorkspaceModel> workspaces = this.workspacesFolderRegistry.values();
        for (WorkspaceModel workspaceMetadata : workspaces) {
            if (!workspaceMetadata.getAcronym().equals(wsAcronym)) continue;
            res.add(workspaceMetadata);
        }
        return res;
    }

    public boolean isValidWorkspace(WorkspaceModel workspaceMetadata) {
        return this.workspacesFolderRegistry.containsValue(workspaceMetadata);
    }

    public boolean isValidWorkspacePath(String wsPath) {
        if (wsPath == null || wsPath.equals("")) {
            return false;
        }
        if (this.hasWorkspaceFolderRegistered(wsPath)) {
            return true;
        }
        return this.isWsDescriptorCompatible(new File(wsPath, "ws.xml"));
    }

    public int getNumberOfWorkspaces() {
        return this.workspacesFolderRegistry.size();
    }

    private void createRoot() {
        boolean folderCreated;
        if (!this.root.exists() && (folderCreated = this.root.mkdir())) {
            ILog log = Platform.getLog((Bundle)Platform.getBundle((String)"org.eclipse.core.runtime"));
            log.log((IStatus)new Status(1, this.getClass().getName(), "Workspaces root successfully created"));
        }
    }

    protected void rebuildWsRegistry() {
        List<WorkspaceModel> listMetadatas = this.getDeployedWorkspaces();
        this.workspacesFolderRegistry = new HashMap(listMetadatas.size());
        for (WorkspaceModel ws_meta : listMetadatas) {
            this.workspacesFolderRegistry.put(ws_meta.getLocationDir().getAbsolutePath(), ws_meta);
        }
        this.setChanged();
        this.notifyObservers(MSG_SCAN_REGISTRY);
    }

    public boolean isActiveWorkspaceDir(String dir) {
        if (dir == null) {
            return false;
        }
        if (dir.equals("")) {
            return false;
        }
        return this.workspacesFolderRegistry.containsKey(dir);
    }
}

