/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.core.workspaces.data;

import com.csvreader.CsvReader;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.fao.fi.fishstat.data.api.io.csv.ReferenceCSVService;
import org.fao.fi.fishstat.data.api.io.csv.ReferenceConceptCSVMetadata;
import org.fao.fi.fishstat.data.api.io.exceptions.FSIOException;
import org.fao.fi.fishstat.data.common.api.MultilingualString;
import org.fao.fi.fishstat.data.reference.api.Attribute;
import org.fao.fi.fishstat.data.reference.api.AttributeType;
import org.fao.fi.fishstat.data.reference.api.Concept;
import org.fao.fi.fishstat.data.reference.api.ReferenceObject;

public class ReferenceCSVServiceWrapper
extends ReferenceCSVService {
    private static ReferenceCSVServiceWrapper instance;

    public static ReferenceCSVServiceWrapper instance() {
        if (instance == null) {
            instance = new ReferenceCSVServiceWrapper();
        }
        return instance;
    }

    public void unMarshall(Concept concept, Reader input, ReferenceConceptCSVMetadata metadata, boolean truncate, IProgressMonitor monitor) throws FSIOException {
        try {
            if (concept == null) {
                throw new FSIOException("Concept can not be null");
            }
            if (input == null) {
                throw new FSIOException("Input CSV can not be null");
            }
            if (metadata == null) {
                metadata = this.createConceptMetadata(concept);
            }
            List<ReferenceObject> loaded = this.load(concept, input, metadata, monitor);
            if (truncate) {
                concept.removeAll();
            }
            concept.addAll(loaded);
        }
        catch (FSIOException csve) {
            throw csve;
        }
        catch (Exception e) {
            throw new FSIOException("Unable to load objects", (Throwable)e);
        }
    }

    private List<ReferenceObject> load(Concept concept, Reader input, ReferenceConceptCSVMetadata metadata, IProgressMonitor monitor) throws Exception {
        ArrayList<ReferenceObject> loaded = new ArrayList<ReferenceObject>();
        CsvReader reader = new CsvReader(input, ',');
        if (metadata.useHeaders()) {
            reader.readHeaders();
        }
        if (metadata.useTextQualifier()) {
            reader.setTextQualifier(metadata.getTextQualifier());
        }
        while (reader.readRecord()) {
            try {
                if (monitor != null) {
                    monitor.subTask("loading record " + reader.getCurrentRecord());
                }
                ReferenceObject object = concept.createObject();
                for (Attribute attribute : concept.getAttributes()) {
                    if (attribute.getAcronym().equals("ID")) continue;
                    Object attribute_value = null;
                    if (attribute.getType().equals((Object)AttributeType.MULTILINGUAL_STRING)) {
                        MultilingualString multi_string = new MultilingualString();
                        for (String lang : MultilingualString.LANGUAGES) {
                            String value = null;
                            if (metadata.useHeaders()) {
                                String header = metadata.getAttributeHeader(attribute.getAcronym(), lang);
                                value = reader.get(header);
                            } else {
                                int column = metadata.getAttributeColumn(attribute.getAcronym(), lang);
                                value = reader.get(column);
                            }
                            multi_string.setValue(lang, value);
                        }
                        attribute_value = multi_string;
                    } else {
                        String value = null;
                        if (metadata.useHeaders()) {
                            String header = metadata.getAttributeHeader(attribute.getAcronym());
                            value = reader.get(header);
                        } else {
                            int column = metadata.getAttributeColumn(attribute.getAcronym());
                            value = reader.get(column);
                        }
                        if (value != null) {
                            Constructor constructor = attribute.getType().getRuntimeType().getConstructor(String.class);
                            attribute_value = constructor.newInstance(value);
                        }
                    }
                    object.setAttribute(attribute, attribute_value);
                }
                loaded.add(object);
            }
            catch (Exception e) {
                if (reader != null) {
                    reader.close();
                }
                throw new FSIOException("Unable to unmarshall CSV row: " + e.getMessage(), (Throwable)e, reader.getCurrentRecord() + 1L);
            }
            if (monitor == null) continue;
            monitor.worked(1);
        }
        reader.close();
        return loaded;
    }
}

