/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.core.workspaces.data;

import com.csvreader.CsvReader;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.fao.fi.fishstat.core.workspaces.data.TimeSeriesImplWrapper;
import org.fao.fi.fishstat.data.api.io.csv.DenormalisedTimeseriesCSVMetadata;
import org.fao.fi.fishstat.data.api.io.csv.NormalisedTimeseriesCSVMetadata;
import org.fao.fi.fishstat.data.api.io.csv.TimeseriesCSVMetadata;
import org.fao.fi.fishstat.data.api.io.csv.TimeseriesCSVService;
import org.fao.fi.fishstat.data.api.io.exceptions.FSIOException;
import org.fao.fi.fishstat.data.common.api.Identifier;
import org.fao.fi.fishstat.data.common.api.IdentifierFactory;
import org.fao.fi.fishstat.data.common.api.impl.IdentifierHelper;
import org.fao.fi.fishstat.data.reference.api.Attribute;
import org.fao.fi.fishstat.data.reference.api.Concept;
import org.fao.fi.fishstat.data.reference.api.MultiReferenceObject;
import org.fao.fi.fishstat.data.reference.api.ReferenceObject;
import org.fao.fi.fishstat.data.reference.api.exceptions.ReferenceServiceException;
import org.fao.fi.fishstat.data.timeseries.api.Dimension;
import org.fao.fi.fishstat.data.timeseries.api.FIESMeasureSymbol;
import org.fao.fi.fishstat.data.timeseries.api.Measure;
import org.fao.fi.fishstat.data.timeseries.api.MeasureFactory;
import org.fao.fi.fishstat.data.timeseries.api.MeasureStatus;
import org.fao.fi.fishstat.data.timeseries.api.ObservationPeriod;
import org.fao.fi.fishstat.data.timeseries.api.ObservationSeries;
import org.fao.fi.fishstat.data.timeseries.api.Timeseries;

public class TimeSeriesCSVServiceWrapper
extends TimeseriesCSVService {
    private static TimeSeriesCSVServiceWrapper instance;

    public static TimeSeriesCSVServiceWrapper instance() {
        if (instance == null) {
            instance = new TimeSeriesCSVServiceWrapper();
        }
        return instance;
    }

    public void unMarshall(TimeSeriesImplWrapper timeseriesWrapper, Reader input, TimeseriesCSVMetadata metadata, boolean truncate, IProgressMonitor monitor) throws FSIOException {
        try {
            if (timeseriesWrapper.getTimeseries() == null) {
                throw new FSIOException("Timeseries can not be null");
            }
            if (input == null) {
                throw new FSIOException("Input CSV can not be null");
            }
            if (metadata == null) {
                metadata = this.createDenormalisedMetadata(timeseriesWrapper.getTimeseries());
            }
            List<ObservationSeries> series_list = this.load(timeseriesWrapper.getTimeseries(), input, metadata, monitor);
            if (truncate) {
                timeseriesWrapper.getTimeseries().clean();
            }
            timeseriesWrapper.add(series_list, monitor);
        }
        catch (FSIOException csve) {
            throw csve;
        }
        catch (Exception e) {
            throw new FSIOException("Unable to load timeseries", (Throwable)e);
        }
    }

    private List<ObservationSeries> load(Timeseries timeseries, Reader input, TimeseriesCSVMetadata metadata, IProgressMonitor monitor) throws Exception {
        ArrayList<ObservationSeries> series_list = new ArrayList<ObservationSeries>();
        CsvReader reader = new CsvReader(input, ',');
        if (metadata.useHeaders()) {
            reader.readHeaders();
        }
        if (metadata.useTextQualifier()) {
            reader.setTextQualifier(metadata.getTextQualifier());
        }
        if (metadata instanceof DenormalisedTimeseriesCSVMetadata) {
            DenormalisedTimeseriesCSVMetadata denormalised_metadata = (DenormalisedTimeseriesCSVMetadata)metadata;
            while (reader.readRecord()) {
                if (monitor != null) {
                    monitor.subTask("loading record " + reader.getCurrentRecord());
                }
                ObservationSeries series = timeseries.create();
                ArrayList<ReferenceObject> keys = new ArrayList<ReferenceObject>();
                for (Dimension dimension : timeseries.getDataset().getDimensions()) {
                    Concept concept = dimension.getConcept();
                    ReferenceObject key = null;
                    String code = null;
                    if (denormalised_metadata.useHeaders()) {
                        String header = denormalised_metadata.getDimensionHeader(dimension.getAcronym());
                        code = reader.get(header);
                    } else {
                        int column = denormalised_metadata.getDimensionColumn(concept.getAcronym());
                        code = reader.get(column);
                    }
                    if (code == null || code.length() == 0) {
                        System.out.println("concept.getAcronym()=" + concept.getAcronym());
                        System.out.println("reader.getCurrentRecord()=" + reader.getCurrentRecord());
                        System.out.println("code=[" + code + "]");
                        throw new FSIOException("Null or empty key value read for: " + concept.getAcronym(), reader.getCurrentRecord() + 1L);
                    }
                    String reference_attribute = denormalised_metadata.getDimensionAttribute(concept.getAcronym());
                    reference_attribute = denormalised_metadata.getDimensionAttribute(dimension.getAcronym());
                    if (reference_attribute == null || reference_attribute.equalsIgnoreCase("ID")) {
                        Identifier id = null;
                        try {
                            id = IdentifierFactory.instance((String)code);
                        }
                        catch (Exception e) {
                            throw new FSIOException("Key value is not an identifier: " + code, (Throwable)e, reader.getCurrentRecord() + 1L);
                        }
                        key = concept.getObject(id);
                    } else {
                        try {
                            Attribute attribute = concept.getAttribute(reference_attribute);
                            if (attribute != null) {
                                Constructor constructor = attribute.getType().getRuntimeType().getConstructor(String.class);
                                Object attribute_value = constructor.newInstance(code);
                                if (attribute.isCodeAttribute()) {
                                    key = concept.getObject(reference_attribute, attribute_value);
                                } else {
                                    Collection candidate_keys = concept.getObjects(attribute, attribute_value);
                                    if (candidate_keys.size() == 1) {
                                        key = (ReferenceObject)new ArrayList(candidate_keys).get(0);
                                    }
                                }
                            }
                        }
                        catch (ReferenceServiceException e) {
                            throw new FSIOException("Unable to get reference object for dimension: " + concept.getAcronym() + ", " + reference_attribute + "=" + code, (Throwable)e, reader.getCurrentRecord() + 1L);
                        }
                    }
                    if (key == null) {
                        throw new FSIOException("No matching reference object found for dimension: " + concept.getAcronym() + ", " + reference_attribute + "=" + code, reader.getCurrentRecord() + 1L);
                    }
                    keys.add(key);
                }
                series.setKeys(new MultiReferenceObject(keys));
                LinkedHashMap<ObservationPeriod, Measure> measures = new LinkedHashMap<ObservationPeriod, Measure>();
                for (ObservationPeriod period : timeseries.getObservationPeriods()) {
                    String value = null;
                    String status = null;
                    if (denormalised_metadata.useHeaders()) {
                        String value_header = denormalised_metadata.getMeasureValueHeader(period.toString());
                        value = reader.get(value_header);
                        String status_header = denormalised_metadata.getMeasureStatusHeader(period.toString());
                        if (status_header != null) {
                            status = reader.get(status_header);
                        }
                    } else {
                        int value_column = denormalised_metadata.getMeasureValueColumn(period.toString());
                        value = reader.get(value_column);
                        int status_column = denormalised_metadata.getMeasureStatusColumn(period.toString());
                        if (status_column != -1 && status_column < reader.getColumnCount()) {
                            status = reader.get(status_column);
                        }
                    }
                    Measure measure = MeasureFactory.create();
                    measure.setStatus(new MeasureStatus(status));
                    if (value == null || value.length() == 0) {
                        measure.setValue(0.0);
                        measure.setStatus((MeasureStatus)FIESMeasureSymbol.TRIPLE_DOT);
                    } else {
                        Double d_value = null;
                        try {
                            d_value = Double.valueOf(value);
                        }
                        catch (Exception e) {
                            throw new FSIOException("Unable to parse the observation value: " + period + "=" + value, (Throwable)e, reader.getCurrentRecord() + 1L);
                        }
                        measure.setValue(d_value.doubleValue());
                    }
                    measures.put(period, measure);
                }
                series.setMeasures(measures);
                series_list.add(series);
                if (monitor == null) continue;
                monitor.worked(1);
            }
        } else {
            NormalisedTimeseriesCSVMetadata normalised_metadata = (NormalisedTimeseriesCSVMetadata)metadata;
            HashMap<MultiReferenceObject, ObservationSeries> series_map = new HashMap<MultiReferenceObject, ObservationSeries>();
            while (reader.readRecord()) {
                if (monitor != null) {
                    monitor.subTask("loading record " + reader.getCurrentRecord());
                }
                ArrayList<ReferenceObject> keys = new ArrayList<ReferenceObject>();
                for (Dimension dimension : timeseries.getDataset().getDimensions()) {
                    Concept concept = dimension.getConcept();
                    ReferenceObject key = null;
                    Object code = null;
                    if (normalised_metadata.useHeaders()) {
                        String header = normalised_metadata.getDimensionHeader(dimension.getAcronym());
                        code = reader.get(header);
                    } else {
                        int column = normalised_metadata.getDimensionColumn(concept.getAcronym());
                        code = reader.get(column);
                    }
                    if (code == null || ((String)code).length() == 0) {
                        throw new FSIOException("Null key value read for: " + concept.getAcronym(), reader.getCurrentRecord() + 1L);
                    }
                    String reference_attribute = normalised_metadata.getDimensionAttribute(concept.getAcronym());
                    if (reference_attribute == null || reference_attribute.equalsIgnoreCase("ID")) {
                        Identifier id = null;
                        try {
                            id = IdentifierHelper.instance((String)code);
                        }
                        catch (Exception e) {
                            throw new FSIOException("Key value is not an identifier: " + (String)code, (Throwable)e, reader.getCurrentRecord() + 1L);
                        }
                        key = concept.getObject(id);
                    } else {
                        try {
                            Attribute attribute = concept.getAttribute(reference_attribute);
                            switch (attribute.getType().getJdbcType()) {
                                case -5: {
                                    key = concept.getObject(reference_attribute, (Object)Long.valueOf((String)code));
                                    break;
                                }
                                default: {
                                    key = concept.getObject(reference_attribute, code);
                                    break;
                                }
                            }
                        }
                        catch (ReferenceServiceException e) {
                            throw new FSIOException("Unable to get reference object for dimension: " + concept.getAcronym() + ", " + reference_attribute + "=" + (String)code, (Throwable)e, reader.getCurrentRecord() + 1L);
                        }
                    }
                    if (key == null) {
                        throw new FSIOException("No reference object found for dimension: " + concept.getAcronym() + ", " + reference_attribute + "=" + (String)code, reader.getCurrentRecord() + 1L);
                    }
                    keys.add(key);
                }
                MultiReferenceObject multi_key = new MultiReferenceObject(keys);
                ObservationSeries series = (ObservationSeries)series_map.get(multi_key);
                if (series == null) {
                    series = timeseries.create();
                    series.setKeys(multi_key);
                    LinkedHashMap<ObservationPeriod, Measure> measures = new LinkedHashMap<ObservationPeriod, Measure>();
                    for (ObservationPeriod period : timeseries.getObservationPeriods()) {
                        measures.put(period, MeasureFactory.create());
                    }
                    series.setMeasures(measures);
                    series_map.put(multi_key, series);
                }
                String period = null;
                if (normalised_metadata.useHeaders()) {
                    String header = normalised_metadata.getPeriodHeader();
                    period = reader.get(header);
                } else {
                    int column = normalised_metadata.getPeriodColumn();
                    period = reader.get(column);
                }
                if (period == null || period.length() == 0) {
                    throw new FSIOException("Null or empty value read for period", reader.getCurrentRecord() + 1L);
                }
                ObservationPeriod observation_period = new ObservationPeriod(period);
                if (!timeseries.getObservationPeriods().contains(observation_period)) {
                    throw new FSIOException("Period out of bound: " + period, reader.getCurrentRecord() + 1L);
                }
                Measure measure = series.getMeasure(observation_period);
                String value = null;
                String status = null;
                if (normalised_metadata.useHeaders()) {
                    String value_header = normalised_metadata.getMeasureValueHeader();
                    value = reader.get(value_header);
                    String status_header = normalised_metadata.getMeasureStatusHeader();
                    if (status_header != null) {
                        status = reader.get(status_header);
                    }
                } else {
                    int value_column = normalised_metadata.getMeasureValueColumn();
                    value = reader.get(value_column);
                    int status_column = normalised_metadata.getMeasureStatusColumn();
                    if (status_column != -1 && status_column < reader.getColumnCount()) {
                        status = reader.get(status_column);
                    }
                }
                if (value == null || value.length() == 0) {
                    throw new FSIOException("Null or empty value read for period: " + period, reader.getCurrentRecord() + 1L);
                }
                measure.setStatus(new MeasureStatus(status));
                Double d_value = null;
                try {
                    d_value = Double.valueOf(value);
                }
                catch (Exception e) {
                    throw new FSIOException("Unable to parse the observation value: " + period + "=" + value, (Throwable)e, reader.getCurrentRecord() + 1L);
                }
                measure.setValue(d_value.doubleValue());
                if (monitor == null) continue;
                monitor.worked(1);
            }
            series_list.addAll(series_map.values());
        }
        reader.close();
        return series_list;
    }
}

