/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.core.workspaces.structure;

import java.io.File;
import java.io.FileInputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.fao.fi.fishstat.core.CoreCommons;
import org.fao.fi.fishstat.core.CoreRegistry;
import org.fao.fi.fishstat.core.MultilingualStringWrapper;
import org.fao.fi.fishstat.core.workspaces.structure.WorkspaceStructureExporter;
import org.fao.fi.fishstat.data.common.api.MultilingualString;
import org.fao.fi.fishstat.data.reference.api.Attribute;
import org.fao.fi.fishstat.data.reference.api.Concept;
import org.fao.fi.fishstat.data.reference.api.ReferenceObject;
import org.fao.fi.fishstat.data.reference.api.ReferenceServiceFactory;
import org.fao.fi.fishstat.data.reference.api.Relationship;
import org.fao.fi.fishstat.data.timeseries.api.Attachment;
import org.fao.fi.fishstat.data.timeseries.api.Dataset;
import org.fao.fi.fishstat.data.timeseries.api.Dimension;
import org.fao.fi.fishstat.data.timeseries.api.Timeseries;
import org.fao.fi.fishstat.data.timeseries.api.TimeseriesServiceFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WorkspaceStructureExporterImpl
implements WorkspaceStructureExporter {
    @Override
    public void exportConcepts(Writer writer, List<Object> elements) throws Exception {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = docBuilder.newDocument();
        Element root = document.createElement("fishstatj-concepts");
        root.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        root.setAttribute("xmlns", "org/fao/fi/fishstat/core/xmlbinds/workspaces/concepts");
        root.setAttribute("xmlns:cm", "org/fao/fi/fishstat/core/xmlbinds/commons");
        root.setAttribute("xsi:schemaLocation", "org/fao/fi/fishstat/core/xmlbinds/workspaces/concepts http://www.fao.org/fishery/static/FishStatJ/schema/3_04/concepts.xsd");
        document.appendChild(root);
        Element conceptsElement = document.createElement("concepts");
        List concepts = ReferenceServiceFactory.getService().getConcepts();
        List relationships = ReferenceServiceFactory.getService().getRelationships();
        for (Concept concept : concepts) {
            if (CoreCommons.getWorkspaceSystemEntities().isSystemConcept(concept) || elements != null && !elements.contains(concept)) continue;
            Element conceptElement = document.createElement("concept");
            conceptElement.setAttribute("acronym", concept.getAcronym());
            if (concept.getSortorder() != null) {
                conceptElement.setAttribute("sort_order", concept.getSortorder().toString());
            } else {
                conceptElement.setAttribute("sort_order", "");
            }
            new MultilingualStringWrapper(concept.getName()).toXml(conceptElement, "cm:name");
            new MultilingualStringWrapper(concept.getDescription()).toXml(conceptElement, "cm:description");
            Element attributesElement = document.createElement("attributes");
            for (Attribute attribute : concept.getAttributes()) {
                Element attributeElement = document.createElement("attribute");
                attributeElement.setAttribute("acronym", attribute.getAcronym());
                attributeElement.setAttribute("type", attribute.getType().toString());
                attributeElement.setAttribute("scale", Short.toString(attribute.getScale()));
                attributeElement.setAttribute("size", Short.toString(attribute.getSize()));
                attributeElement.setAttribute("iscode", Boolean.toString(attribute.isCodeAttribute()));
                attributeElement.setAttribute("isname", Boolean.toString(attribute.isNameAttribute()));
                new MultilingualStringWrapper(attribute.getName()).toXml(attributeElement, "cm:name");
                new MultilingualStringWrapper(attribute.getDescription()).toXml(attributeElement, "cm:description");
                attributesElement.appendChild(attributeElement);
            }
            conceptElement.appendChild(attributesElement);
            conceptsElement.appendChild(conceptElement);
        }
        root.appendChild(conceptsElement);
        Element relationshipsElement = document.createElement("relationships");
        for (Relationship relationship : relationships) {
            if (CoreCommons.getWorkspaceSystemEntities().isSystemRelationship(relationship) || elements != null && !elements.contains(relationship)) continue;
            Element relationshipElement = document.createElement("relationship");
            relationshipElement.setAttribute("acronym", relationship.getAcronym());
            relationshipElement.setAttribute("child", relationship.getChildConcept().getAcronym());
            relationshipElement.setAttribute("parent", relationship.getParentConcept().getAcronym());
            relationshipElement.setAttribute("acronym", relationship.getAcronym());
            if (relationship.getSortorder() != null) {
                relationshipElement.setAttribute("sort_order", relationship.getSortorder().toString());
            } else {
                relationshipElement.setAttribute("sort_order", "");
            }
            new MultilingualStringWrapper(relationship.getName()).toXml(relationshipElement, "cm:name");
            new MultilingualStringWrapper(relationship.getDescription()).toXml(relationshipElement, "cm:description");
            relationshipsElement.appendChild(relationshipElement);
        }
        root.appendChild(relationshipsElement);
        DOMSource domSource = new DOMSource(document);
        TransformerFactory tFactory = TransformerFactory.newInstance();
        Transformer transformer = tFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.transform(domSource, new StreamResult(writer));
    }

    @Override
    public void exportDatasets(Writer writer, List<Object> elements) throws Exception {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = docBuilder.newDocument();
        Element root = document.createElement("fishstatj-datasets");
        root.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        root.setAttribute("xmlns", "org/fao/fi/fishstat/core/xmlbinds/workspaces/datasets");
        root.setAttribute("xmlns:cm", "org/fao/fi/fishstat/core/xmlbinds/commons");
        root.setAttribute("xsi:schemaLocation", "org/fao/fi/fishstat/core/xmlbinds/workspaces/datasets http://www.fao.org/fishery/static/FishStatJ/schema/3_04/datasets.xsd");
        document.appendChild(root);
        Element datasetsElement = document.createElement("datasets");
        Collection datasets = TimeseriesServiceFactory.getService().getDatasets();
        for (Dataset dataset : datasets) {
            if (elements != null && !elements.contains(dataset)) continue;
            Element datasetElement = document.createElement("dataset");
            datasetElement.setAttribute("acronym", dataset.getAcronym());
            datasetElement.setAttribute("datasource", dataset.getDataSource().getName());
            datasetElement.setAttribute("url", dataset.getUrl());
            datasetElement.setAttribute("citation", dataset.getCitation());
            datasetElement.setAttribute("version", dataset.getVersion().getNumber());
            try {
                datasetElement.setAttribute("date", new SimpleDateFormat("yyyy-MM-dd").format(dataset.getVersion().getDate()));
            }
            catch (Exception exp) {
                exp.printStackTrace();
                datasetElement.setAttribute("date", "2014-01-01");
            }
            datasetElement.setAttribute("author", dataset.getVersion().getAuthor());
            new MultilingualStringWrapper(dataset.getName()).toXml(datasetElement, "cm:name");
            new MultilingualStringWrapper(dataset.getDescription()).toXml(datasetElement, "cm:description");
            for (Dimension dimension : dataset.getDimensions()) {
                Element dimensionElement = document.createElement("dimension");
                dimensionElement.setAttribute("acronym", dimension.getAcronym());
                dimensionElement.setAttribute("concept", dimension.getConcept().getAcronym());
                dimensionElement.setAttribute("attribute", dimension.getAttribute().getAcronym());
                dimensionElement.setAttribute("ismeasure", Boolean.toString(dimension.isObservedMeasure()));
                new MultilingualStringWrapper(dimension.getName()).toXml(dimensionElement, "cm:name");
                new MultilingualStringWrapper(dimension.getDescription()).toXml(dimensionElement, "cm:description");
                datasetElement.appendChild(dimensionElement);
            }
            for (Timeseries timeseries : dataset.getTimeseries()) {
                Element timeseriesElement = document.createElement("timeseries");
                timeseriesElement.setAttribute("acronym", timeseries.getAcronym());
                timeseriesElement.setAttribute("datasource", timeseries.getDataSource().getName());
                timeseriesElement.setAttribute("timeresolution", timeseries.getTimeResolution().toString());
                timeseriesElement.setAttribute("firstperiod", timeseries.getFirstObservationPeriod().toString());
                timeseriesElement.setAttribute("lastperiod", timeseries.getLastObservationPeriod().toString());
                new MultilingualStringWrapper(timeseries.getName()).toXml(timeseriesElement, "cm:name");
                new MultilingualStringWrapper(timeseries.getDescription()).toXml(timeseriesElement, "cm:description");
                if (timeseries.getAttributes().size() > 0) {
                    Element attributesElement = document.createElement("attributes");
                    for (org.fao.fi.fishstat.data.timeseries.api.Attribute attribute : timeseries.getAttributes().keySet()) {
                        Element attributeElement = document.createElement("attribute");
                        attributeElement.setAttribute("acronym", attribute.getAcronym());
                        attributeElement.setAttribute("value", (String)timeseries.getAttributes().get(attribute));
                        new MultilingualStringWrapper(attribute.getName()).toXml(attributeElement, "cm:name");
                        new MultilingualStringWrapper(attribute.getDescription()).toXml(attributeElement, "cm:description");
                        attributesElement.appendChild(attributeElement);
                    }
                    timeseriesElement.appendChild(attributesElement);
                }
                datasetElement.appendChild(timeseriesElement);
            }
            datasetsElement.appendChild(datasetElement);
        }
        root.appendChild(datasetsElement);
        DOMSource domSource = new DOMSource(document);
        TransformerFactory tFactory = TransformerFactory.newInstance();
        Transformer transformer = tFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.transform(domSource, new StreamResult(writer));
    }

    @Override
    public void exportCustomgroups(Writer writer, List<Object> elements) throws Exception {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = docBuilder.newDocument();
        Element root = document.createElement("fishstatj-customgroups");
        root.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        root.setAttribute("xmlns", "org/fao/fi/fishstat/core/xmlbinds/workspaces/customgroups");
        root.setAttribute("xmlns:cm", "org/fao/fi/fishstat/core/xmlbinds/commons");
        root.setAttribute("xsi:schemaLocation", "org/fao/fi/fishstat/core/xmlbinds/workspaces/customgroups http://www.fao.org/fishery/static/FishStatJ/schema/3_04/customgroups.xsd");
        document.appendChild(root);
        Concept custom_group_concept = ReferenceServiceFactory.getService().getConcept("CUSTOM_GROUP");
        List custom_groups = custom_group_concept.getObjects();
        for (ReferenceObject custom_group : custom_groups) {
            Element customgroupElement = document.createElement("customgroup");
            customgroupElement.setAttribute("id", Integer.toString(custom_group.getId().intValue()));
            customgroupElement.setAttribute("concept", custom_group.getAttribute("MEMBERS_CONCEPT").toString());
            new MultilingualStringWrapper((MultilingualString)custom_group.getAttribute("NAME")).toXml(customgroupElement, "cm:name");
            new MultilingualStringWrapper((MultilingualString)custom_group.getAttribute("DESCRIPTION")).toXml(customgroupElement, "cm:description");
            root.appendChild(customgroupElement);
        }
        DOMSource domSource = new DOMSource(document);
        TransformerFactory tFactory = TransformerFactory.newInstance();
        Transformer transformer = tFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.transform(domSource, new StreamResult(writer));
    }

    @Override
    public void exportAttachments(OutputStream outputStream, List<Object> elements) throws Exception {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = docBuilder.newDocument();
        Element root = document.createElement("fishstatj-attachments");
        root.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        root.setAttribute("xsi:noNamespaceSchemaLocation", "http://www.fao.org/fishery/static/FishStatJ/schema/3_04/attachments.xsd");
        document.appendChild(root);
        ZipOutputStream out = new ZipOutputStream(outputStream);
        byte[] buf = new byte[1024];
        File[] fileArray = CoreRegistry.getAttachmentsPath().listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            int len;
            File attachmentFile = fileArray[n2];
            out.putNextEntry(new ZipEntry(attachmentFile.getName()));
            FileInputStream in = new FileInputStream(attachmentFile);
            while ((len = in.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
            in.close();
            ++n2;
        }
        ZipEntry xmlZipEntry = new ZipEntry("attachments.xml");
        out.putNextEntry(xmlZipEntry);
        LinkedList attachments = new LinkedList();
        for (Dataset dataset : TimeseriesServiceFactory.getService().getDatasets()) {
            attachments.addAll(dataset.getAttachments());
        }
        for (Attachment attachment : attachments) {
            Element customgroupElement = document.createElement("attachment");
            customgroupElement.setAttribute("acronym", attachment.getAcronym());
            customgroupElement.setAttribute("dataset", attachment.getDataset().getAcronym());
            customgroupElement.setAttribute("typeAttachment", attachment.getType().toString());
            customgroupElement.setAttribute("mimeType", attachment.getMimeType());
            new MultilingualStringWrapper(attachment.getName()).toXml(customgroupElement, "name");
            new MultilingualStringWrapper(attachment.getDescription()).toXml(customgroupElement, "description");
            new MultilingualStringWrapper(attachment.getFileName()).toXml(customgroupElement, "fileName");
            root.appendChild(customgroupElement);
        }
        DOMSource domSource = new DOMSource(document);
        TransformerFactory tFactory = TransformerFactory.newInstance();
        Transformer transformer = tFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("encoding", "UTF-8");
        StringWriter stringWriter = new StringWriter();
        OutputStreamWriter myout = new OutputStreamWriter((OutputStream)out, "UTF8");
        StreamResult result = new StreamResult(myout);
        transformer.transform(domSource, result);
        out.write(stringWriter.toString().getBytes());
        out.close();
    }
}

