/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.core.workspaces.structure;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.fao.fi.fishstat.core.CoreCommons;
import org.fao.fi.fishstat.core.CoreRegistry;
import org.fao.fi.fishstat.core.MultilingualStringWrapper;
import org.fao.fi.fishstat.core.VersionId;
import org.fao.fi.fishstat.core.model.concept.ConceptModel;
import org.fao.fi.fishstat.core.model.concept.relationship.ConceptRelationshipModel;
import org.fao.fi.fishstat.core.model.concept.relationship.ConceptRelationshipModelImpl;
import org.fao.fi.fishstat.core.model.dataset.DatasetModel;
import org.fao.fi.fishstat.core.model.dataset.TimeseriesModel;
import org.fao.fi.fishstat.core.model.exchange.timeseries.TimeSeriesStructure;
import org.fao.fi.fishstat.core.model.persistence.PersistenceServiceFactory;
import org.fao.fi.fishstat.core.model.persistence.ReferencePersistenceService;
import org.fao.fi.fishstat.core.model.persistence.TimeseriesPersistenceService;
import org.fao.fi.fishstat.core.workspaces.structure.WorkspaceStructureImporter;
import org.fao.fi.fishstat.core.xmlbinds.commons.Description;
import org.fao.fi.fishstat.core.xmlbinds.commons.Name;
import org.fao.fi.fishstat.core.xmlbinds.workspaces.TimeSeriesStructureAdapter;
import org.fao.fi.fishstat.core.xmlbinds.workspaces.WorkspaceAdapters;
import org.fao.fi.fishstat.core.xmlbinds.workspaces.concepts.Concept;
import org.fao.fi.fishstat.core.xmlbinds.workspaces.concepts.Concepts;
import org.fao.fi.fishstat.core.xmlbinds.workspaces.concepts.FishstatjConcepts;
import org.fao.fi.fishstat.core.xmlbinds.workspaces.concepts.Relationship;
import org.fao.fi.fishstat.core.xmlbinds.workspaces.concepts.Relationships;
import org.fao.fi.fishstat.core.xmlbinds.workspaces.customgroups.Customgroup;
import org.fao.fi.fishstat.core.xmlbinds.workspaces.customgroups.FishstatjCustomgroups;
import org.fao.fi.fishstat.core.xmlbinds.workspaces.datasets.Dataset;
import org.fao.fi.fishstat.core.xmlbinds.workspaces.datasets.Datasets;
import org.fao.fi.fishstat.core.xmlbinds.workspaces.datasets.FishstatjDatasets;
import org.fao.fi.fishstat.core.xmlbinds.workspaces.missingrelations.FishstatjMissingrelations;
import org.fao.fi.fishstat.core.xmlbinds.workspaces.tsexchanges.FishstatjExchangeTs;
import org.fao.fi.fishstat.data.common.api.Identifier;
import org.fao.fi.fishstat.data.common.api.IdentifierFactory;
import org.fao.fi.fishstat.data.reference.api.Attribute;
import org.fao.fi.fishstat.data.reference.api.ReferenceObject;
import org.fao.fi.fishstat.data.reference.api.ReferenceService;
import org.fao.fi.fishstat.data.reference.api.ReferenceServiceFactory;
import org.fao.fi.fishstat.data.timeseries.api.Timeseries;
import org.fao.fi.fishstat.data.timeseries.api.TimeseriesService;
import org.fao.fi.fishstat.data.timeseries.api.TimeseriesServiceFactory;
import org.fao.fi.fishstat.data.timeseries.api.impl.TimeseriesServiceHelper;
import org.fao.fi.fishstat.data.timeseries.api.management.TimeseriesManagementServiceFactory;
import org.fao.fi.fishstat.data.timeseries.api.management.descriptors.AttachmentDescriptor;
import org.fao.fi.fishstat.data.timeseries.api.management.exceptions.TimeseriesManagementException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class WorkspaceStructureImporterImpl
implements WorkspaceStructureImporter {
    private ReferenceService referenceService = ReferenceServiceFactory.getService();
    private TimeseriesService timeseriesService = TimeseriesServiceFactory.getService();
    private ReferencePersistenceService referencePersistenceService = PersistenceServiceFactory.getReferenceService();
    private TimeseriesPersistenceService timeseriesPersistenceService = PersistenceServiceFactory.getTimeseriesService();
    private ILog logger;

    public WorkspaceStructureImporterImpl(ILog logger) {
        this.logger = logger;
    }

    @Override
    public Document validateImportFile(File importFile, String SchemaUrl) throws Exception {
        Document doc = this.createParser(SchemaUrl).parse(importFile);
        NamedNodeMap node = doc.getChildNodes().item(0).getAttributes();
        if (node == null || node.getLength() == 0) {
            throw new Exception("Error parsing XML schema attributes");
        }
        boolean foundSchema = false;
        int i = 0;
        while (i < node.getLength()) {
            if (node.item(i).toString().indexOf(SchemaUrl) != -1) {
                foundSchema = true;
            }
            ++i;
        }
        if (!foundSchema) {
            throw new Exception("XML file does not refer to schema " + SchemaUrl);
        }
        return doc;
    }

    public Document validateImportFile(InputStream inputStream, String SchemaUrl) throws Exception {
        return this.createParser(SchemaUrl).parse(inputStream);
    }

    private DocumentBuilder createParser(String SchemaUrl) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(true);
        factory.setNamespaceAware(true);
        factory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
        factory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaSource", SchemaUrl);
        factory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaSource", "http://www.fao.org/fishery/static/FishStatJ/schema/3_04/commons.xsd");
        if (SchemaUrl.equals("http://www.fao.org/fishery/static/FishStatJ/schema/3_04/missingrelations.xsd")) {
            factory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaSource", "http://www.fao.org/fishery/static/FishStatJ/schema/3_04/concepts.xsd");
        }
        DocumentBuilder res = factory.newDocumentBuilder();
        res.setErrorHandler(new ErrorHandler(){

            @Override
            public void warning(SAXParseException exception) throws SAXException {
                WorkspaceStructureImporterImpl.this.logger.log((IStatus)new Status(2, this.getClass().getName(), "SAXParseException", (Throwable)exception));
            }

            @Override
            public void fatalError(SAXParseException exception) throws SAXException {
                WorkspaceStructureImporterImpl.this.logger.log((IStatus)new Status(4, this.getClass().getName(), "SAXParseException", (Throwable)exception));
                throw new SAXException(exception);
            }

            @Override
            public void error(SAXParseException exception) throws SAXException {
                WorkspaceStructureImporterImpl.this.logger.log((IStatus)new Status(4, this.getClass().getName(), "SAXParseException", (Throwable)exception));
                throw new SAXException(exception);
            }
        });
        return res;
    }

    @Override
    public int importConcepts(Reader reader, List<String> elements, IProgressMonitor monitor) throws Exception {
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Name.class, Description.class, FishstatjConcepts.class, Concepts.class, Relationships.class, Concept.class});
        Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = schemaFactory.newSchema(new URL("http://www.fao.org/fishery/static/FishStatJ/schema/3_04/concepts.xsd"));
        jaxbUnmarshaller.setSchema(schema);
        JAXBElement root = jaxbUnmarshaller.unmarshal((Source)new StreamSource(reader), FishstatjConcepts.class);
        FishstatjConcepts fishstatjConcepts = (FishstatjConcepts)root.getValue();
        int res = this.processImportMessage(fishstatjConcepts, elements, monitor);
        CoreCommons.getWorkspaceStatus().fireModifyEvent(org.fao.fi.fishstat.data.reference.api.Concept.class);
        return res;
    }

    private int processImportMessage(FishstatjConcepts fishstatjConcepts, List<String> elements, IProgressMonitor monitor) throws Exception {
        int res = 0;
        if (monitor != null) {
            monitor.beginTask("FishStatJ workspace console - Concepts and relationstions import ", elements.size());
        }
        if (fishstatjConcepts.getConcepts() == null || fishstatjConcepts.getConcepts().getConcept() == null || fishstatjConcepts.getConcepts().getConcept().size() == 0) {
            this.logger.log((IStatus)new Status(4, this.getClass().getName(), "no Concepts were read from the XML definition file"));
            throw new Exception("no Concepts were read from the XML definition file");
        }
        if (fishstatjConcepts.getRelationships() == null || fishstatjConcepts.getRelationships().getRelationship() == null || fishstatjConcepts.getRelationships().getRelationship().size() == 0) {
            this.logger.log((IStatus)new Status(4, this.getClass().getName(), "no Relationships were read from the XML definition file"));
            throw new Exception("no Relationships were read from the XML definition file");
        }
        Concepts concepts = fishstatjConcepts.getConcepts();
        for (Concept concept : concepts.getConcept()) {
            if (!elements.contains(concept.getAcronym())) continue;
            if (monitor != null) {
                monitor.subTask("Processing concept " + concept.getAcronym());
            }
            if (this.processConcept(concept)) {
                ++res;
            }
            if (monitor == null) continue;
            monitor.worked(1);
        }
        Relationships relationships = fishstatjConcepts.getRelationships();
        for (Relationship relationship : relationships.getRelationship()) {
            if (!elements.contains(relationship.getAcronym())) continue;
            if (monitor != null) {
                monitor.subTask("Processing concepts relationship " + relationship.getAcronym());
            }
            if (this.processRelationship(relationship)) {
                ++res;
            }
            if (monitor == null) continue;
            monitor.worked(1);
        }
        if (monitor != null) {
            monitor.done();
        }
        return res;
    }

    private boolean processConcept(Concept cnd_concept) throws Exception {
        String acronym = cnd_concept.getAcronym();
        org.fao.fi.fishstat.data.reference.api.Concept ori_concept = this.referenceService.getConcept(acronym);
        if (ori_concept == null) {
            this.importNewConcept(cnd_concept);
            return true;
        }
        if (this.compareConcepts(cnd_concept, ori_concept)) {
            this.updateConcept(cnd_concept);
            return true;
        }
        return false;
    }

    private void updateConcept(Concept xml_concept) throws Exception {
        this.logger.log((IStatus)new Status(4, this.getClass().getName(), "Concept: " + xml_concept.getAcronym() + " already exists. Please delete it before to import a new concept"));
    }

    private void importNewConcept(Concept xml_concept) throws Exception {
        this.logger.log((IStatus)new Status(1, this.getClass().getName(), "Creating concept " + xml_concept.getAcronym() + " ..."));
        ConceptModel concept_model = WorkspaceAdapters.getConcept(xml_concept);
        this.referencePersistenceService.persistConcept(concept_model);
        this.logger.log((IStatus)new Status(0, this.getClass().getName(), "Concept " + xml_concept.getAcronym() + " successfully created"));
    }

    private void importNewRelationship(Relationship xml_relationship) throws Exception {
        this.logger.log((IStatus)new Status(1, this.getClass().getName(), "Creating relationsship " + xml_relationship.getAcronym() + " ..."));
        ConceptRelationshipModel concept_relationship_model = WorkspaceAdapters.getConceptRelationship(xml_relationship);
        this.referencePersistenceService.persistConceptRelationship(concept_relationship_model);
        this.logger.log((IStatus)new Status(0, this.getClass().getName(), "Relationship " + xml_relationship.getAcronym() + " successfully created"));
    }

    private boolean compareConcepts(Concept candidate, org.fao.fi.fishstat.data.reference.api.Concept original) {
        List<org.fao.fi.fishstat.core.xmlbinds.workspaces.concepts.Attribute> attributes = candidate.getAttributes().getAttribute();
        for (org.fao.fi.fishstat.core.xmlbinds.workspaces.concepts.Attribute cnd_attribute : attributes) {
            Attribute ori_attribute = original.getAttribute(cnd_attribute.getAcronym());
            if (ori_attribute == null) continue;
            if (!cnd_attribute.getType().equals(ori_attribute.getType().toString())) {
                this.logger.log((IStatus)new Status(4, this.getClass().getName(), "Cannot import concept: " + original.getAcronym() + ". Attribute: " + cnd_attribute.getAcronym() + ". Reason: different type respect to an pre-existent attribyte."));
                return false;
            }
            if (cnd_attribute.getSize().intValue() != ori_attribute.getSize()) {
                this.logger.log((IStatus)new Status(4, this.getClass().getName(), "Cannot import concept: " + original.getAcronym() + ". Attribute: " + cnd_attribute.getAcronym() + ". Reason: different size respect to an pre-existent attribyte."));
                return false;
            }
            if (cnd_attribute.getScale().intValue() != ori_attribute.getScale()) {
                this.logger.log((IStatus)new Status(4, this.getClass().getName(), "Cannot import concept: " + original.getAcronym() + ". Attribute: " + cnd_attribute.getAcronym() + ". Reason: different scale respect to an pre-existent attribyte."));
                return false;
            }
            this.logger.log((IStatus)new Status(2, this.getClass().getName(), "Concept: " + original.getAcronym() + " import skipped: An identical concept (or a similar name with almost those attributes) is already existing "));
            return false;
        }
        return true;
    }

    private boolean processRelationship(Relationship cnd_relationship) throws Exception {
        String acronym = cnd_relationship.getAcronym();
        org.fao.fi.fishstat.data.reference.api.Relationship ori_relationship = this.referenceService.getRelationship(acronym);
        if (ori_relationship == null) {
            this.importNewRelationship(cnd_relationship);
            return true;
        }
        if (this.compareRelationships(cnd_relationship, ori_relationship)) {
            this.updateRelationship(cnd_relationship);
            return true;
        }
        return false;
    }

    private void updateRelationship(Relationship xml_relationship) throws Exception {
        this.logger.log((IStatus)new Status(4, this.getClass().getName(), "Concept: " + xml_relationship.getAcronym() + " already exists. Please delete it before to import a new concept"));
    }

    private boolean compareRelationships(Relationship candidate, org.fao.fi.fishstat.data.reference.api.Relationship original) {
        if (!candidate.getChild().equals(original.getChildConcept().getAcronym())) {
            this.logger.log((IStatus)new Status(4, this.getClass().getName(), "Cannot import relationship: " + original.getAcronym() + ". Reason: different child concept."));
            return false;
        }
        if (!candidate.getParent().equals(original.getParentConcept().getAcronym())) {
            this.logger.log((IStatus)new Status(4, this.getClass().getName(), "Cannot import relationship: " + original.getAcronym() + ". Reason: different parent concept."));
            return false;
        }
        if (candidate.getChild().equals(original.getChildConcept().getAcronym()) && candidate.getParent().equals(original.getParentConcept().getAcronym())) {
            this.logger.log((IStatus)new Status(2, this.getClass().getName(), "Relationship: " + original.getAcronym() + " import skipped: Relationship exists already"));
            return false;
        }
        return true;
    }

    @Override
    public int importDatasets(Reader reader, List<String> elements, IProgressMonitor monitor) throws Exception {
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Name.class, Description.class, FishstatjDatasets.class});
        Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = schemaFactory.newSchema(new URL("http://www.fao.org/fishery/static/FishStatJ/schema/3_04/datasets.xsd"));
        jaxbUnmarshaller.setSchema(schema);
        JAXBElement root = jaxbUnmarshaller.unmarshal((Source)new StreamSource(reader), FishstatjDatasets.class);
        FishstatjDatasets fishstatjDatasets = (FishstatjDatasets)root.getValue();
        int res = this.processImportMessage(fishstatjDatasets, elements, monitor);
        CoreCommons.getWorkspaceStatus().fireModifyEvent(Dataset.class);
        return res;
    }

    private int processImportMessage(FishstatjDatasets fishstatjDatasets, List<String> elements, IProgressMonitor monitor) throws Exception {
        int res = 0;
        if (monitor != null) {
            monitor.beginTask("FishStatJ workspace console - Datasets and Timeseries import ", elements.size());
        }
        Datasets datasets = fishstatjDatasets.getDatasets();
        for (Dataset dataset : datasets.getDataset()) {
            if (!elements.contains(dataset.getAcronym())) continue;
            if (monitor != null) {
                monitor.subTask("Processing definition of " + dataset.getAcronym() + " dataset");
            }
            if (this.processDataset(dataset)) {
                ++res;
            }
            if (monitor == null) continue;
            monitor.worked(1);
        }
        if (monitor != null) {
            monitor.done();
        }
        return res;
    }

    private boolean processDataset(Dataset cnd_dataset) throws Exception {
        String acronym = cnd_dataset.getAcronym();
        org.fao.fi.fishstat.data.timeseries.api.Dataset ori_dataset = this.timeseriesService.getDataset(acronym);
        if (ori_dataset == null) {
            this.importNewDataset(cnd_dataset);
            return true;
        }
        if (this.compareDatasets(cnd_dataset, ori_dataset)) {
            this.updateDataset(cnd_dataset);
            return true;
        }
        return false;
    }

    private void updateDataset(Dataset xml_dataset) throws Exception {
        this.logger.log((IStatus)new Status(4, this.getClass().getName(), "Dataset: " + xml_dataset.getAcronym() + " already exists. Please delete it before to import a new dataset"));
    }

    private void importNewDataset(Dataset xml_dataset) throws Exception {
        String dataset_acronym = xml_dataset.getAcronym();
        DatasetModel dataset_model = WorkspaceAdapters.getDataset(xml_dataset, this.logger);
        VersionId version = new VersionId();
        version.setAuthor(xml_dataset.getAuthor());
        version.setNumber(xml_dataset.getVersion());
        version.setDate(xml_dataset.getDate());
        dataset_model.setVersion(version);
        dataset_model.persistModel(null);
        for (org.fao.fi.fishstat.core.xmlbinds.workspaces.datasets.Timeseries timeseries : xml_dataset.getTimeseries()) {
            TimeseriesModel timeseriesModel = WorkspaceAdapters.getTimeseries(dataset_acronym, timeseries);
            this.timeseriesPersistenceService.persistTimeseries(dataset_acronym, timeseriesModel);
        }
        this.logger.log((IStatus)new Status(0, this.getClass().getName(), "Dataset " + xml_dataset.getAcronym() + " successfully created"));
    }

    private boolean compareDatasets(Dataset candidate, org.fao.fi.fishstat.data.timeseries.api.Dataset original) {
        List<org.fao.fi.fishstat.core.xmlbinds.workspaces.datasets.Timeseries> timeseriess = candidate.getTimeseries();
        for (org.fao.fi.fishstat.core.xmlbinds.workspaces.datasets.Timeseries cnd_timeseries : timeseriess) {
            Timeseries ori_timeseries = original.getTimeseries(cnd_timeseries.getAcronym());
            if (ori_timeseries == null) continue;
            this.logger.log((IStatus)new Status(2, this.getClass().getName(), "Dataset: " + original.getAcronym() + " import skipped: An identical dataset already exists"));
            return false;
        }
        return true;
    }

    @Override
    public List<Relationship> importMissinggroups(Reader reader, Object[] elements, IProgressMonitor monitor) throws Exception {
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Name.class, Description.class, FishstatjMissingrelations.class});
        Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = schemaFactory.newSchema(new URL("http://www.fao.org/fishery/static/FishStatJ/schema/3_04/missingrelations.xsd"));
        jaxbUnmarshaller.setSchema(schema);
        JAXBElement root = jaxbUnmarshaller.unmarshal((Source)new StreamSource(reader), FishstatjMissingrelations.class);
        FishstatjMissingrelations fishstatjMissingrelations = (FishstatjMissingrelations)root.getValue();
        List<Relationship> res = this.processMissinggroups(fishstatjMissingrelations, elements, monitor);
        CoreCommons.getWorkspaceStatus().fireModifyEvent(ReferenceObject.class);
        return res;
    }

    @Override
    public int importCustomgroups(Reader reader, List<String> elements, IProgressMonitor monitor) throws Exception {
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Name.class, Description.class, FishstatjCustomgroups.class});
        Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = schemaFactory.newSchema(new URL("http://www.fao.org/fishery/static/FishStatJ/schema/3_04/customgroups.xsd"));
        jaxbUnmarshaller.setSchema(schema);
        JAXBElement root = jaxbUnmarshaller.unmarshal((Source)new StreamSource(reader), FishstatjCustomgroups.class);
        FishstatjCustomgroups fishstatjCustomgroups = (FishstatjCustomgroups)root.getValue();
        int res = this.processImportMessage(fishstatjCustomgroups, elements, monitor);
        CoreCommons.getWorkspaceStatus().fireModifyEvent(ReferenceObject.class);
        return res;
    }

    private int processImportMessage(FishstatjCustomgroups fishstatjCustomgroups, List<String> elements, IProgressMonitor monitor) throws Exception {
        int res = 0;
        if (monitor != null) {
            monitor.beginTask("FishStatJ workspace console - Datasets and Timeseries import ", elements.size());
        }
        for (Customgroup customgroup : fishstatjCustomgroups.getCustomgroup()) {
            if (!elements.contains(Integer.toString(customgroup.getId()))) continue;
            if (monitor != null) {
                monitor.subTask("Processing custom group " + customgroup.getId());
            }
            if (this.processCustomgroup(customgroup)) {
                ++res;
            }
            if (monitor == null) continue;
            monitor.worked(1);
        }
        if (monitor != null) {
            monitor.done();
        }
        return res;
    }

    private List<Relationship> processMissinggroups(FishstatjMissingrelations fishstatjMissingrelations, Object[] elements, IProgressMonitor monitor) throws Exception {
        ArrayList<Relationship> res = new ArrayList<Relationship>();
        if (monitor != null) {
            monitor.beginTask("FishStatJ workspace console - Missing relations import ", elements.length);
        }
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object elementObject = objectArray[n2];
            if (elementObject instanceof Element) {
                Element element = (Element)elementObject;
                for (Relationship rel : fishstatjMissingrelations.getRelationships().getRelationship()) {
                    if (!element.getAttribute("acronym").equals(rel.getAcronym())) continue;
                    res.add(rel);
                    this.persistRelationship(rel);
                }
            }
            ++n2;
        }
        if (monitor != null) {
            monitor.done();
        }
        return res;
    }

    @Override
    public int createMissingRelations(List<Relationship> rels) {
        try {
            for (Relationship relationship : rels) {
                org.fao.fi.fishstat.data.reference.api.Concept parentConcept = ReferenceServiceFactory.getService().getConcept(relationship.getParent());
                org.fao.fi.fishstat.data.reference.api.Concept childConcept = ReferenceServiceFactory.getService().getConcept(relationship.getChild());
                org.fao.fi.fishstat.data.reference.api.Concept intermediateConcept = this.findIntermediateConcept(parentConcept, childConcept);
                org.fao.fi.fishstat.data.reference.api.Relationship relNew = ReferenceServiceFactory.getService().getRelationship(parentConcept, childConcept);
                org.fao.fi.fishstat.data.reference.api.Relationship relStep1 = ReferenceServiceFactory.getService().getRelationship(parentConcept, intermediateConcept);
                org.fao.fi.fishstat.data.reference.api.Relationship relStep2 = ReferenceServiceFactory.getService().getRelationship(intermediateConcept, childConcept);
                int relCounter = 0;
                for (ReferenceObject ro1 : parentConcept.getObjects()) {
                    HashSet<ReferenceObject> newChildren = new HashSet<ReferenceObject>();
                    for (ReferenceObject ro2 : relStep1.getChildren(ro1)) {
                        for (ReferenceObject ro3 : relStep2.getChildren(ro2)) {
                            newChildren.add(ro3);
                            ++relCounter;
                        }
                    }
                    relNew.addChildren(ro1, newChildren);
                }
                this.logger.log((IStatus)new Status(1, this.getClass().getName(), "added " + relCounter + " records " + parentConcept.getAcronym() + "->" + childConcept.getAcronym()));
            }
        }
        catch (Exception e) {
            this.logger.log((IStatus)new Status(4, this.getClass().getName(), "while adding records parent->child Concept", (Throwable)e));
            return 1;
        }
        return 0;
    }

    private org.fao.fi.fishstat.data.reference.api.Concept findIntermediateConcept(org.fao.fi.fishstat.data.reference.api.Concept parentConcept, org.fao.fi.fishstat.data.reference.api.Concept childConcept) {
        for (org.fao.fi.fishstat.data.reference.api.Concept level1 : parentConcept.getChildrenConcepts()) {
            for (org.fao.fi.fishstat.data.reference.api.Concept level2 : level1.getChildrenConcepts()) {
                if (!level2.equals(childConcept)) continue;
                return level1;
            }
        }
        return null;
    }

    private void persistRelationship(Relationship rel) {
        ConceptRelationshipModelImpl res = new ConceptRelationshipModelImpl();
        res.setAcronym(rel.getAcronym());
        res.setName(this.getMultilingualName(rel.getName()));
        res.setDescription(this.getMultilingualDescription(rel.getDescription()));
        res.setSortorder(rel.getSortOrder());
        res.setParent(ReferenceServiceFactory.getService().getConcept(rel.getParent()));
        res.setChild(ReferenceServiceFactory.getService().getConcept(rel.getChild()));
        try {
            ReferencePersistenceService referencePersistenceService = PersistenceServiceFactory.getReferenceService();
            referencePersistenceService.persistConceptRelationship(res);
            this.logger.log((IStatus)new Status(0, this.getClass().getName(), "add missing Relationship Model " + rel.getParent() + "->" + rel.getChild() + " (" + rel.getSortOrder() + ")"));
        }
        catch (Exception e) {
            this.logger.log((IStatus)new Status(4, this.getClass().getName(), "add missing Relationship Model " + rel.getParent() + "->" + rel.getChild(), (Throwable)e));
        }
    }

    private MultilingualStringWrapper getMultilingualName(List<Name> names) {
        MultilingualStringWrapper res = new MultilingualStringWrapper();
        for (Name name : names) {
            res.setValue(name.getLang(), name.getValue());
        }
        return res;
    }

    private MultilingualStringWrapper getMultilingualDescription(List<Description> descriptions) {
        MultilingualStringWrapper res = new MultilingualStringWrapper();
        for (Description description : descriptions) {
            res.setValue(description.getLang(), description.getValue());
        }
        return res;
    }

    private boolean processCustomgroup(Customgroup cnd_customgroup) throws Exception {
        Identifier id = IdentifierFactory.instance((int)cnd_customgroup.getId());
        ReferenceObject ori_customgroup = ReferenceServiceFactory.getService().getConcept("CUSTOM_GROUP").getObject(id);
        if (ori_customgroup == null) {
            this.importNewCustomgroupDefinition(cnd_customgroup);
            return true;
        }
        if (this.compareCustomgroups(cnd_customgroup, ori_customgroup)) {
            this.updateCustomgroup(cnd_customgroup);
            return true;
        }
        return false;
    }

    private void updateCustomgroup(Customgroup xml_customgroup) throws Exception {
        this.logger.log((IStatus)new Status(4, this.getClass().getName(), "Custom group: " + xml_customgroup.getId() + "-" + xml_customgroup.getConcept() + " already exists."));
    }

    private void importNewCustomgroupDefinition(Customgroup xml_customgroup) throws Exception {
        ReferenceObject custom_group = WorkspaceAdapters.getCustomGroup(xml_customgroup);
        Identifier cg_id = IdentifierFactory.instance((int)xml_customgroup.getId());
        PersistenceServiceFactory.getReferenceService().persistCustomGroup(custom_group, cg_id);
        this.logger.log((IStatus)new Status(1, this.getClass().getName(), "Custom group " + xml_customgroup.getId() + "-" + xml_customgroup.getConcept() + " successfully created"));
    }

    private boolean compareCustomgroups(Customgroup candidate, ReferenceObject original) {
        return true;
    }

    @Override
    public TimeSeriesStructure importTimeSeriesStructure(Reader reader) throws Exception {
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Name.class, Description.class, FishstatjExchangeTs.class});
        Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = schemaFactory.newSchema(new URL("http://www.fao.org/fishery/static/FishStatJ/schema/3_04/tsexchnages.xsd"));
        jaxbUnmarshaller.setSchema(schema);
        JAXBElement root = jaxbUnmarshaller.unmarshal((Source)new StreamSource(reader), FishstatjExchangeTs.class);
        TimeSeriesStructure res = TimeSeriesStructureAdapter.getTimeSeriesStructure((FishstatjExchangeTs)root.getValue());
        return res;
    }

    @Override
    public boolean importAttachments(File file, List<AttachmentDescriptor> elements, boolean scratch, IProgressMonitor monitor) {
        if (scratch) {
            try {
                TimeseriesServiceHelper.removeAllAttachments();
            }
            catch (Exception e) {
                this.logger.log((IStatus)new Status(4, this.getClass().getName(), "Delete existing attachments", (Throwable)e));
                return false;
            }
        }
        for (AttachmentDescriptor attachmentDescriptor : elements) {
            try {
                TimeseriesManagementServiceFactory.getService().checkDescriptor(attachmentDescriptor);
                TimeseriesManagementServiceFactory.getService().addAttachment(attachmentDescriptor);
            }
            catch (TimeseriesManagementException e) {
                this.logger.log((IStatus)new Status(4, this.getClass().getName(), attachmentDescriptor.getAcronym(), (Throwable)e));
                return false;
            }
        }
        try {
            ZipFile zipFile = new ZipFile(file);
            Enumeration<? extends ZipEntry> zipEntries = zipFile.entries();
            while (zipEntries.hasMoreElements()) {
                ZipEntry zipEntry = zipEntries.nextElement();
                InputStream inputStream = zipFile.getInputStream(zipEntry);
                if (!zipEntry.getName().equals("attachments.xml")) {
                    int n;
                    byte[] buf = new byte[1024];
                    String entryName = zipEntry.getName();
                    File dest_file = new File(CoreRegistry.getAttachmentsPath(), entryName);
                    dest_file.createNewFile();
                    FileOutputStream outstream = new FileOutputStream(dest_file);
                    while ((n = inputStream.read(buf, 0, 1024)) > -1) {
                        outstream.write(buf, 0, n);
                    }
                    outstream.close();
                    this.logger.log((IStatus)new Status(1, this.getClass().getName(), "Attachment file extracted to workspace: " + entryName));
                }
                inputStream.close();
            }
            zipFile.close();
        }
        catch (Exception e) {
            this.logger.log((IStatus)new Status(4, this.getClass().getName(), "Copying attachments from " + file.getName(), (Throwable)e));
            return false;
        }
        return true;
    }
}

