/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.core.xmlbinds.workspaces;

import org.fao.fi.fishstat.core.model.exchange.timeseries.TimeSeriesStructure;
import org.fao.fi.fishstat.core.model.exchange.timeseries.TimeSeriesStructureElementImpl;
import org.fao.fi.fishstat.core.model.exchange.timeseries.TimeSeriesStructureImpl;
import org.fao.fi.fishstat.core.xmlbinds.workspaces.TSDException;
import org.fao.fi.fishstat.core.xmlbinds.workspaces.TimeSeriesStructureValidationEngine;
import org.fao.fi.fishstat.core.xmlbinds.workspaces.tsexchanges.Element;
import org.fao.fi.fishstat.core.xmlbinds.workspaces.tsexchanges.FishstatjExchangeTs;
import org.fao.fi.fishstat.core.xmlbinds.workspaces.tsexchanges.Timeseries;
import org.fao.fi.fishstat.data.reference.api.Attribute;
import org.fao.fi.fishstat.data.reference.api.Concept;
import org.fao.fi.fishstat.data.reference.api.ReferenceServiceFactory;
import org.fao.fi.fishstat.data.timeseries.api.Dataset;
import org.fao.fi.fishstat.data.timeseries.api.Dimension;
import org.fao.fi.fishstat.data.timeseries.api.ObservationPeriod;
import org.fao.fi.fishstat.data.timeseries.api.TimeResolution;
import org.fao.fi.fishstat.data.timeseries.api.TimeseriesServiceFactory;

public class TimeSeriesStructureAdapter {
    public static TimeSeriesStructure getTimeSeriesStructure(FishstatjExchangeTs fishstatjExchangeTs) throws TSDException {
        Timeseries timeseries = fishstatjExchangeTs.getTimeseries();
        Dataset structDataset = TimeseriesServiceFactory.getService().getDataset(timeseries.getDataset());
        if (structDataset == null) {
            throw new TSDException("Undefined dataset \"" + timeseries.getDataset() + "\" in timeseries structure");
        }
        org.fao.fi.fishstat.data.timeseries.api.Timeseries strucTimeseries = structDataset.getTimeseries(timeseries.getAcronym());
        if (strucTimeseries == null) {
            throw new TSDException("Undefined timeseries \"" + timeseries.getAcronym() + "\" in timeseries structure");
        }
        TimeSeriesStructureImpl res = new TimeSeriesStructureImpl(strucTimeseries, structDataset);
        res.setDatasource(timeseries.getDatasource());
        res.setFirstPeriod(new ObservationPeriod(timeseries.getFirstperiod()));
        res.setLastPeriod(new ObservationPeriod(timeseries.getLastperiod()));
        res.setTimeResolution(TimeResolution.valueOf((String)timeseries.getTimeresolution()));
        if (timeseries.getProtocol().equals("CSV")) {
            res.setProtocol(1);
        } else if (timeseries.getProtocol().equals("XML")) {
            res.setProtocol(10);
        } else if (timeseries.getProtocol().equals("SDMX_COMPACT")) {
            res.setProtocol(20);
        } else {
            throw new TSDException("Unrecognized protocol");
        }
        if (timeseries.getStructure().equals("NORMALIZED")) {
            res.setStructure(1);
        } else if (timeseries.getStructure().equals("DENORMALIZED")) {
            res.setStructure(2);
        } else {
            throw new TSDException("Unrecognized structure: " + timeseries.getStructure());
        }
        for (Element element : timeseries.getElement()) {
            TimeSeriesStructureElementImpl structureElement = new TimeSeriesStructureElementImpl(element.getLabel());
            if (element.getCardinality().equals("SINGLE")) {
                structureElement.setCardinality(1);
            } else if (element.getCardinality().equals("MULTIPLE")) {
                structureElement.setCardinality(2);
            } else {
                throw new TSDException("Unrecognized element cardinality: " + element.getCardinality());
            }
            if (element.getType().equals("DIMENSION")) {
                structureElement.setType(10);
                Dimension dimension = structDataset.getDimension(element.getDimension());
                if (dimension == null) {
                    throw new TSDException("Undefined dimension \"" + element.getDimension() + "\" in timeseries structure");
                }
                structureElement.setDimension(dimension);
                Concept concept = ReferenceServiceFactory.getService().getConcept(element.getConcept());
                if (concept == null) {
                    throw new TSDException("Undefined concept \"" + element.getConcept() + "\" in timeseries structure");
                }
                structureElement.setConcept(concept);
                Attribute attribute = concept.getAttribute(TimeSeriesStructureAdapter.getAttributeToken(element.getAttribute(), 0));
                if (attribute == null) {
                    throw new TSDException("Timeseries structure: attribute " + element.getAttribute() + " not found in concept " + concept.getAcronym() + ".");
                }
                structureElement.setAttribute(attribute);
                structureElement.setLn(TimeSeriesStructureAdapter.getAttributeToken(element.getAttribute(), 1));
                structureElement.setPrimaryCode(element.isPricode());
            } else if (element.getType().equals("SERIES")) {
                structureElement.setType(11);
            } else {
                throw new TSDException("Unrecognized element type");
            }
            res.addElement(structureElement);
        }
        new TimeSeriesStructureValidationEngine().validateStructure(res);
        return res;
    }

    private static String getAttributeToken(String entry, int token) {
        if (entry.contains(":")) {
            return entry.split(":")[token];
        }
        return token == 0 ? entry : null;
    }
}

