/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.components.multilingual;

import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.fao.fi.fishstat.core.MultilingualStringWrapper;

public class MultiLingualStringValidator
implements IValidator {
    private boolean enforceEnglish;

    public MultiLingualStringValidator(boolean enforceEnglish) {
        this.enforceEnglish = enforceEnglish;
    }

    public IStatus validate(Object value) {
        MultilingualStringWrapper multilingualString;
        String english;
        if (value == null || !(value instanceof MultilingualStringWrapper)) {
            return ValidationStatus.error((String)"Expected a MultiLingualString");
        }
        if (this.enforceEnglish && ((english = (multilingualString = (MultilingualStringWrapper)value).getValue("en")) == null || english.isEmpty())) {
            return ValidationStatus.error((String)"The English localization is required");
        }
        return Status.OK_STATUS;
    }
}

