/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.components.multilingual;

import java.beans.Beans;
import java.util.Locale;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.fao.fi.fishstat.core.CoreCommons;
import org.fao.fi.fishstat.core.CoreUtils;
import org.fao.fi.fishstat.core.MultilingualStringWrapper;
import org.fao.fi.fishstat.data.common.api.MultilingualString;
import org.fao.fi.fishstat.data.common.api.ResourceManager;
import org.fao.fi.fishstat.data.reference.api.ReferenceObject;
import org.fao.fi.fishstat.data.reference.api.exceptions.ReferenceServiceException;
import org.fao.fi.fishstat.gui.components.ComponentsCommons;

public class MultilingualEditor
extends Composite {
    private FormToolkit toolkit = new FormToolkit(Display.getCurrent());
    private ModifyListener modifyListener;
    private MultilingualStringWrapper instance;
    private String lang;
    private CTabFolder tabFolder;
    private CTabItem[] tabitems;
    private Text[] textboxes;
    private boolean editable = true;
    int langSize = 0;

    public MultilingualEditor(Composite parent, int style, MultilingualStringWrapper value, String lang, boolean editable) {
        super(parent, style);
        this.lang = lang;
        this.instance = value;
        this.editable = editable;
        this.langSize = MultilingualString.LANGUAGES.size();
        this.textboxes = new Text[this.langSize];
        this.tabitems = new CTabItem[this.langSize];
        this.initComponents();
    }

    public MultilingualEditor(Composite parent, int style, MultilingualStringWrapper value, ModifyListener modifyListener, String lang, boolean editable) {
        super(parent, style);
        this.lang = lang;
        this.instance = value;
        this.editable = editable;
        this.modifyListener = modifyListener;
        this.langSize = MultilingualString.LANGUAGES.size();
        this.textboxes = new Text[this.langSize];
        this.tabitems = new CTabItem[this.langSize];
        this.initComponents();
    }

    protected void checkSubclass() {
    }

    private void initComponents() {
        this.setLayout((Layout)new FillLayout());
        this.tabFolder = new CTabFolder((Composite)this, 0);
        this.tabFolder.setSimple(false);
        this.toolkit.adapt((Control)this.tabFolder, true, true);
        this.tabFolder.setSelectionForeground(ComponentsCommons.getColor(0, 0, 128));
        this.tabFolder.setSelectionBackground(new Color[]{Display.getCurrent().getSystemColor(22), Display.getCurrent().getSystemColor(32), Display.getCurrent().getSystemColor(32)}, new int[]{50, 100});
        this.tabFolder.setBorderVisible(true);
        int i = 0;
        while (i < this.textboxes.length) {
            int idx;
            block7: {
                idx = i;
                this.tabitems[i] = new CTabItem(this.tabFolder, 0);
                if (!Beans.isDesignTime()) {
                    try {
                        if (ResourceManager.getJdbcUrl() == null) {
                            this.tabitems[i].setText((String)MultilingualString.LANGUAGES.get(i));
                            break block7;
                        }
                        ReferenceObject langRO = CoreCommons.getLanguages().getObject("ISO_2_CODE", MultilingualString.LANGUAGES.get(i));
                        this.tabitems[i].setText(CoreUtils.getCurrentLang((MultilingualString)((MultilingualString)langRO.getAttribute("NAME")), (String)this.lang) != null ? CoreUtils.getCurrentLang((MultilingualString)((MultilingualString)langRO.getAttribute("NAME")), (String)this.lang) : "");
                    }
                    catch (ReferenceServiceException e) {
                        ComponentsCommons.showExceptionWithStack(e);
                    }
                } else {
                    this.tabitems[i].setText((String)MultilingualString.LANGUAGES.get(i));
                }
            }
            this.textboxes[i] = new Text((Composite)this.tabFolder, super.getStyle());
            this.textboxes[i].setEditable(this.editable);
            if (this.modifyListener != null) {
                this.textboxes[i].addModifyListener(this.modifyListener);
            }
            this.textboxes[i].addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    MultilingualEditor.this.getInstance().setValue((String)MultilingualString.LANGUAGES.get(idx), ((Text)e.getSource()).getText());
                }
            });
            this.tabitems[i].setControl((Control)this.textboxes[i]);
            ++i;
        }
        this.tabFolder.setSelection(this.tabitems[0]);
    }

    public ReferenceObject getSelectedItemLanguage() {
        return CoreCommons.getLanguages().getObject("ISO_2_CODE", MultilingualString.LANGUAGES.get(this.tabFolder.getSelectionIndex()));
    }

    public void setEditable(boolean editable) {
        Text[] textArray = this.textboxes;
        int n = this.textboxes.length;
        int n2 = 0;
        while (n2 < n) {
            Text textbox = textArray[n2];
            textbox.setEditable(editable);
            ++n2;
        }
    }

    public void setEnabled(boolean enabled) {
        Text[] textArray = this.textboxes;
        int n = this.textboxes.length;
        int n2 = 0;
        while (n2 < n) {
            Text textbox = textArray[n2];
            textbox.setEditable(enabled);
            ++n2;
        }
    }

    public ModifyListener getModifyListener() {
        return this.modifyListener;
    }

    public void setModifyListener(ModifyListener modifyListener) {
        this.modifyListener = modifyListener;
    }

    public MultilingualStringWrapper getInstance() {
        return this.instance;
    }

    public void setValue(MultilingualString value) {
        int i = 0;
        while (i < MultilingualString.LANGUAGES.size()) {
            this.textboxes[i].setText(value.getValue((String)MultilingualString.LANGUAGES.get(i)));
            ++i;
        }
    }

    public void setValue(String lang, String value) {
        int idx = MultilingualString.LANGUAGES.indexOf(lang);
        this.instance.setValue(lang, value);
        this.textboxes[idx].setText(value == null ? "" : value);
    }

    public void setValue(Locale locale, String value) {
        int idx = MultilingualString.LANGUAGES.indexOf(locale.getLanguage());
        this.instance.setValue(locale, value);
        this.textboxes[idx].setText(value);
    }

    public int getLangSize() {
        return this.langSize;
    }

    public String getText(String locale) {
        if (MultilingualString.LANGUAGES.contains(locale)) {
            return this.textboxes[MultilingualString.LANGUAGES.lastIndexOf(locale)].getText();
        }
        return null;
    }

    public boolean hasText(String locale) {
        if (MultilingualString.LANGUAGES.contains(locale)) {
            return this.textboxes[MultilingualString.LANGUAGES.lastIndexOf(locale)].getText() != null && !this.textboxes[MultilingualString.LANGUAGES.lastIndexOf(locale)].getText().equals("");
        }
        return false;
    }
}

