/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.components.widgets.combos;

import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.fao.fi.fishstat.core.CoreUtils;
import org.fao.fi.fishstat.data.reference.api.Concept;
import org.fao.fi.fishstat.data.reference.api.ReferenceServiceFactory;

public class ConceptsComboViewer
extends ComboViewer {
    private String lang;

    public ConceptsComboViewer(Composite composite, int style, String lang) {
        super(composite, 0x10000000 | style);
        this.lang = lang;
        this.setContentProvider((IContentProvider)new AllConceptsContentProvider());
        this.setLabelProvider((IBaseLabelProvider)new AllConceptsLabelProvider());
        this.setComparator(new AllConceptsSorter());
    }

    public Concept getSelectedConcept() {
        StructuredSelection sel = (StructuredSelection)this.getSelection();
        return (Concept)sel.getFirstElement();
    }

    private class AllConceptsContentProvider
    implements IStructuredContentProvider {
        private AllConceptsContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return ReferenceServiceFactory.getService().getConcepts().toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class AllConceptsLabelProvider
    extends LabelProvider
    implements ILabelProvider {
        private AllConceptsLabelProvider() {
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            if (element instanceof Concept) {
                return CoreUtils.getCurrentLangName((Object)element, (String)ConceptsComboViewer.this.lang);
            }
            return "#ERROR#";
        }
    }

    private class AllConceptsSorter
    extends ViewerComparator {
        private AllConceptsSorter() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (e1 instanceof Concept && e2 instanceof Concept) {
                if (((Concept)e1).getAcronym().equals("CUSTOM_GROUP")) {
                    return 1;
                }
                if (((Concept)e2).getAcronym().equals("CUSTOM_GROUP")) {
                    return -1;
                }
                return CoreUtils.getCurrentLangName((Object)((Concept)e1), (String)ConceptsComboViewer.this.lang).compareTo(CoreUtils.getCurrentLangName((Object)((Concept)e2), (String)ConceptsComboViewer.this.lang));
            }
            return super.compare(viewer, e1, e2);
        }
    }
}

