/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.components.widgets.combos;

import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.fao.fi.fishstat.data.common.jdbc.JdbcDriverDescriptor;
import org.fao.fi.fishstat.data.common.jdbc.JdbcDriverRegistry;

public class JdbcDriversComboViewer
extends ComboViewer {
    public JdbcDriversComboViewer(Composite composite, int style) {
        super(composite, 0x10000000 | style);
        this.setContentProvider((IContentProvider)new JdbcDriversContentProvider());
        this.setLabelProvider((IBaseLabelProvider)new JdbcDriversProvider());
        this.setComparator(new JdbcDriversSorter());
    }

    public JdbcDriverDescriptor getSelectedDriver() {
        StructuredSelection sel = (StructuredSelection)this.getSelection();
        return (JdbcDriverDescriptor)sel.getFirstElement();
    }

    private class JdbcDriversContentProvider
    implements IStructuredContentProvider {
        private JdbcDriversContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement == null) {
                return new Object[0];
            }
            return JdbcDriverRegistry.getDescriptors().toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class JdbcDriversProvider
    extends LabelProvider
    implements ILabelProvider {
        private JdbcDriversProvider() {
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            if (element instanceof JdbcDriverDescriptor) {
                return ((JdbcDriverDescriptor)element).getId();
            }
            return "#ERROR#";
        }
    }

    private class JdbcDriversSorter
    extends ViewerComparator {
        private JdbcDriversSorter() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (e1 instanceof JdbcDriverDescriptor && e2 instanceof JdbcDriverDescriptor) {
                return ((JdbcDriverDescriptor)e1).getId().compareTo(((JdbcDriverDescriptor)e2).getId());
            }
            return ((String)e1).compareTo((String)e2);
        }
    }
}

