/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.components.widgets.combos;

import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.fao.fi.fishstat.core.CoreUtils;
import org.fao.fi.fishstat.data.reference.api.ReferenceServiceFactory;
import org.fao.fi.fishstat.data.reference.api.Relationship;

public class RelationshipsComboViewer
extends ComboViewer {
    private String lang;

    public RelationshipsComboViewer(Composite composite, int style, String lang) {
        super(composite, 0x10000000 | style);
        this.lang = lang;
        this.setContentProvider((IContentProvider)new AllRelationshipsContentProvider());
        this.setLabelProvider((IBaseLabelProvider)new AllRelationshipsLabelProvider());
        this.setComparator(new AllConceptRelationsSorter());
    }

    public Relationship getSelectedRelationship() {
        StructuredSelection sel = (StructuredSelection)this.getSelection();
        return (Relationship)sel.getFirstElement();
    }

    private class AllConceptRelationsSorter
    extends ViewerComparator {
        private AllConceptRelationsSorter() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (e1 instanceof Relationship && e2 instanceof Relationship) {
                return CoreUtils.getCurrentLangName((Object)((Relationship)e1), (String)RelationshipsComboViewer.this.lang).compareTo(CoreUtils.getCurrentLangName((Object)((Relationship)e2), (String)RelationshipsComboViewer.this.lang));
            }
            return super.compare(viewer, e1, e2);
        }
    }

    private class AllRelationshipsContentProvider
    implements IStructuredContentProvider {
        private AllRelationshipsContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return ReferenceServiceFactory.getService().getRelationships().toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class AllRelationshipsLabelProvider
    extends LabelProvider
    implements ILabelProvider {
        private AllRelationshipsLabelProvider() {
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            if (element instanceof Relationship) {
                return CoreUtils.getCurrentLangName((Object)element, (String)RelationshipsComboViewer.this.lang);
            }
            return "#ERROR#";
        }
    }
}

