/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui;

import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.StatusLineContributionItem;
import org.eclipse.swt.widgets.Display;
import org.fao.fi.fishstat.core.CoreCommons;
import org.fao.fi.fishstat.core.model.aggregation.AggregationWrapper;
import org.fao.fi.fishstat.core.model.concept.selection.FilterWrapper;
import org.fao.fi.fishstat.data.common.api.MultilingualString;
import org.fao.fi.fishstat.data.reference.api.Concept;
import org.fao.fi.fishstat.data.reference.api.ReferenceObject;
import org.fao.fi.fishstat.data.reference.api.ReferenceServiceFactory;
import org.fao.fi.fishstat.gui.Activator;
import org.fao.fi.fishstat.gui.core.session.GuiSession;

public class StatusBarController {
    public static final String RECORD_NUMBER = "RECORD_NUMBER";
    public static final String TOTAL_RECORDS = "TOTAL_RECORDS";
    public static final String TIME_SERIES_UNIT = "TIME_SERIES_UNIT";
    private IStatusLineManager statusLineManager = null;
    private StatusLineContributionItem recordNumberContributionItem = new StatusLineContributionItem("RECORD_NUMBER", 20);
    private StatusLineContributionItem totalRecordsContributionItem = new StatusLineContributionItem("TOTAL_RECORDS", 30);
    private StatusLineContributionItem timeSeriesUnitContributionItem = new StatusLineContributionItem("TIME_SERIES_UNIT", 40);

    public void setRecordNumber(int number) {
        if (this.recordNumberContributionItem != null) {
            Display.getDefault().asyncExec(() -> this.recordNumberContributionItem.setText(String.valueOf(Activator.getLocalString("label.record.no.dot")) + " " + (number + 1) + " " + Activator.getLocalString("label.of.first.lower")));
        }
    }

    public void cleanRecordNumber() {
        if (this.recordNumberContributionItem != null) {
            Display.getDefault().asyncExec(() -> this.recordNumberContributionItem.setText(""));
        }
    }

    public void setTotalRecords(GuiSession session) {
        if (this.totalRecordsContributionItem == null) {
            return;
        }
        int totalObservations = 0;
        if (session.getLastResult() != null) {
            try {
                totalObservations = session.getLastResult().getObservations().size();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        AggregationWrapper aggreg = session.getAggregationRequest();
        FilterWrapper filter = session.getFilterRequest();
        if (aggreg == null && filter != null && !filter.hasFilterSet()) {
            String text = String.valueOf(Integer.toString(totalObservations)) + " " + Activator.getLocalString("label.records");
            Display.getDefault().asyncExec(() -> this.totalRecordsContributionItem.setText(text));
            return;
        }
        if (aggreg != null && filter != null && !filter.hasFilterSet()) {
            String text = String.valueOf(Integer.toString(totalObservations)) + " " + Activator.getLocalString("label.aggregated.records");
            Display.getDefault().asyncExec(() -> this.totalRecordsContributionItem.setText(text));
            return;
        }
        String text = String.valueOf(Integer.toString(totalObservations)) + " " + Activator.getLocalString("label.filtered.records");
        Display.getDefault().asyncExec(() -> this.totalRecordsContributionItem.setText(text));
    }

    public void setRecordNumberOf(int recno, int of) {
        if (this.recordNumberContributionItem != null && this.totalRecordsContributionItem != null) {
            Display.getDefault().asyncExec(() -> {
                this.recordNumberContributionItem.setText(String.valueOf(Activator.getLocalString("label.record.no.dot")) + " " + recno + " " + Activator.getLocalString("label.of.first.lower"));
                this.totalRecordsContributionItem.setText(String.valueOf(of) + " " + Activator.getLocalString("label.filtered.records"));
            });
        }
    }

    public void setUnit(String[] unit) {
        if (this.timeSeriesUnitContributionItem != null && unit != null && unit.length > 0) {
            Display.getDefault().asyncExec(() -> {
                if (unit[0] == null || unit[1] == null) {
                    this.timeSeriesUnitContributionItem.setText("");
                } else if (unit[0].equals("t") && unit[1].equals("0")) {
                    this.timeSeriesUnitContributionItem.setText(String.valueOf(Activator.getLocalString("label.unit.column")) + " " + this.getMeasureDisplay("Q_t_1"));
                } else if (unit[0].equals("tlw")) {
                    this.timeSeriesUnitContributionItem.setText(String.valueOf(Activator.getLocalString("label.unit.column")) + " " + this.getMeasureDisplay("Q_tlw"));
                } else if (unit[0].equals("tpw")) {
                    this.timeSeriesUnitContributionItem.setText(String.valueOf(Activator.getLocalString("label.unit.column")) + " " + this.getMeasureDisplay("Q_tpw"));
                } else {
                    this.timeSeriesUnitContributionItem.setText(String.valueOf(Activator.getLocalString("label.unit.column")) + " " + unit[0] + this.processMultiplier(unit[1]));
                }
            });
        }
    }

    private String getMeasureDisplay(String measureCode) {
        Concept concept = ReferenceServiceFactory.getService().getConcept("MEASURE");
        ReferenceObject refObject = concept.getObject(concept.getAttribute("CODE"), (Object)measureCode);
        Object nameAtt = refObject.getAttribute("NAME");
        return ((MultilingualString)nameAtt).getValue(CoreCommons.LOCALE2);
    }

    private String processMultiplier(String multiplier) {
        if (multiplier != null) {
            try {
                int intMultiplier = Integer.decode(multiplier);
                if (intMultiplier > 1) {
                    int pow = (int)Math.pow(10.0, intMultiplier);
                    return " x " + pow;
                }
            }
            catch (NumberFormatException e) {
                return "";
            }
        }
        return "";
    }

    public IStatusLineManager getStatusLineManager() {
        return this.statusLineManager;
    }

    protected void setStatusLineManager(IStatusLineManager statusLineManager) {
        this.statusLineManager = statusLineManager;
    }

    public void activateContributions() {
        if (this.statusLineManager.find(RECORD_NUMBER) == null) {
            this.statusLineManager.add((IContributionItem)this.recordNumberContributionItem);
        }
        if (this.statusLineManager.find(TOTAL_RECORDS) == null) {
            this.statusLineManager.insertAfter(RECORD_NUMBER, (IContributionItem)this.totalRecordsContributionItem);
        }
        if (this.statusLineManager.find(TIME_SERIES_UNIT) == null) {
            this.statusLineManager.insertAfter(TOTAL_RECORDS, (IContributionItem)this.timeSeriesUnitContributionItem);
        }
        this.statusLineManager.update(false);
    }

    public void deactivateAllContribtions() {
        this.statusLineManager.removeAll();
        this.statusLineManager.update(false);
    }
}

