/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.autoupdate;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.net.Authenticator;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;
import org.fao.fi.fishstat.autoupdate.gen.AutoUpdate;
import org.fao.fi.fishstat.autoupdate.gen.AutoUpdateWks;
import org.fao.fi.fishstat.core.CoreCommons;
import org.fao.fi.fishstat.core.VersionId;
import org.fao.fi.fishstat.gui.Activator;
import org.osgi.framework.FrameworkUtil;

public class AutoUpdateMain {
    private boolean hasValidAutoUpdate = false;
    private AutoUpdate autoupdate = null;
    String currentVersionURL = null;

    public AutoUpdateMain() {
        try {
            this.currentVersionURL = Activator.getDefault().getPreferenceStore().getString("xml.version.url");
            String versionXML = this.getCurrentVersionXML();
            if (versionXML == null || versionXML.isEmpty()) {
                Activator.getDefault().getLog().log((IStatus)new Status(2, this.getClass().getName(), MessageFormat.format(Activator.getPluginBundle().getString("autoupdate.error.downloadfailed"), this.currentVersionURL)));
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"FishStatJ is working off-line", (String)(this.currentVersionURL == null ? "Cannot connect to www.fao.org" : String.valueOf(this.currentVersionURL) + "\n" + "a check for application updates and download of data is not possible.\n\n" + "Only workspaces installed previously are available.\n\n" + "To fix this, please connect to the internet or update firewall settings."));
                return;
            }
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{AutoUpdate.class});
            Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
            this.autoupdate = (AutoUpdate)jaxbUnmarshaller.unmarshal((Reader)new StringReader(versionXML));
            if (this.autoupdate.getAutoUpdateWks().isEmpty()) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, this.getClass().getName(), Activator.getPluginBundle().getString("autoupdate.error.noworkspaces")));
                return;
            }
            Activator.getDefault().getLog().log((IStatus)new Status(1, this.getClass().getName(), MessageFormat.format(Activator.getPluginBundle().getString("autoupdate.status"), AutoUpdateMain.getCurrentVersion().toString(), this.autoupdate.getVersion(), this.autoupdate.getDate(), this.currentVersionURL)));
            this.hasValidAutoUpdate = true;
        }
        catch (Exception exp) {
            Activator.getDefault().getLog().log((IStatus)new Status(1, this.getClass().getName(), MessageFormat.format(Activator.getPluginBundle().getString("autoupdate.error.general"), this.currentVersionURL), (Throwable)exp));
        }
    }

    private static VersionId getCurrentVersion() {
        String version = FrameworkUtil.getBundle(AutoUpdateMain.class).getVersion().toString();
        if (version.split("\\.").length == 4) {
            version = version.substring(0, version.lastIndexOf(46));
        }
        return new VersionId(version);
    }

    public List<AutoUpdateWks> getAutoupdateWorkspaces() {
        if (!this.hasValidAutoUpdate) {
            return new ArrayList<AutoUpdateWks>();
        }
        return this.autoupdate.getAutoUpdateWks();
    }

    private String getCurrentVersionXML() {
        HttpURLConnection httpConnn;
        StringBuilder sbuf;
        String inputLine;
        block8: {
            block7: {
                inputLine = null;
                sbuf = null;
                httpConnn = null;
                httpConnn = AutoUpdateMain.openConnection(this.currentVersionURL);
                if (httpConnn != null) break block7;
                return null;
            }
            httpConnn.setConnectTimeout(0);
            httpConnn.setReadTimeout(0);
            httpConnn.setRequestMethod("GET");
            httpConnn.connect();
            int code = httpConnn.getResponseCode();
            if (code == 200) break block8;
            return null;
        }
        try {
            sbuf = new StringBuilder();
            BufferedReader in = new BufferedReader(new InputStreamReader(httpConnn.getInputStream(), StandardCharsets.UTF_8));
            while ((inputLine = in.readLine()) != null) {
                sbuf.append(inputLine);
                sbuf.append("\r\n");
            }
            in.close();
            httpConnn.disconnect();
        }
        catch (UnknownHostException e1) {
            Activator.getDefault().getLog().log((IStatus)new Status(2, this.getClass().getName(), MessageFormat.format(Activator.getPluginBundle().getString("autoupdate.error.resolvehost"), this.currentVersionURL)));
            return null;
        }
        catch (ConnectException e2) {
            Activator.getDefault().getLog().log((IStatus)new Status(2, this.getClass().getName(), MessageFormat.format(Activator.getPluginBundle().getString("autoupdate.error.connectto"), this.currentVersionURL)));
            return null;
        }
        catch (Exception exp) {
            Activator.getDefault().getLog().log((IStatus)new Status(2, this.getClass().getName(), MessageFormat.format(Activator.getPluginBundle().getString("autoupdate.error.downloadfrom"), this.currentVersionURL)));
            return null;
        }
        return sbuf.toString();
    }

    public static HttpURLConnection openConnection(String httpURL) {
        HttpURLConnection httpConnn = null;
        Proxy proxy = null;
        try {
            final IPreferenceStore ps = Activator.getDefault().getPreferenceStore();
            if (ps.getBoolean("proxy.acticated")) {
                Activator.getDefault().getLog().log((IStatus)new Status(1, AutoUpdateMain.class.getName(), MessageFormat.format(Activator.getPluginBundle().getString("autoupdate.proxy"), ps.getString("proxy.server.ip"), ps.getInt("proxy.server.port"))));
                proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(ps.getString("proxy.server.ip"), ps.getInt("proxy.server.port")));
                httpConnn = (HttpURLConnection)new URL(httpURL).openConnection(proxy);
                if (ps.getString("proxy.server.user").length() > 1) {
                    Authenticator authenticator = new Authenticator(){

                        @Override
                        public PasswordAuthentication getPasswordAuthentication() {
                            return new PasswordAuthentication(ps.getString("proxy.server.user"), ps.getString("proxy.server.password").toCharArray());
                        }
                    };
                    Authenticator.setDefault(authenticator);
                }
            } else {
                httpConnn = (HttpURLConnection)new URL(httpURL).openConnection();
            }
        }
        catch (Exception exp) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, AutoUpdateMain.class.getName(), Activator.getPluginBundle().getString("autoupdate.error.cannotconnect"), (Throwable)exp));
            return null;
        }
        httpConnn.setRequestProperty("User-Agent", "FishStatJ v" + AutoUpdateMain.getCurrentVersion().toString() + " " + System.getProperty("os.name") + "x" + AutoUpdateMain.getBitness() + "bit");
        return httpConnn;
    }

    private static int getBitness() {
        String[] keys;
        String[] stringArray = keys = new String[]{"sun.arch.data.model", "com.ibm.vm.bitmode", "os.arch"};
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            String property = System.getProperty(key);
            if (property != null && property.indexOf("64") >= 0) {
                return 64;
            }
            ++n2;
        }
        return 32;
    }

    private boolean isNewVersionAvailable() {
        if (!this.hasValidAutoUpdate) {
            return false;
        }
        VersionId updateVersion = new VersionId(this.autoupdate.getVersion());
        return updateVersion.compareTo(AutoUpdateMain.getCurrentVersion()) > 0;
    }

    private void openWebSite() {
        if (!this.hasValidAutoUpdate) {
            return;
        }
        try {
            String osName = System.getProperty("os.name").toLowerCase();
            String updateURL = this.autoupdate.getUrl();
            if (updateURL == null) {
                return;
            }
            if (osName.indexOf("windows") != -1) {
                Runtime.getRuntime().exec("explorer.exe \"" + updateURL + "\"");
            } else if (osName.indexOf("mac") != -1) {
                Runtime.getRuntime().exec(new String[]{"open", "-a", "Safari", updateURL});
            } else {
                Runtime.getRuntime().exec(new String[]{"/usr/bin/open", updateURL});
            }
        }
        catch (IOException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, this.getClass().getName(), "cannot open web-site", (Throwable)e));
        }
    }

    public String openManual() {
        File workspaceRoot = CoreCommons.getWorkspacesManager().getRoot();
        File manualFolder = new File(String.valueOf(workspaceRoot.getAbsolutePath()) + File.separator + "manual");
        if (!manualFolder.exists() && !manualFolder.mkdir()) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, this.getClass().getName(), Activator.getPluginBundle().getString("autoupdate.error.manualfolder")));
            return Activator.getPluginBundle().getString("autoupdate.error.manualfolder");
        }
        String manualPath = null;
        String manualURL = null;
        if (this.hasValidAutoUpdate) {
            manualURL = this.autoupdate.getManual();
            manualPath = String.valueOf(manualFolder.getAbsolutePath()) + File.separator + manualURL.substring(manualURL.lastIndexOf(47) + 1, manualURL.length());
            if (!new File(manualPath).exists()) {
                this.downloadFile(manualURL, manualPath);
                if (!new File(manualPath).exists()) {
                    Activator.getDefault().getLog().log((IStatus)new Status(4, this.getClass().getName(), Activator.getPluginBundle().getString("autoupdate.error.download")));
                    return Activator.getPluginBundle().getString("autoupdate.error.download");
                }
            }
        } else {
            File[] manuals = manualFolder.listFiles();
            if (manuals.length == 0) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, this.getClass().getName(), Activator.getPluginBundle().getString("autoupdate.error.nocachedpdf")));
                return Activator.getPluginBundle().getString("autoupdate.error.nocachedpdf");
            }
            manualPath = manuals[manuals.length - 1].getAbsolutePath();
            Activator.getDefault().getLog().log((IStatus)new Status(1, this.getClass().getName(), MessageFormat.format(Activator.getPluginBundle().getString("autoupdate.path"), manualPath)));
        }
        if (manualPath == null) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, this.getClass().getName(), Activator.getPluginBundle().getString("autoupdate.error.invalidpath")));
            return Activator.getPluginBundle().getString("autoupdate.error.invalidpath");
        }
        if (!this.openPDF(manualPath)) {
            return Activator.getPluginBundle().getString("autoupdate.error.openpdf");
        }
        return null;
    }

    public String openQuickRef() {
        File workspaceRoot = CoreCommons.getWorkspacesManager().getRoot();
        File manualFolder = new File(String.valueOf(workspaceRoot.getAbsolutePath()) + File.separator + "quickref");
        if (!manualFolder.exists() && !manualFolder.mkdir()) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, this.getClass().getName(), Activator.getPluginBundle().getString("autoupdate.error.manualfolder")));
            return Activator.getPluginBundle().getString("autoupdate.error.manualfolder");
        }
        String manualPath = null;
        String manualURL = null;
        if (this.hasValidAutoUpdate) {
            manualURL = this.autoupdate.getQuickref();
        }
        if (manualURL != null) {
            manualPath = String.valueOf(manualFolder.getAbsolutePath()) + File.separator + manualURL.substring(manualURL.lastIndexOf(47) + 1, manualURL.length());
            if (!new File(manualPath).exists() || new File(manualPath).length() < 5000L) {
                this.downloadFile(manualURL, manualPath);
                if (!new File(manualPath).exists()) {
                    Activator.getDefault().getLog().log((IStatus)new Status(4, this.getClass().getName(), Activator.getPluginBundle().getString("autoupdate.error.download")));
                    return Activator.getPluginBundle().getString("autoupdate.error.download");
                }
            }
        } else {
            File[] manuals = manualFolder.listFiles();
            if (manuals.length == 0) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, this.getClass().getName(), Activator.getPluginBundle().getString("autoupdate.error.nocachedpdf")));
                return Activator.getPluginBundle().getString("autoupdate.error.nocachedpdf");
            }
            manualPath = manuals[manuals.length - 1].getAbsolutePath();
            Activator.getDefault().getLog().log((IStatus)new Status(1, this.getClass().getName(), "manualPath=" + manualPath));
        }
        if (manualPath == null) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, this.getClass().getName(), Activator.getPluginBundle().getString("autoupdate.error.invalidpath")));
            return Activator.getPluginBundle().getString("autoupdate.error.invalidpath");
        }
        if (!this.openPDF(manualPath)) {
            return Activator.getPluginBundle().getString("autoupdate.error.openpdf");
        }
        return null;
    }

    boolean openPDF(String pdfPath) {
        try {
            String osName = System.getProperty("os.name").toLowerCase();
            if (osName.indexOf("windows") != -1) {
                Runtime.getRuntime().exec("explorer.exe \"" + new File(pdfPath).toURI().toURL().toString() + "\"");
            } else if (osName.indexOf("mac") != -1) {
                Runtime.getRuntime().exec(new String[]{"open", "-a", "Finder", new File(pdfPath).toURI().toURL().toString()});
            } else {
                Runtime.getRuntime().exec(new String[]{"/usr/bin/open", new File(pdfPath).getAbsolutePath()});
            }
        }
        catch (Exception e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, this.getClass().getName(), Activator.getPluginBundle().getString("autoupdate.error.openpdf"), (Throwable)e));
            return false;
        }
        return true;
    }

    private void downloadFile(final String httpURL, final String outFileName) {
        try {
            IProgressService service = PlatformUI.getWorkbench().getProgressService();
            service.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    AutoUpdateMain.this.httpGetFile(httpURL.replace(" ", "%20"), outFileName, monitor);
                }
            });
        }
        catch (Exception e) {
            Activator.getDefault().getLog().log((IStatus)new Status(1, this.getClass().getName(), MessageFormat.format(Activator.getPluginBundle().getString("autoupdate.error.downloadfile"), httpURL), (Throwable)e));
        }
    }

    private void httpGetFile(final String httpURL, String outFileName, IProgressMonitor monitor) {
        Activator.getDefault().getLog().log((IStatus)new Status(1, this.getClass().getName(), "http_GetFile(" + httpURL + "," + outFileName + ")"));
        InputStream httpInStream = null;
        HttpURLConnection httpConnn = null;
        int fileLength = 0;
        try {
            httpConnn = AutoUpdateMain.openConnection(httpURL);
            if (httpConnn == null) {
                return;
            }
            try {
                httpConnn.setRequestMethod("HEAD");
                httpConnn.getInputStream();
                fileLength = httpConnn.getContentLength();
            }
            catch (FileNotFoundException e1) {
                httpConnn.disconnect();
                Activator.getDefault().getLog().log((IStatus)new Status(1, this.getClass().getName(), MessageFormat.format(Activator.getPluginBundle().getString("autoupdate.httpget.error.nofile"), httpURL)));
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Activator.getPluginBundle().getString("autoupdate.httpget.error"), (String)MessageFormat.format(Activator.getPluginBundle().getString("autoupdate.httpget.error.nofile"), httpURL));
                    }
                });
                return;
            }
            catch (Exception e2) {
                if (httpConnn != null) {
                    httpConnn.disconnect();
                }
                Activator.getDefault().getLog().log((IStatus)new Status(2, this.getClass().getName(), Activator.getPluginBundle().getString("autoupdate.httpget.error.openconnection"), (Throwable)e2));
                return;
            }
        }
        finally {
            if (httpConnn != null) {
                httpConnn.disconnect();
            }
        }
        String file = httpURL.substring(httpURL.lastIndexOf(47) + 1, httpURL.length());
        monitor.beginTask(MessageFormat.format(Activator.getPluginBundle().getString("autoupdate.httpget.downloading"), file), fileLength);
        try {
            httpConnn = AutoUpdateMain.openConnection(httpURL);
            if (httpConnn == null) {
                return;
            }
            Throwable throwable = null;
            Object var9_14 = null;
            try (FileOutputStream fos = new FileOutputStream(new File(outFileName));){
                int bufLength;
                httpConnn.setConnectTimeout(7000);
                httpConnn.setRequestMethod("GET");
                httpConnn.connect();
                int code = httpConnn.getResponseCode();
                if (code != 200) {
                    Activator.getDefault().getLog().log((IStatus)new Status(2, this.getClass().getName(), MessageFormat.format(Activator.getPluginBundle().getString("autoupdate.httpget.error.connection"), code)));
                    return;
                }
                httpInStream = httpConnn.getInputStream();
                byte[] byteBuffer = new byte[10000];
                while ((bufLength = httpInStream.read(byteBuffer)) != -1) {
                    fos.write(byteBuffer, 0, bufLength);
                    monitor.worked(bufLength);
                    if (!monitor.isCanceled()) continue;
                    Activator.getDefault().getLog().log((IStatus)new Status(1, this.getClass().getName(), Activator.getPluginBundle().getString("autoupdate.httpget.cancel")));
                    httpInStream.close();
                    httpConnn.disconnect();
                    monitor.done();
                    return;
                }
                httpInStream.close();
                httpConnn.disconnect();
                monitor.done();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            Activator.getDefault().getLog().log((IStatus)new Status(1, this.getClass().getName(), MessageFormat.format(Activator.getPluginBundle().getString("autoupdate.httpget.downloadok"), outFileName)));
        }
        catch (Exception e) {
            monitor.done();
            Activator.getDefault().getLog().log((IStatus)new Status(4, this.getClass().getName(), Activator.getPluginBundle().getString("autoupdate.httpget.error"), (Throwable)e));
        }
    }

    public void doAutoupdate() {
        if (this.isNewVersionAvailable()) {
            String osName = System.getProperty("os.name").toLowerCase();
            if (osName.indexOf("windows") != -1) {
                this.doAutoupdateWindows();
            } else if (MessageDialog.openQuestion((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Activator.getPluginBundle().getString("label.autoupdate.newversion.title"), (String)MessageFormat.format(Activator.getPluginBundle().getString("label.autoupdate.newversion.message"), this.autoupdate.getVersion()))) {
                this.openWebSite();
            }
        }
    }

    private void doAutoupdateWindows() {
        String exeDownloadURL = this.autoupdate.getDownloadwin();
        MessageDialog dialog = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), Activator.getPluginBundle().getString("label.autoupdate.newversion.title"), null, MessageFormat.format(Activator.getPluginBundle().getString("label.autoupdate.newversion.windows"), this.autoupdate.getVersion()), 2, new String[]{Activator.getPluginBundle().getString("autoupdate.ask.install"), Activator.getPluginBundle().getString("autoupdate.ask.manual"), Activator.getPluginBundle().getString("autoupdate.ask.cancel")}, 0);
        int result = dialog.open();
        if (result == 2) {
            return;
        }
        if (result == 1) {
            this.openWebSite();
            return;
        }
        String exePath = String.valueOf(Activator.getDefault().getPreferenceStore().getString("workspace.download.folder")) + File.separator + exeDownloadURL.substring(exeDownloadURL.lastIndexOf(47) + 1, exeDownloadURL.length());
        if (new File(exePath).exists()) {
            new File(exePath).delete();
        }
        this.downloadFile(exeDownloadURL, exePath);
        if (!new File(exePath).exists()) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, this.getClass().getName(), Activator.getPluginBundle().getString("autoupdate.error.download")));
            return;
        }
        ProcessBuilder processBuilder = new ProcessBuilder("cmd", "/c", "start", exePath);
        try {
            processBuilder.start();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        System.exit(0);
    }
}

