/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.dataset.aggregation;

import java.beans.Beans;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wb.swt.SWTResourceManager;
import org.fao.fi.fishstat.core.CoreRegistry;
import org.fao.fi.fishstat.core.IActionRequestWrapper;
import org.fao.fi.fishstat.core.IFSActions;
import org.fao.fi.fishstat.core.model.aggregation.AggregationWrapper;
import org.fao.fi.fishstat.core.model.aggregation.DimensionAggregation;
import org.fao.fi.fishstat.data.timeseries.api.Dimension;
import org.fao.fi.fishstat.gui.Activator;
import org.fao.fi.fishstat.gui.core.GuiCoreActivator;
import org.fao.fi.fishstat.gui.dataset.aggregation.AggregationComposite;
import org.fao.fi.fishstat.gui.dataset.aggregation.DimensionAggregationComposite;
import org.fao.fi.fishstat.gui.preferences.IGuiPreferencesConstants;

public class AggregationDialog
extends TitleAreaDialog
implements IFSActions,
IGuiPreferencesConstants {
    private AggregationWrapper timeSeriesAggregationWrapper = null;
    private DimensionAggregationComposite[] panels;
    private List<Dimension> dimensions;

    public AggregationDialog(Shell parentShell, AggregationWrapper request) {
        super(parentShell);
        this.timeSeriesAggregationWrapper = request;
        this.dimensions = this.timeSeriesAggregationWrapper.getSession().getDataset().getDimensions();
    }

    protected Control createDialogArea(Composite parent) {
        parent.setBackgroundMode(2);
        parent.setBackground(SWTResourceManager.getColor(255, 255, 255));
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.marginLeft = 10;
        container.setLayout((Layout)gridLayout);
        if (Beans.isDesignTime()) {
            AggregationComposite aggregationComposite = new AggregationComposite(container, 0);
            aggregationComposite.setBackground(SWTResourceManager.getColor(255, 255, 255));
            aggregationComposite.setLayoutData(new GridData(4, 4, true, true));
        } else {
            this.panels = new DimensionAggregationComposite[this.dimensions.size()];
            int i = 0;
            while (i < this.dimensions.size()) {
                DimensionAggregation da = this.timeSeriesAggregationWrapper.getDimensionAggregation(i);
                if (!da.getDimension().isObservedMeasure()) {
                    this.panels[i] = new DimensionAggregationComposite(container, da);
                }
                ++i;
            }
            this.setTitle(Activator.getLocalString("timeseries.aggregation.dialog.title"));
            this.setMessage(Activator.getLocalString("timeseries.aggregation.dialog.subtitle"));
        }
        return area;
    }

    protected boolean isResizable() {
        return true;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        parent.setBackground(SWTResourceManager.getColor(255, 255, 255));
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.getButton(1).setFocus();
    }

    protected Point getInitialSize() {
        if (this.dimensions == null) {
            return new Point(500, 150);
        }
        int numDimensions = 0;
        int i = 0;
        while (i < this.panels.length) {
            if (this.panels[i] != null) {
                ++numDimensions;
            }
            ++i;
        }
        return new Point(500, numDimensions * 94 + 160);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setImage(Activator.getImage("icons/actions/aggregate.png"));
        newShell.setText(Activator.getLocalString("timeseries.aggregation.dialog.bartitle"));
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.okAction();
        }
        super.buttonPressed(buttonId);
    }

    private void okAction() {
        this.getShell().setVisible(false);
        AggregationDialog.modifyAggregation(this.timeSeriesAggregationWrapper);
        this.close();
    }

    public static void modifyAggregation(final AggregationWrapper aw) {
        final boolean relatives = Activator.getDefault().getPreferenceStore().getBoolean("core.join.related.series");
        final CoreRegistry registry = GuiCoreActivator.getDefault().getRegistry();
        try {
            if (aw.isDisaggregated()) {
                PlatformUI.getWorkbench().getProgressService().run(true, false, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        registry.removeActionRequest(3, relatives, monitor);
                    }
                });
            } else {
                PlatformUI.getWorkbench().getProgressService().run(true, false, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        registry.processActionRequest((IActionRequestWrapper)aw, relatives, monitor);
                    }
                });
            }
        }
        catch (Exception e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, AggregationDialog.class.getName(), "aggregation dialog failed", (Throwable)e));
        }
    }
}

