/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.dataset.display;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.fao.fi.fishstat.data.timeseries.api.Measure;
import org.fao.fi.fishstat.gui.Activator;
import org.fao.fi.fishstat.gui.ApplicationPreferences;
import org.fao.fi.fishstat.gui.components.ComponentsCommons;
import org.fao.fi.fishstat.gui.preferences.IGuiPreferencesConstants;

public class MeasureDisplayer
implements IGuiPreferencesConstants,
IPropertyChangeListener {
    private IPreferenceStore ps = Activator.getDefault().getPreferenceStore();
    private Font fontbold;
    private DecimalFormat decimalFormatObs;
    private DecimalFormat decimalFormatClc;
    private boolean space;

    public MeasureDisplayer() {
        this.ps.addPropertyChangeListener((IPropertyChangeListener)this);
        this.fontbold = ComponentsCommons.getFont((String)"", (int)8, (int)1);
        this.decimalFormatObs = this.calculateDecimalFormatStt();
        this.decimalFormatClc = this.calculateDecimalFormatClc();
        this.space = this.ps.getInt("display.hilite.estimate") == 3 || this.ps.getInt("display.hilite.repetition") == 4 || this.ps.getInt("display.hilite.repetition") == 6;
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().contains("display.numbers")) {
            this.decimalFormatObs = this.calculateDecimalFormatStt();
            this.decimalFormatClc = this.calculateDecimalFormatClc();
        }
        this.space = this.ps.getInt("display.hilite.estimate") == 3 || this.ps.getInt("display.hilite.repetition") == 4 || this.ps.getInt("display.hilite.repetition") == 6;
    }

    public Color getForeground(Measure m) {
        if (m != null && m.getStatus() != null) {
            if (m.getStatus().toString().equals("F") && ApplicationPreferences.dataDisplayHilited[3]) {
                return ApplicationPreferences.dataDisplayColors[3];
            }
            if (m.getStatus().toString().equals("0") && ApplicationPreferences.dataDisplayHilited[2]) {
                return ApplicationPreferences.dataDisplayColors[2];
            }
            if (m.getStatus().toString().equals(".") && ApplicationPreferences.dataDisplayHilited[0]) {
                return ApplicationPreferences.dataDisplayColors[0];
            }
            if (m.getStatus().toString().equals("-") && ApplicationPreferences.dataDisplayHilited[1]) {
                return ApplicationPreferences.dataDisplayColors[1];
            }
        }
        return null;
    }

    private DecimalFormat calculateDecimalFormatStt() {
        StringBuffer pattern = new StringBuffer(20);
        int i = 0;
        while (i < this.ps.getInt("display.numbers.before.decimals.obsrv.measures")) {
            pattern.append('0');
            ++i;
        }
        pattern.append('.');
        char patchar = this.ps.getInt("display.numbers.modes.after.decimals.obsrv.measures") == 0 ? (char)'#' : '0';
        int i2 = 0;
        while (i2 < this.ps.getInt("display.numbers.after.decimals.obsrv.measures")) {
            pattern.append(patchar);
            ++i2;
        }
        if (this.ps.getBoolean("display.numbers.modes.expo")) {
            pattern.append("E00");
        }
        DecimalFormatSymbols symbols = new DecimalFormatSymbols();
        symbols.setDecimalSeparator(this.ps.getBoolean("display.numbers.modes.comma") ? (char)',' : '.');
        return new DecimalFormat(pattern.toString(), symbols);
    }

    private DecimalFormat calculateDecimalFormatClc() {
        StringBuffer pattern = new StringBuffer(20);
        int i = 0;
        while (i < this.ps.getInt("display.numbers.before.decimals.calc.measures")) {
            pattern.append('0');
            ++i;
        }
        pattern.append('.');
        char patchar = this.ps.getInt("display.numbers.modes.after.decimals.calc.measures") == 0 ? (char)'#' : '0';
        int i2 = 0;
        while (i2 < this.ps.getInt("display.numbers.after.decimals.calc.measures")) {
            pattern.append(patchar);
            ++i2;
        }
        if (this.ps.getBoolean("display.numbers.modes.expo")) {
            pattern.append("E00");
        }
        DecimalFormatSymbols symbols = new DecimalFormatSymbols();
        symbols.setDecimalSeparator(this.ps.getBoolean("display.numbers.modes.comma") ? (char)',' : '.');
        return new DecimalFormat(pattern.toString(), symbols);
    }

    public Font getFont(Measure m) {
        if (m != null && m.getStatus() != null && m.getStatus().toString().equals("F") && ApplicationPreferences.dataDisplayHilited[3]) {
            return this.fontbold;
        }
        return null;
    }

    public Font getFontbold() {
        return this.fontbold;
    }

    public String getMeasureLabel(Measure m, boolean observed) {
        if (m != null) {
            String s;
            DecimalFormat decimalFormat = observed ? this.decimalFormatObs : this.decimalFormatClc;
            String textualValue = decimalFormat.format(m.getValue());
            if (textualValue.endsWith(".")) {
                textualValue = textualValue.substring(0, textualValue.length() - 1);
            }
            if ((s = m.getStatus().toString()) != null) {
                int value;
                if (s.equals(".")) {
                    String value2 = UNAVAILABLE_LABELS[this.getIntPerference("display.hilite.unavailable", UNAVAILABLE_LABELS.length)];
                    if (value2.equals("[blank]")) {
                        return "";
                    }
                    return this.space ? String.valueOf(value2) + "   " : value2;
                }
                if (s.equals("-")) {
                    String value3 = ZEROES_LABELS[this.getIntPerference("display.hilite.zeroes", ZEROES_LABELS.length)];
                    if (value3.equals("[blank]")) {
                        return "";
                    }
                    return this.space ? String.valueOf(value3) + "   " : value3;
                }
                if (s.equals("0")) {
                    String value4 = NEGLIGIBLE_LABELS[this.getIntPerference("display.hilite.negligible", NEGLIGIBLE_LABELS.length)];
                    if (value4.equals("[blank]")) {
                        return "";
                    }
                    if (value4.equals("0")) {
                        return this.space ? String.valueOf(textualValue) + "   " : textualValue;
                    }
                    return this.space ? String.valueOf(value4) + "   " : value4;
                }
                if (s.equals("F")) {
                    value = this.getIntPerference("display.hilite.estimate", 3);
                    if (value == 0) {
                        return this.space ? String.valueOf(textualValue) + "   " : textualValue;
                    }
                    if (value == 1) {
                        return "~ " + (this.space ? String.valueOf(textualValue) + " " : textualValue);
                    }
                    if (value == 2) {
                        return "F " + (this.space ? String.valueOf(textualValue) + " " : textualValue);
                    }
                    if (value == 3) {
                        return String.valueOf(textualValue) + " F";
                    }
                }
                if (s.equals("#")) {
                    return String.valueOf(textualValue) + " #";
                }
                if (s.equals("R")) {
                    value = this.getIntPerference("display.hilite.repetition", 6);
                    if (value == 0) {
                        return this.space ? String.valueOf(textualValue) + "   " : textualValue;
                    }
                    if (value == 1) {
                        return "~ " + (this.space ? String.valueOf(textualValue) + " " : textualValue);
                    }
                    if (value == 2) {
                        return "F " + (this.space ? String.valueOf(textualValue) + " " : textualValue);
                    }
                    if (value == 4) {
                        return String.valueOf(textualValue) + "  F";
                    }
                    if (value == 5) {
                        return "R" + textualValue;
                    }
                    if (value == 6) {
                        return String.valueOf(textualValue) + "  R";
                    }
                }
            }
            return this.space ? String.valueOf(textualValue) + "   " : textualValue;
        }
        return "error: null value";
    }

    private int getIntPerference(String preferenceName, int maxValue) {
        int value = this.ps.getInt(preferenceName);
        if (value < 0 || value > maxValue) {
            return this.ps.getDefaultInt(preferenceName);
        }
        return value;
    }

    public String getOnlyValue(Measure m, boolean observed) {
        if (m != null) {
            DecimalFormat decimalFormat = observed ? this.decimalFormatObs : this.decimalFormatClc;
            String textValue = decimalFormat.format(m.getValue());
            if (textValue.endsWith(".")) {
                textValue = textValue.substring(0, textValue.length() - 1);
            }
            return textValue;
        }
        return "error: null value";
    }
}

