/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.dataset.export;

import com.csvreader.CsvWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.fao.fi.fishstat.core.CoreCommons;
import org.fao.fi.fishstat.core.model.aggregation.AggregationWrapper;
import org.fao.fi.fishstat.core.model.aggregation.DimensionAggregation;
import org.fao.fi.fishstat.core.model.concept.selection.ConceptSelection;
import org.fao.fi.fishstat.core.model.concept.selection.FilterWrapper;
import org.fao.fi.fishstat.data.common.api.MultilingualString;
import org.fao.fi.fishstat.data.reference.api.Concept;
import org.fao.fi.fishstat.data.reference.api.ReferenceObject;
import org.fao.fi.fishstat.data.reference.api.ReferenceServiceFactory;
import org.fao.fi.fishstat.data.timeseries.api.Dimension;
import org.fao.fi.fishstat.data.timeseries.api.Measure;
import org.fao.fi.fishstat.data.timeseries.api.ObservationSeries;
import org.fao.fi.fishstat.gui.Activator;
import org.fao.fi.fishstat.gui.core.properties.DatasetProperties;
import org.fao.fi.fishstat.gui.core.properties.DimensionProperties;
import org.fao.fi.fishstat.gui.core.properties.TimeSeriesProperties;
import org.fao.fi.fishstat.gui.core.session.GuiSession;
import org.fao.fi.fishstat.gui.dataset.display.MeasureDisplayer;
import org.fao.fi.fishstat.gui.dataset.export.ExportSettings;
import org.fao.fi.fishstat.gui.views.multitable.MultiTableView;

@Deprecated
public class CsvViewExporter
implements IRunnableWithProgress {
    private GuiSession session;
    private ExportSettings exportSettings;
    private Writer writer;
    private MultiTableView view;
    private Character separator;
    private Character textQualifier;
    private IProgressMonitor progressMonitor = null;
    private Table dimTable;
    private Table obsTable;
    private Table clcTable;
    private int exportSize;
    private String measureUnit = null;

    public CsvViewExporter(MultiTableView view, ExportSettings exportSettings) {
        this.view = view;
        this.exportSettings = exportSettings;
        this.session = view.getSession();
        this.dimTable = this.view.getKeyTableViewer().getTable();
        this.obsTable = this.view.getObsTableViewer().getTable();
        this.clcTable = this.view.getClcTableViewer().getTable();
        if (this.session.getDataset().getObservedMeasureDimension() == null) {
            boolean foundAmeasure = false;
            for (Dimension dimension : this.session.getDataset().getDimensions()) {
                if (!dimension.isObservedMeasure()) continue;
                foundAmeasure = true;
            }
            if (!foundAmeasure) {
                this.setupMeasure();
            }
        }
    }

    private void setupMeasure() {
        if (this.session.getUnitValue() != null && this.session.getUnitValue().length == 2 && this.session.getUnitValue()[0] != null) {
            this.measureUnit = this.session.getUnitValue()[1] != null && !this.session.getUnitValue()[1].equals("0") ? (this.session.getUnitValue()[1].equals("3") ? String.valueOf(this.session.getUnitValue()[0]) + " 1000" : String.valueOf(this.session.getUnitValue()[0]) + " " + this.session.getUnitValue()[1]) : (this.session.getUnitValue()[0].equals("t") ? this.getMeasureDisplay("Q_t_1") : (this.session.getUnitValue()[0].equals("tlw") ? this.getMeasureDisplay("Q_tlw") : (this.session.getUnitValue()[0].equals("tpw") ? this.getMeasureDisplay("Q_tpw") : this.session.getUnitValue()[0])));
        }
    }

    private String getMeasureDisplay(String measureCode) {
        Concept concept = ReferenceServiceFactory.getService().getConcept("MEASURE");
        ReferenceObject refObject = concept.getObject(concept.getAttribute("CODE"), (Object)measureCode);
        Object nameAtt = refObject.getAttribute("NAME");
        return ((MultilingualString)nameAtt).getValue(CoreCommons.LOCALE2);
    }

    public int getExportSize() {
        return this.exportSize;
    }

    public boolean hasEmptySelection() {
        return this.obsTable.getSelectionIndices().length == 0;
    }

    public Character getTextQualifier() {
        return this.textQualifier;
    }

    public void setTextQualifier(Character textQualifier) {
        this.textQualifier = textQualifier;
    }

    public void setWriter(Writer writer) {
        this.writer = writer;
    }

    public Writer getWriter() {
        return this.writer;
    }

    public MultiTableView getView() {
        return this.view;
    }

    public Character getSeparator() {
        return this.separator;
    }

    public void setSeparator(Character separator) {
        this.separator = separator;
    }

    private void produceHeaders(CsvWriter csw, int exportType) throws IOException {
        int i = 1;
        while (i < this.dimTable.getColumnCount()) {
            csw.write(this.dimTable.getColumn(i).getText());
            ++i;
        }
        if (this.measureUnit != null) {
            csw.write("Unit");
        }
        if (exportType == 2) {
            this.produceHeaderDenormalized(csw);
        } else if (exportType == 1) {
            this.produceHeaderNormalized(csw);
        }
        csw.endRecord();
    }

    private void produceHeaderDenormalized(CsvWriter csw) throws IOException {
        int i = 1;
        while (i < this.obsTable.getColumnCount()) {
            csw.write(this.obsTable.getColumn(i).getText());
            if (this.exportSettings.splitSymbols) {
                csw.write(this.exportSettings.symbolHeader);
            }
            ++i;
        }
        i = 1;
        while (i < this.clcTable.getColumnCount()) {
            csw.write(this.clcTable.getColumn(i).getText());
            if (this.exportSettings.splitSymbols) {
                csw.write(this.exportSettings.symbolHeader);
            }
            ++i;
        }
    }

    private void produceHeaderNormalized(CsvWriter csw) throws IOException {
        csw.write("YEAR");
        csw.write("QUANTITY");
        if (this.exportSettings.splitSymbols) {
            csw.write(this.exportSettings.symbolHeader);
        }
    }

    private void exportSelectedNormalized(CsvWriter csw) throws IOException {
        TimeSeriesProperties tsp = this.session.getTimeseriesProperties();
        MeasureDisplayer displayer = new MeasureDisplayer();
        int[] selItems = this.dimTable.getSelectionIndices();
        if (selItems.length == 0) {
            selItems = new int[this.dimTable.getItemCount()];
            int i = 0;
            while (i < this.dimTable.getItemCount()) {
                selItems[i] = i;
                ++i;
            }
        }
        this.exportSettings.exportTotals = this.exportSettings.exportTotals && (selItems.length == this.dimTable.getItemCount() || selItems.length == 0);
        this.exportSize = selItems.length;
        if (this.progressMonitor != null) {
            this.progressMonitor.beginTask("Exporting normalized records", selItems.length);
        }
        int r = 0;
        while (r < selItems.length) {
            int row = selItems[r];
            ObservationSeries s = (ObservationSeries)this.view.getObsTableViewer().getElementAt(row);
            int p = 0;
            while (p < tsp.getPeriodsSize()) {
                Measure obs = s.getMeasure(tsp.getPeriod(p));
                if (obs == null || !obs.getStatus().toString().equals(".")) {
                    int d = 1;
                    while (d < this.dimTable.getColumnCount()) {
                        csw.write(this.dimTable.getItem(row).getText(d));
                        ++d;
                    }
                    csw.write(tsp.getPeriod(p).getYear());
                    this.writeObservationMeasure(csw, displayer, obs, true);
                    csw.endRecord();
                }
                ++p;
            }
            if (this.progressMonitor != null) {
                this.progressMonitor.worked(1);
            }
            ++r;
        }
    }

    private void exportSelectedDenormalized(CsvWriter csw) throws IOException {
        TimeSeriesProperties tsp = this.session.getTimeseriesProperties();
        MeasureDisplayer displayer = new MeasureDisplayer();
        int[] selItems = this.dimTable.getSelectionIndices();
        if (selItems.length == 0) {
            selItems = new int[this.dimTable.getItemCount()];
            int i = 0;
            while (i < this.dimTable.getItemCount()) {
                selItems[i] = i;
                ++i;
            }
        }
        this.exportSettings.exportTotals = this.exportSettings.exportTotals && (selItems.length == this.dimTable.getItemCount() || selItems.length == 0);
        this.exportSize = selItems.length;
        if (this.progressMonitor != null) {
            this.progressMonitor.beginTask("Exporting records", selItems.length);
        }
        int r = 0;
        while (r < selItems.length) {
            ObservationSeries s;
            int row = selItems[r];
            int i = 1;
            while (i < this.dimTable.getColumnCount()) {
                csw.write(this.dimTable.getItem(row).getText(i));
                ++i;
            }
            if (this.measureUnit != null) {
                csw.write(this.measureUnit);
            }
            if ((s = (ObservationSeries)this.view.getObsTableViewer().getElementAt(row)) == null) {
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Copy/paste data error", (String)"Please use the function File->Export Selection (CSV file) instead");
                System.exit(1);
            }
            int p = 0;
            while (p < tsp.getPeriodsSize()) {
                this.writeObservationMeasure(csw, displayer, s.getMeasure(tsp.getPeriod(p)), true);
                ++p;
            }
            int i2 = 1;
            while (i2 < this.clcTable.getColumnCount()) {
                this.writeObservationMeasure(csw, displayer, s.getCalculatedMeasure(i2 - 1), false);
                ++i2;
            }
            csw.endRecord();
            if (this.progressMonitor != null) {
                this.progressMonitor.worked(1);
            }
            ++r;
        }
    }

    private void writeObservationMeasure(CsvWriter csw, MeasureDisplayer displayer, Measure cms, boolean valueObserved) throws IOException {
        if (this.exportSettings.splitSymbols) {
            if (cms == null) {
                csw.write("");
                csw.write("");
            } else {
                csw.write(displayer.getOnlyValue(cms, valueObserved));
                csw.write(cms.getStatus().toString());
            }
        } else if (cms == null) {
            csw.write("");
        } else {
            csw.write(this.exportSettings.isNoSymbols() ? displayer.getOnlyValue(cms, true) : displayer.getMeasureLabel(cms, true));
        }
    }

    private void exportTotals(CsvWriter csw) throws IOException {
        List usedMeasures = this.session.getTimeseries().getObsMeasures();
        TimeSeriesProperties tsp = this.session.getTimeseriesProperties();
        MeasureDisplayer displayer = new MeasureDisplayer();
        int[] selItems = this.dimTable.getSelectionIndices();
        this.exportSize = selItems.length;
        if (this.exportSize == 0) {
            this.exportSize = this.dimTable.getItemCount();
        }
        if (this.progressMonitor != null) {
            this.progressMonitor.beginTask("Exporting totals", selItems.length);
        }
        int m = 0;
        while (m < (!usedMeasures.isEmpty() ? usedMeasures.size() : 1)) {
            ReferenceObject measure = !usedMeasures.isEmpty() ? (ReferenceObject)usedMeasures.get(m) : null;
            ObservationSeries totals = this.session.getLastResult().getTotals(measure);
            String nameAtt = "";
            if (measure != null) {
                Object attVal = measure.getAttribute(measure.getConcept().getNameAttribute());
                nameAtt = attVal instanceof MultilingualString ? "- " + ((MultilingualString)attVal).getValue(Activator.getLanguage()) : "- " + attVal.toString();
            }
            int i = 1;
            while (i < this.dimTable.getColumnCount()) {
                csw.write(i == 1 ? "Totals " + nameAtt : "");
                ++i;
            }
            if (this.measureUnit != null) {
                csw.write("");
            }
            i = 0;
            while (i < tsp.getPeriodsSize()) {
                this.writeObservationMeasure(csw, displayer, totals.getMeasure(tsp.getPeriod(i)), true);
                ++i;
            }
            i = 1;
            while (i < this.clcTable.getColumnCount()) {
                this.writeObservationMeasure(csw, displayer, totals.getCalculatedMeasure(i - 1), false);
                ++i;
            }
            csw.endRecord();
            if (this.progressMonitor != null) {
                this.progressMonitor.worked(1);
            }
            ++m;
        }
    }

    private void exportSelectionAggregation(CsvWriter csw) throws IOException {
        AggregationWrapper aggreg = this.session.getAggregationRequest();
        if (aggreg != null) {
            DatasetProperties dsProps = this.session.getDatasetProperties();
            for (DimensionProperties dimProps : dsProps.getDimensionsProperties()) {
                StringBuilder write = new StringBuilder();
                Dimension dimension = dimProps.getDimension();
                write.append("Agregation ");
                write.append(dimension.getConcept().getAcronym());
                DimensionAggregation dimAggRequest = aggreg.getDimensionAggregation(dimProps.getDimensionIdx());
                switch (dimAggRequest.getType()) {
                    case 0: {
                        write.append(": all details (no aggregation defined)");
                        break;
                    }
                    case 1: {
                        Concept aggregator = dimAggRequest.getBasicAggregator();
                        write.append(": aggregated by group [");
                        write.append(aggregator.getName().getValue(CoreCommons.LOCALE2));
                        write.append("]");
                        break;
                    }
                    case 2: {
                        write.append(" handpicked group [");
                        boolean firstElement = true;
                        for (Concept item : Collections.list(dimAggRequest.getIncludeParents())) {
                            if (!firstElement) {
                                write.append(",");
                            }
                            write.append(item.getName().getValue(CoreCommons.LOCALE2));
                            firstElement = false;
                        }
                        write.append("]");
                        break;
                    }
                    case 3: {
                        Concept aggregator2 = dimAggRequest.getDimension().getConcept();
                        write.append(": entirely aggregated by [");
                        write.append(aggregator2.getName().getValue(CoreCommons.LOCALE2));
                        write.append("]");
                        break;
                    }
                    default: {
                        write.append(" type=" + dimAggRequest.getType());
                    }
                }
                csw.writeComment(write.toString());
            }
        } else {
            csw.writeComment("Aggregation: no aggregation defined");
        }
    }

    private void exportSelectionFilter(CsvWriter csw) throws IOException {
        FilterWrapper filter = this.session.getFilterRequest();
        if (filter.hasFilterSet()) {
            int i = 0;
            while (i < filter.getDimensionsSize()) {
                StringBuilder write = new StringBuilder();
                write.append("Filter ");
                write.append(filter.getDimension(i).getConcept().getAcronym());
                write.append(": ");
                ConceptSelection aSelection = filter.getConceptSelection(i);
                if (!aSelection.getExcludesList().isEmpty() && !aSelection.getIncludes().isEmpty()) {
                    Set includes = aSelection.getIncludes();
                    write.append(" include only [");
                    boolean firstElement = true;
                    for (ReferenceObject item : includes) {
                        if (!firstElement) {
                            write.append(",");
                        }
                        write.append(((MultilingualString)item.getAttribute("NAME")).getValue(CoreCommons.LOCALE2));
                        firstElement = false;
                    }
                    write.append("]");
                } else {
                    write.append(" all details (no filter defined)");
                }
                csw.writeComment(write.toString());
                ++i;
            }
        } else {
            csw.writeComment("Filter: no filter defined");
        }
    }

    private void exportCitation(CsvWriter csw) throws IOException {
        if (this.exportSettings.exportCitation && this.session.getDataset().getCitation() != null) {
            csw.write(this.session.getDataset().getCitation());
        }
        csw.endRecord();
    }

    public void close() {
        if (this.writer instanceof StringWriter) {
            try {
                this.writer.close();
            }
            catch (IOException e) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, this.getClass().getName(), "writing CSV data failed", (Throwable)e));
            }
        } else if (this.writer instanceof FileWriter) {
            try {
                ((FileWriter)this.writer).flush();
                ((FileWriter)this.writer).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.progressMonitor != null) {
            this.progressMonitor.done();
        }
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        this.progressMonitor = monitor;
        try {
            this.export();
        }
        catch (IOException e) {
            if (this.progressMonitor != null) {
                this.progressMonitor.done();
            }
            Activator.getDefault().getLog().log((IStatus)new Status(4, this.getClass().getName(), "writing CSV data failed", (Throwable)e));
        }
    }

    private void export() throws IOException {
        CsvWriter csw = new CsvWriter(this.writer, this.separator.charValue());
        if (this.textQualifier != null) {
            csw.setTextQualifier(this.textQualifier.charValue());
        }
        if (this.exportSettings.exportHeaders) {
            this.produceHeaders(csw, this.exportSettings.getExportMode());
        }
        if (this.exportSettings.getExportMode() == 2) {
            this.exportSelectedDenormalized(csw);
        } else if (this.exportSettings.getExportMode() == 1) {
            this.exportSelectedNormalized(csw);
        }
        if (this.exportSettings.exportTotals && this.exportSettings.getExportMode() == 2) {
            this.exportTotals(csw);
        }
        if (this.exportSettings.isShowSelection()) {
            this.exportSelectionFilter(csw);
            this.exportSelectionAggregation(csw);
        }
        if (this.exportSettings.exportCitation) {
            this.exportCitation(csw);
        }
    }
}

