/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.dataset.management;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wb.swt.ResourceManager;
import org.eclipse.wb.swt.SWTResourceManager;
import org.fao.fi.fishstat.core.CoreUtils;
import org.fao.fi.fishstat.data.common.api.MultilingualString;
import org.fao.fi.fishstat.data.timeseries.api.Timeseries;
import org.fao.fi.fishstat.gui.Activator;
import org.fao.fi.fishstat.gui.dataset.export.ExportSettings;
import org.fao.fi.fishstat.gui.dataset.management.DatasetManagementRigthComposite;
import org.fao.fi.fishstat.gui.handler.edit.DimensionCopyHandler;

public class DatasetMetadataDialog
extends TitleAreaDialog {
    private Timeseries timeseries = null;
    private Button exportButton;
    private DatasetManagementRigthComposite datasetComposite;

    public DatasetMetadataDialog(Shell parentShell, Timeseries timeseries) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.timeseries = timeseries;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitleImage(ResourceManager.getPluginImage("org.fao.fi.fishstat.gui", "icons/actions/sugar-cubes-icon.png"));
        this.setMessage(String.valueOf(CoreUtils.getCurrentLang((MultilingualString)this.timeseries.getDataset().getName(), (String)Activator.getLanguage())) + " - " + CoreUtils.getCurrentLang((MultilingualString)this.timeseries.getName(), (String)Activator.getLanguage()));
        this.setTitle(Activator.getLocalString("label.metadata.first.upper"));
        Composite area = (Composite)super.createDialogArea(parent);
        this.datasetComposite = new DatasetManagementRigthComposite(area, this);
        this.datasetComposite.getDatasetMetadataComposite().renderDataset(this.timeseries.getDataset());
        this.datasetComposite.getDimensionsTabbedDisplayer().renderDataset(this.timeseries.getDataset());
        this.datasetComposite.getDimensionsTabbedDisplayer().setFocus();
        this.datasetComposite.getDatasetAttachmentsComposite().setInput(this.timeseries.getDataset());
        this.datasetComposite.getTimeseriesMetadataComposite().renderTimeseries(this.timeseries);
        this.datasetComposite.setLayoutData(new GridData(1808));
        this.datasetComposite.setLayout((Layout)new GridLayout(1, false));
        return area;
    }

    protected void configureShell(Shell newShell) {
        newShell.setBackgroundMode(2);
        newShell.setBackground(SWTResourceManager.getColor(1));
        super.configureShell(newShell);
        newShell.setImage(Activator.getImage("icons/actions/sugar-cubes-24.png"));
        newShell.setText(Activator.getLocalString("label.metadata.first.upper"));
    }

    protected void createButtonsForButtonBar(Composite parent) {
        parent.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.exportButton = this.createButton(parent, 3, Activator.getLocalString("preferences.metadata.copytoclipboard"), true);
        this.exportButton.setEnabled(false);
        this.exportButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                IPreferenceStore ps = Activator.getDefault().getPreferenceStore();
                ExportSettings exportSettings = new ExportSettings(ps);
                new DimensionCopyHandler(DatasetMetadataDialog.this.datasetComposite.getDimensionsTabbedDisplayer(), exportSettings);
            }
        });
        Label spacer = new Label(parent, 0);
        spacer.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        GridLayout layout = (GridLayout)parent.getLayout();
        ++layout.numColumns;
        layout.makeColumnsEqualWidth = false;
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    public void setDimensionExportEnabled(boolean isEnabled) {
        this.exportButton.setEnabled(isEnabled);
    }

    protected Point getInitialSize() {
        Shell shell = PlatformUI.getWorkbench().getDisplay().getActiveShell();
        if (shell == null) {
            return new Point(745, 750);
        }
        Rectangle clientArea = shell.getClientArea();
        return new Point(745 < clientArea.width ? 745 : clientArea.width, 750 < clientArea.height ? 750 : clientArea.height);
    }
}

