/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.dataset.management;

import java.io.File;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.wb.swt.ResourceManager;
import org.eclipse.wb.swt.SWTResourceManager;
import org.fao.fi.fishstat.core.CoreCommons;
import org.fao.fi.fishstat.data.timeseries.api.Attachment;
import org.fao.fi.fishstat.data.timeseries.api.AttachmentType;
import org.fao.fi.fishstat.gui.Activator;
import org.fao.fi.fishstat.gui.views.PDFviewerComposite;

public class SingleAttachmentDialog
extends TitleAreaDialog {
    private Attachment attachment;

    public SingleAttachmentDialog(Shell parentShell, Attachment attachment) {
        super(parentShell);
        this.attachment = attachment;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitleImage(ResourceManager.getPluginImage("org.fao.fi.fishstat.gui", "icons/actions/map.png"));
        this.setTitle(this.attachment.getName().getValue(Activator.getLanguage()));
        this.setMessage(this.attachment.getDescription().getValue(Activator.getLanguage()));
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayout((Layout)new FillLayout(256));
        container.setLayoutData((Object)new GridData(1808));
        this.initComponents(container);
        AttachmentType att_type = this.attachment.getType();
        if (att_type.equals((Object)AttachmentType.BITMAP) || att_type.equals((Object)AttachmentType.JPG)) {
            this.setTitleImage(ResourceManager.getPluginImage("org.fao.fi.fishstat.gui", "icons/actions/mapBig.png"));
        } else if (att_type.equals((Object)AttachmentType.HTML) || att_type.equals((Object)AttachmentType.TEXT)) {
            this.setTitleImage(ResourceManager.getPluginImage("org.fao.fi.fishstat.gui", "icons/actions/notesBig.png"));
        } else {
            this.setTitleImage(ResourceManager.getPluginImage("org.fao.fi.fishstat.gui", "icons/actions/clipBig.png"));
        }
        return area;
    }

    private void initComponents(Composite container) {
        String url = String.valueOf(CoreCommons.getWorkspacesManager().getCurrentWorkspace().getLocationDir().getAbsolutePath()) + File.separator + "att" + File.separator + this.attachment.getFileName().getValue(Activator.getLanguage());
        container.setBackground(SWTResourceManager.getColor(19));
        container.setLayout((Layout)new FillLayout(256));
        FormToolkit toolkit = new FormToolkit(Display.getCurrent());
        if (url.toLowerCase().endsWith(".pdf")) {
            PDFviewerComposite pdfComposite = new PDFviewerComposite(container, 0);
            toolkit.adapt((Composite)pdfComposite);
            toolkit.paintBordersFor((Composite)pdfComposite);
            pdfComposite.openPDFdocument(url);
        } else {
            Browser browser = new Browser(container, 0);
            browser.setJavascriptEnabled(false);
            toolkit.adapt((Composite)browser);
            toolkit.paintBordersFor((Composite)browser);
            browser.setUrl(url);
        }
        container.layout(true);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    protected Point getInitialSize() {
        return new Point(870, 680);
    }
}

