/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.handler.dynamics;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.fao.fi.fishstat.gui.Activator;
import org.fao.fi.fishstat.gui.ApplicationAdvisor;
import org.fao.fi.fishstat.gui.core.GuiCoreActivator;
import org.fao.fi.fishstat.gui.dataset.aggregation.AggregationDialog;
import org.fao.fi.fishstat.gui.preferences.IGuiPreferencesConstants;

public class SwitchWorkspaceHandler
extends AbstractHandler
implements IHandler,
IGuiPreferencesConstants {
    public static final String ID = "org.fao.fi.fishstat.gui.dynamic.switch.workspace";
    public static final String WKS_PARAMTER = "org.fao.fi.fishstat.gui.dataset.switch.workspace.parameter.id";
    private String wsPath;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.setWorkspacePath(event.getParameter(WKS_PARAMTER));
        BusyIndicator.showWhile((Display)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getDisplay(), () -> ApplicationAdvisor.workspaceOpen(this.getWorkspacePath()));
        try {
            ICommandService commandService;
            Command command;
            if (Activator.getDefault().getPreferenceStore().getBoolean("core.open.workspace.browser") && GuiCoreActivator.getDefault().getRegistry().getOpenSessionsSize() == 0 && (command = (commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class)).getCommand("org.fao.fi.fishstat.gui.command.dataset.open")).isEnabled()) {
                commandService.getCommand("org.fao.fi.fishstat.gui.command.dataset.open").executeWithChecks(new ExecutionEvent());
            }
        }
        catch (Exception e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, AggregationDialog.class.getName(), "open workspace failed", (Throwable)e));
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error opening workspace", (String)"Is the workspace already open in another instance of FishStatJ?");
            System.exit(1);
        }
        return null;
    }

    public String getWorkspacePath() {
        return this.wsPath;
    }

    public void setWorkspacePath(String wsPath) {
        this.wsPath = wsPath;
    }
}

