/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.handler.edit;

import java.text.MessageFormat;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.fao.fi.fishstat.core.workspaces.WorkspacesManager;
import org.fao.fi.fishstat.gui.Activator;
import org.fao.fi.fishstat.gui.ApplicationWorkbenchAdvisor;
import org.fao.fi.fishstat.gui.core.GuiCoreActivator;
import org.fao.fi.fishstat.gui.core.session.GuiSession;
import org.fao.fi.fishstat.gui.dataset.export.CsvExporterNew;
import org.fao.fi.fishstat.gui.dataset.export.ExportSettings;
import org.fao.fi.fishstat.gui.dataset.export.ExportSettingsDialog;
import org.fao.fi.fishstat.gui.handler.base.AbstractHandlerWorkspaces;
import org.fao.fi.fishstat.gui.views.multitable.MultiTableView;

public class SaveCsvHandler
extends AbstractHandlerWorkspaces {
    public static final String ID = "org.fao.fi.fishstat.gui.command.edit.csv.save.details";
    private IPreferenceStore ps = Activator.getDefault().getPreferenceStore();

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ExportSettingsDialog dialog;
        int result;
        MultiTableView currentView = (MultiTableView)ApplicationWorkbenchAdvisor.getApplicationAdvisor().getLastActiveDoubleTableView();
        if (currentView == null) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, this.getClass().getName(), "currentView is null"));
            return null;
        }
        if (currentView.getSession() == null) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, this.getClass().getName(), "currentView has no session"));
            return null;
        }
        ExportSettings exportSettings = new ExportSettings(this.ps);
        if (this.ps.getBoolean("export.csv.askconfirm") && (result = (dialog = new ExportSettingsDialog(Activator.getDefault().getWorkbench().getDisplay().getActiveShell(), exportSettings)).open()) == 1) {
            return null;
        }
        this.saveCsv(exportSettings, currentView.getSession(), this.getSelectedRows(currentView), this.hasAllRowsSelected(currentView));
        return null;
    }

    private void saveCsv(ExportSettings exportSettings, GuiSession guiSession, int[] selection, boolean hasAllRowsSelected) {
        CsvExporterNew csvExport = new CsvExporterNew(exportSettings, guiSession, selection, hasAllRowsSelected);
        if (!csvExport.selectFile()) {
            return;
        }
        try {
            PlatformUI.getWorkbench().getProgressService().run(true, true, (IRunnableWithProgress)csvExport);
            MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Activator.getLocalString("label.export.save.done.title"), (String)MessageFormat.format(Activator.getLocalString("label.export.save.done.message"), csvExport.getExportedRows()));
        }
        catch (Exception e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, this.getClass().getName(), "error writing CSV file", (Throwable)e));
            MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Activator.getLocalString("label.export.save.done.title"), (String)Activator.getLocalString("label.export.save.error"));
            System.exit(1);
        }
    }

    private int[] getSelectedRows(MultiTableView view) {
        if (view.getObsTableViewer().getTable().getSelectionIndices().length == 0 || view.getObsTableViewer().getTable().getSelectionIndices().length == view.getObsTableViewer().getTable().getItemCount()) {
            int[] selItems = new int[view.getObsTableViewer().getTable().getItemCount()];
            int index = 0;
            while (index < view.getObsTableViewer().getTable().getItemCount()) {
                selItems[index] = index;
                ++index;
            }
            return selItems;
        }
        return (int[])view.getObsTableViewer().getTable().getSelectionIndices().clone();
    }

    private boolean hasAllRowsSelected(MultiTableView view) {
        return view.getObsTableViewer().getTable().getSelectionIndices().length == 0 || view.getObsTableViewer().getTable().getItemCount() == view.getObsTableViewer().getTable().getSelectionIndices().length;
    }

    @Override
    public void updateEnablement(WorkspacesManager wsm) {
        this.setBaseEnabled(wsm.hasCurrentWorkspace() && !GuiCoreActivator.getDefault().getRegistry().getOpenSessions().isEmpty());
    }
}

