/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.preferences;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.wb.swt.SWTResourceManager;
import org.fao.fi.fishstat.gui.Activator;
import org.fao.fi.fishstat.gui.components.ComponentsCommons;
import org.fao.fi.fishstat.gui.preferences.IGuiPreferencesConstants;

public class ProxySettingsPage
extends PreferencePage
implements IWorkbenchPreferencePage,
IGuiPreferencesConstants {
    IPreferenceStore prefstore = Activator.getDefault().getPreferenceStore();
    private Label txtXMLversion;
    private Text txtProxyPORTnumber;
    private Text txtProxyIPaddress;
    private Text txtProxyUserID;
    private Text txtProxyPassword;
    private Button chkProxyActive;

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        RowLayout rowLayout = new RowLayout();
        rowLayout.wrap = false;
        rowLayout.fill = true;
        rowLayout.type = 512;
        composite.setLayout((Layout)rowLayout);
        Group grpXMLversion = new Group(composite, 0);
        grpXMLversion.setText(Activator.getLocalString("preferences.internetaccess.version.text"));
        grpXMLversion.setForeground(ComponentsCommons.getColor((int)0, (int)0, (int)128));
        grpXMLversion.setFont(SWTResourceManager.getFont("", 8, 1));
        grpXMLversion.setLayout((Layout)new GridLayout(2, false));
        grpXMLversion.setLayoutData((Object)new RowData());
        Label lblXMLversion = new Label((Composite)grpXMLversion, 0);
        lblXMLversion.setText(Activator.getLocalString("preferences.internetaccess.url.label"));
        lblXMLversion.setAlignment(131072);
        GridData gdLblXMLversion = new GridData(-1, -1);
        gdLblXMLversion.grabExcessHorizontalSpace = true;
        gdLblXMLversion.horizontalAlignment = 131072;
        lblXMLversion.setLayoutData((Object)gdLblXMLversion);
        this.txtXMLversion = new Label((Composite)grpXMLversion, 2048);
        this.txtXMLversion.setToolTipText(Activator.getLocalString("preferences.internetaccess.url.tooltip"));
        this.txtXMLversion.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        Group grpProxy = new Group(composite, 0);
        grpProxy.setText(Activator.getLocalString("preferences.internetaccess.proxy.title"));
        grpProxy.setForeground(ComponentsCommons.getColor((int)0, (int)0, (int)128));
        grpProxy.setFont(SWTResourceManager.getFont("", 8, 1));
        GridLayout glGrpProxy = new GridLayout();
        glGrpProxy.numColumns = 2;
        grpProxy.setLayout((Layout)glGrpProxy);
        grpProxy.setLayoutData((Object)new RowData());
        new Label((Composite)grpProxy, 0);
        this.chkProxyActive = new Button((Composite)grpProxy, 32);
        GridData gdChkProxyActive = new GridData(16384, 0x1000000, true, false, 1, 1);
        gdChkProxyActive.horizontalIndent = 5;
        gdChkProxyActive.verticalIndent = 10;
        this.chkProxyActive.setLayoutData((Object)gdChkProxyActive);
        this.chkProxyActive.setText(Activator.getLocalString("preferences.internetaccess.proxy.label"));
        Label lblProxyIPaddress = new Label((Composite)grpProxy, 0);
        lblProxyIPaddress.setText(Activator.getLocalString("preferences.internetaccess.server.label"));
        lblProxyIPaddress.setAlignment(131072);
        GridData gdLblProxyIPaddress = new GridData(-1, -1);
        gdLblProxyIPaddress.horizontalIndent = 10;
        gdLblProxyIPaddress.horizontalAlignment = 131072;
        lblProxyIPaddress.setLayoutData((Object)gdLblProxyIPaddress);
        this.txtProxyIPaddress = new Text((Composite)grpProxy, 2048);
        GridData gd_txtProxyIPaddress = new GridData(16384, 0x1000000, true, false);
        gd_txtProxyIPaddress.minimumWidth = 200;
        gd_txtProxyIPaddress.horizontalIndent = 5;
        this.txtProxyIPaddress.setLayoutData((Object)gd_txtProxyIPaddress);
        Label lblProxyPORTnumber = new Label((Composite)grpProxy, 0);
        lblProxyPORTnumber.setText(Activator.getLocalString("preferences.internetaccess.port.label"));
        lblProxyPORTnumber.setAlignment(131072);
        GridData gd_lblProxyPORTnumber = new GridData(131072, 0x1000000, false, false, 1, 1);
        gd_lblProxyPORTnumber.horizontalIndent = 10;
        lblProxyPORTnumber.setLayoutData((Object)gd_lblProxyPORTnumber);
        this.txtProxyPORTnumber = new Text((Composite)grpProxy, 2048);
        GridData gd_txtProxyPORTnumber = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_txtProxyPORTnumber.horizontalIndent = 5;
        this.txtProxyPORTnumber.setLayoutData((Object)gd_txtProxyPORTnumber);
        this.txtProxyPORTnumber.addListener(25, event -> this.validateInput(event, "^([0-9]+)$", Activator.getLocalString("preferences.internetaccess.port.notvalid")));
        Label lblProxyUserID = new Label((Composite)grpProxy, 0);
        GridData gd_lblProxyUserID = new GridData(131072, 0x1000000, false, false, 1, 1);
        gd_lblProxyUserID.horizontalIndent = 10;
        lblProxyUserID.setLayoutData((Object)gd_lblProxyUserID);
        lblProxyUserID.setText(Activator.getLocalString("preferences.internetaccess.user.label"));
        this.txtProxyUserID = new Text((Composite)grpProxy, 2048);
        GridData gd_txtProxyUserID = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_txtProxyUserID.horizontalIndent = 5;
        this.txtProxyUserID.setLayoutData((Object)gd_txtProxyUserID);
        Label lblProxyPassword = new Label((Composite)grpProxy, 0);
        GridData gd_lblProxyPassword = new GridData(131072, 0x1000000, false, false, 1, 1);
        gd_lblProxyPassword.horizontalIndent = 10;
        lblProxyPassword.setLayoutData((Object)gd_lblProxyPassword);
        lblProxyPassword.setText(Activator.getLocalString("preferences.internetaccess.passw.label"));
        this.txtProxyPassword = new Text((Composite)grpProxy, 2048);
        GridData gd_txtProxyPassword = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_txtProxyPassword.horizontalIndent = 5;
        this.txtProxyPassword.setLayoutData((Object)gd_txtProxyPassword);
        this.setGUIvalues();
        return composite;
    }

    private void validateInput(Event event, String regex, String message) {
        String oldS = ((Text)event.widget).getText();
        String newS = String.valueOf(oldS.substring(0, event.start)) + event.text + oldS.substring(event.end);
        boolean isCorrect = newS.matches(regex);
        if (event.widget == this.txtProxyPORTnumber) {
            try {
                int value = Integer.parseInt(newS);
                if (value < 1 || value > 65535) {
                    isCorrect = false;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (isCorrect) {
            this.setValid(true);
            this.setErrorMessage(null);
        } else {
            this.setValid(false);
            this.setErrorMessage(message);
        }
    }

    public void init(IWorkbench workbench) {
    }

    private void setGUIvalues() {
        this.txtXMLversion.setText(this.prefstore.getString("xml.version.url"));
        this.chkProxyActive.setSelection(this.prefstore.getBoolean("proxy.acticated"));
        this.txtProxyIPaddress.setText(this.prefstore.getString("proxy.server.ip"));
        this.txtProxyPORTnumber.setText(this.prefstore.getString("proxy.server.port"));
        this.txtProxyUserID.setText(this.prefstore.getString("proxy.server.user"));
        this.txtProxyPassword.setText(this.prefstore.getString("proxy.server.password"));
    }

    public boolean performOk() {
        this.prefstore.setValue("proxy.acticated", this.chkProxyActive.getSelection());
        this.prefstore.setValue("proxy.server.ip", this.txtProxyIPaddress.getText());
        this.prefstore.setValue("proxy.server.port", this.txtProxyPORTnumber.getText());
        this.prefstore.setValue("proxy.server.user", this.txtProxyUserID.getText());
        this.prefstore.setValue("proxy.server.password", this.txtProxyPassword.getText());
        return super.performOk();
    }
}

