/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.preferences.datadisplay;

import java.beans.Beans;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.fao.fi.fishstat.gui.Activator;
import org.fao.fi.fishstat.gui.preferences.IGuiPreferencesConstants;

public class DataDisplayPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
IGuiPreferencesConstants {
    public static final String ID = "org.fao.fi.fishstat.gui.preferences.datatadisplay.columnwidth";
    private IPreferenceStore prefstore = Activator.getDefault().getPreferenceStore();
    private Spinner spnWidth;
    private Button btnFixedWidth;
    private Button btnDynamicWidth;
    private Button btnDiplaySeriesOnRight;

    public DataDisplayPreferencePage() {
        this.setTitle(Activator.getPluginBundle().getString("preferences.datadisplay.DataDisplayPreferencePage.title"));
        this.setMessage(Activator.getPluginBundle().getString("preferences.datadisplay.DataDisplayPreferencePage.subtitle"));
    }

    protected Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout gl_container = new GridLayout(1, false);
        gl_container.marginRight = 10;
        container.setLayout((Layout)gl_container);
        this.btnDiplaySeriesOnRight = new Button(container, 96);
        this.btnDiplaySeriesOnRight.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 2));
        this.btnDiplaySeriesOnRight.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        });
        this.btnDiplaySeriesOnRight.setText(Activator.getPluginBundle().getString("display.last.timeseries.message"));
        Group grpStatisticalMeasuresColumns = new Group(container, 0);
        grpStatisticalMeasuresColumns.setLayout((Layout)new GridLayout(2, false));
        grpStatisticalMeasuresColumns.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        grpStatisticalMeasuresColumns.setText(Activator.getPluginBundle().getString("label.statistical.measures.columns.width"));
        this.btnDynamicWidth = new Button((Composite)grpStatisticalMeasuresColumns, 16);
        GridData gd_btnDynamicWidth = new GridData(16384, 0x1000000, false, false, 2, 1);
        gd_btnDynamicWidth.widthHint = 150;
        gd_btnDynamicWidth.minimumWidth = 100;
        this.btnDynamicWidth.setLayoutData((Object)gd_btnDynamicWidth);
        this.btnDynamicWidth.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataDisplayPreferencePage.this.spnWidth.setVisible(false);
            }
        });
        this.btnDynamicWidth.setSelection(true);
        this.btnDynamicWidth.setText(Activator.getPluginBundle().getString("label.dynamic.width"));
        this.btnFixedWidth = new Button((Composite)grpStatisticalMeasuresColumns, 16);
        GridData gd_btnFixedWidth = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_btnFixedWidth.widthHint = 150;
        this.btnFixedWidth.setLayoutData((Object)gd_btnFixedWidth);
        this.btnFixedWidth.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataDisplayPreferencePage.this.spnWidth.setVisible(true);
            }
        });
        this.btnFixedWidth.setText(Activator.getPluginBundle().getString("label.fixed.width"));
        this.spnWidth = new Spinner((Composite)grpStatisticalMeasuresColumns, 2048);
        this.spnWidth.setTextLimit(3);
        this.spnWidth.setMinimum(10);
        this.spnWidth.setMaximum(200);
        this.syncroPanel();
        if (Beans.isDesignTime()) {
            this.spnWidth.setVisible(true);
            new Label((Composite)grpStatisticalMeasuresColumns, 0);
            new Label((Composite)grpStatisticalMeasuresColumns, 0);
        }
        return container;
    }

    public void init(IWorkbench workbench) {
    }

    protected void syncroPanel() {
        this.btnDiplaySeriesOnRight.setSelection(this.prefstore.getBoolean("display.series.on.right"));
        this.btnDynamicWidth.setSelection(this.prefstore.getBoolean("display.auto.justify.onscroll"));
        this.btnFixedWidth.setSelection(this.prefstore.getInt("display.fixed.columns.width") > 0);
        this.spnWidth.setSelection(this.prefstore.getInt("display.fixed.columns.width"));
        this.spnWidth.setVisible(this.prefstore.getInt("display.fixed.columns.width") > 0);
    }

    public boolean performOk() {
        this.prefstore.setValue("display.series.on.right", this.btnDiplaySeriesOnRight.getSelection());
        this.prefstore.setValue("display.auto.justify.onscroll", this.btnDynamicWidth.getSelection());
        this.prefstore.setValue("display.fixed.columns.width", this.btnDynamicWidth.getSelection() ? 0 : this.spnWidth.getSelection());
        return super.performOk();
    }

    protected void performDefaults() {
        this.btnDiplaySeriesOnRight.setSelection(this.prefstore.getDefaultBoolean("display.series.on.right"));
        this.btnDynamicWidth.setSelection(this.prefstore.getDefaultBoolean("display.auto.justify.onscroll"));
        this.btnFixedWidth.setSelection(!this.prefstore.getDefaultBoolean("display.auto.justify.onscroll"));
        this.spnWidth.setSelection(this.prefstore.getDefaultInt("display.fixed.columns.width"));
        this.spnWidth.setVisible(this.prefstore.getInt("display.fixed.columns.width") > 0);
        super.performDefaults();
    }
}

