/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.preferences.dataexport;

import java.beans.Beans;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.SWTResourceManager;
import org.fao.fi.fishstat.gui.Activator;
import org.fao.fi.fishstat.gui.dataset.export.ExportSettings;

public class DataExportPreferencesPanel
extends Composite {
    private ExportSettings exportSettings;
    private Button btnHeadersExport;
    private Button btnSplitInTwoColumns;
    private Button btnDontExportSysmbols;
    private Button btnShowSelection;
    private Button btnExportTotals;
    private Text txtSymbolColumnHeader;
    private Label lblSymbolColumnHeader;
    private Button btnExportCitation;

    public DataExportPreferencesPanel(Composite parent, ExportSettings exportSettings) {
        super(parent, 0);
        this.exportSettings = exportSettings;
        this.createPanel();
        this.syncroPanel();
    }

    private void createPanel() {
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 10;
        gridLayout.horizontalSpacing = 0;
        gridLayout.marginHeight = 10;
        gridLayout.marginTop = 10;
        gridLayout.marginLeft = 10;
        gridLayout.marginBottom = 5;
        this.setLayout((Layout)gridLayout);
        this.btnHeadersExport = new Button((Composite)this, 32);
        this.btnHeadersExport.setText(Activator.getPluginBundle().getString("preferences.data.export.panel.header"));
        this.btnHeadersExport.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataExportPreferencesPanel.this.updateGUIDependencies();
            }
        });
        this.btnSplitInTwoColumns = new Button((Composite)this, 32);
        this.btnSplitInTwoColumns.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataExportPreferencesPanel.this.updateGUIDependencies();
            }
        });
        this.btnSplitInTwoColumns.setText(Activator.getPluginBundle().getString("preferences.data.export.panel.splitvalues"));
        Composite userInputGroup = new Composite((Composite)this, 0);
        GridLayout uigLayout = new GridLayout();
        uigLayout.numColumns = 2;
        uigLayout.horizontalSpacing = 10;
        uigLayout.marginWidth = 0;
        uigLayout.verticalSpacing = 0;
        uigLayout.marginLeft = 25;
        uigLayout.marginHeight = 0;
        this.setLayout((Layout)gridLayout);
        userInputGroup.setLayout((Layout)uigLayout);
        this.txtSymbolColumnHeader = new Text(userInputGroup, 2048);
        this.txtSymbolColumnHeader.setFont(SWTResourceManager.getFont("Tahoma", 7, 0));
        this.txtSymbolColumnHeader.setEnabled(false);
        GridData txtGridData = new GridData();
        txtGridData.widthHint = 40;
        this.txtSymbolColumnHeader.setLayoutData((Object)txtGridData);
        this.lblSymbolColumnHeader = new Label(userInputGroup, 64);
        this.lblSymbolColumnHeader.setEnabled(false);
        GridData lblGridData = new GridData();
        lblGridData.verticalSpan = 2;
        this.lblSymbolColumnHeader.setLayoutData((Object)lblGridData);
        this.lblSymbolColumnHeader.setText(Activator.getPluginBundle().getString("preferences.data.export.panel.header.label"));
        this.btnDontExportSysmbols = new Button((Composite)this, 32);
        this.btnDontExportSysmbols.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataExportPreferencesPanel.this.updateGUIDependencies();
            }
        });
        this.btnDontExportSysmbols.setText(Activator.getPluginBundle().getString("preferences.data.export.panel.nosymbols"));
        this.btnShowSelection = new Button((Composite)this, 32);
        this.btnShowSelection.setText(Activator.getPluginBundle().getString("preferences.data.export.panel.showselection"));
        this.btnShowSelection.setToolTipText(Activator.getPluginBundle().getString("preferences.data.export.panel.showselection.tooltip"));
        this.btnExportTotals = new Button((Composite)this, 32);
        this.btnExportTotals.setText(Activator.getPluginBundle().getString("preferences.data.export.panel.showtotals"));
        this.btnExportTotals.setToolTipText(Activator.getPluginBundle().getString("preferences.data.export.panel.showtotals.tooltip"));
        this.btnExportCitation = new Button((Composite)this, 32);
        this.btnExportCitation.setText(Activator.getPluginBundle().getString("preferences.data.export.panel.citation"));
    }

    private void updateGUIDependencies() {
        boolean allowSplitSymbols = true;
        boolean allowDefineSymbolHeader = true;
        if (this.btnDontExportSysmbols.getSelection()) {
            allowSplitSymbols = false;
            allowDefineSymbolHeader = false;
        }
        if (!this.btnHeadersExport.getSelection()) {
            allowDefineSymbolHeader = false;
        }
        this.btnDontExportSysmbols.setEnabled(!this.btnSplitInTwoColumns.getSelection());
        this.btnSplitInTwoColumns.setEnabled(allowSplitSymbols);
        this.txtSymbolColumnHeader.setEnabled(allowDefineSymbolHeader);
        this.lblSymbolColumnHeader.setEnabled(allowDefineSymbolHeader);
    }

    public void applyData() {
        this.exportSettings.setExportHeaders(this.btnHeadersExport.getSelection());
        this.exportSettings.setSplitSymbols(this.btnSplitInTwoColumns.getSelection());
        this.exportSettings.setSymbolHeader(this.txtSymbolColumnHeader.getText());
        this.exportSettings.setNoSymbols(this.btnDontExportSysmbols.getSelection());
        this.exportSettings.setShowSelection(this.btnShowSelection.getSelection());
        this.exportSettings.setExportTotals(this.btnExportTotals.getSelection());
        this.exportSettings.setExportCitation(this.btnExportCitation.getSelection());
    }

    public void syncroPanel() {
        if (!Beans.isDesignTime()) {
            this.btnHeadersExport.setSelection(this.exportSettings.isExportHeaders());
            this.btnSplitInTwoColumns.setSelection(this.exportSettings.isSplitSymbols());
            this.btnDontExportSysmbols.setEnabled(!this.btnSplitInTwoColumns.getSelection());
            this.txtSymbolColumnHeader.setEnabled(this.btnSplitInTwoColumns.getSelection());
            this.lblSymbolColumnHeader.setEnabled(this.btnSplitInTwoColumns.getSelection());
            this.txtSymbolColumnHeader.setText(this.exportSettings.getSymbolHeader() != null ? this.exportSettings.getSymbolHeader() : "");
            this.btnDontExportSysmbols.setSelection(this.exportSettings.isNoSymbols());
            this.btnShowSelection.setSelection(this.exportSettings.isShowSelection());
            this.btnSplitInTwoColumns.setEnabled(!this.btnDontExportSysmbols.getSelection());
            this.btnExportTotals.setSelection(this.exportSettings.isExportTotals());
            this.btnExportCitation.setSelection(this.exportSettings.isExportCitation());
        }
        this.updateGUIDependencies();
    }

    public ExportSettings getExportSettings() {
        return this.exportSettings;
    }
}

