/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.preferences.languages;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wb.swt.SWTResourceManager;
import org.fao.fi.fishstat.gui.Activator;
import org.fao.fi.fishstat.gui.preferences.IGuiPreferencesConstants;
import org.fao.fi.fishstat.gui.preferences.MainPage;

public class LanguagesPreferences
extends MainPage
implements IWorkbenchPreferencePage,
IGuiPreferencesConstants {
    private String locale;
    private Button btnEnglish;
    private Button btnSpanish;
    private Button btnFrench;

    public LanguagesPreferences() {
        this.setTitle(Activator.getLocalString("preferences.languages.title"));
        this.setMessage(Activator.getLocalString("preferences.languages.subtitle"));
    }

    @Override
    public Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setBackground(SWTResourceManager.getColor(19));
        container.setLayout((Layout)new GridLayout(1, false));
        this.btnEnglish = new Button(container, 16);
        this.btnEnglish.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LanguagesPreferences.this.setLocale("en");
            }
        });
        GridData gdBtnEnglish = new GridData(4, 0x1000000, true, false, 1, 1);
        gdBtnEnglish.widthHint = 94;
        this.btnEnglish.setLayoutData((Object)gdBtnEnglish);
        this.btnEnglish.setForeground(SWTResourceManager.getColor(10));
        this.btnEnglish.setBackground(SWTResourceManager.getColor(19));
        this.btnEnglish.setBounds(10, 10, 83, 16);
        this.btnEnglish.setText(Activator.getLocalString("label.english.first.upper"));
        this.btnFrench = new Button(container, 16);
        this.btnFrench.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.btnFrench.setForeground(SWTResourceManager.getColor(10));
        this.btnFrench.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LanguagesPreferences.this.setLocale("fr");
            }
        });
        this.btnFrench.setBounds(10, 32, 83, 16);
        this.btnFrench.setText(Activator.getLocalString("label.french.first.upper"));
        this.btnSpanish = new Button(container, 16);
        this.btnSpanish.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.btnSpanish.setForeground(SWTResourceManager.getColor(10));
        this.btnSpanish.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LanguagesPreferences.this.setLocale("es");
            }
        });
        this.btnSpanish.setBounds(10, 54, 83, 16);
        this.btnSpanish.setText(Activator.getLocalString("label.spanish.first.upper"));
        this.syncroLanguagePanel();
        return container;
    }

    @Override
    public void init(IWorkbench workbench) {
    }

    protected void performApply() {
        this.getShell().getDisplay().asyncExec(() -> this.changeLocaleWithMessage());
    }

    @Override
    public boolean performOk() {
        this.getShell().getDisplay().asyncExec(() -> this.changeLocaleWithMessage());
        return true;
    }

    private void syncroLanguagePanel() {
        this.setLocale(Activator.getLanguage());
        if (this.getLocale().equals("en")) {
            this.btnEnglish.setSelection(true);
        } else if (this.getLocale().equals("fr")) {
            this.btnFrench.setSelection(true);
        } else if (this.getLocale().equals("es")) {
            this.btnSpanish.setSelection(true);
        }
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public String getLocale() {
        return this.locale;
    }

    protected void changeLocaleWithMessage() {
        MessageDialog dialog;
        if (!this.locale.equals(Activator.getLanguage()) && (dialog = new MessageDialog(Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), Activator.getLocalString("label.application.restart"), null, Activator.getLocalString("label.different.locale"), 3, new String[]{"Yes", "No"}, 0)).open() == 0) {
            Activator.changeLocale(this.locale);
            this.dispose();
            PlatformUI.getWorkbench().restart();
        }
    }
}

