/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.properties.dataset.columns.periods;

import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.fao.fi.fishstat.data.timeseries.api.ObservationPeriod;
import org.fao.fi.fishstat.gui.Activator;
import org.fao.fi.fishstat.gui.components.ComponentsCommons;
import org.fao.fi.fishstat.gui.components.widgets.tables.PeriodsSettingsTableViewer;
import org.fao.fi.fishstat.gui.core.properties.TimeSeriesProperties;

public class PeriodsDisplayComposite
extends Composite {
    private final FormToolkit toolkit = new FormToolkit(Display.getCurrent());
    private TimeSeriesProperties properties;
    List<ObservationPeriod> curPeriods = null;
    List<ObservationPeriod> allPeriods = null;
    private PeriodsSettingsTableViewer periodsSettingsTableViewer;

    public PeriodsDisplayComposite(Composite parent, int style, TimeSeriesProperties p) {
        super(parent, style);
        this.setBackground(ComponentsCommons.getColor((int)1));
        this.properties = p;
        this.initComponents();
        this.syncroPanel();
    }

    private void initComponents() {
        this.allPeriods = this.properties.getTimeseries().getObservationPeriods();
        this.curPeriods = this.properties.getPeriods();
        this.toolkit.adapt((Composite)this);
        this.toolkit.paintBordersFor((Composite)this);
        this.setLayout((Layout)new GridLayout(1, false));
        Section sctnPeriods = this.toolkit.createSection((Composite)this, 258);
        GridData gdSctnPeriods = new GridData(4, 4, true, true, 1, 1);
        sctnPeriods.setLayoutData((Object)gdSctnPeriods);
        this.toolkit.paintBordersFor((Composite)sctnPeriods);
        sctnPeriods.setText(Activator.getPluginBundle().getString("label.periods.first.upper"));
        this.periodsSettingsTableViewer = new PeriodsSettingsTableViewer((Composite)sctnPeriods, 0, this.properties, Activator.getLanguage());
        this.toolkit.adapt((Composite)this.periodsSettingsTableViewer);
        this.toolkit.paintBordersFor((Composite)this.periodsSettingsTableViewer);
        sctnPeriods.setClient((Control)this.periodsSettingsTableViewer);
        sctnPeriods.setExpanded(true);
    }

    protected void applyData() {
        if (!this.periodsSettingsTableViewer.getCheckSelection().isEmpty()) {
            this.properties.setPeriods(this.periodsSettingsTableViewer.getCheckSelection());
        } else {
            MessageDialog dialog = new MessageDialog(Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), Activator.getPluginBundle().getString("columns.periods.preference.page.noselection.title"), null, Activator.getPluginBundle().getString("columns.periods.preference.page.noselection.subtitle"), 1, new String[]{Activator.getPluginBundle().getString("label.ok.first.upper")}, 0);
            dialog.open();
        }
    }

    protected void syncroPanel() {
        this.periodsSettingsTableViewer.setCheckList(this.properties.getPeriods(), true);
    }
}

