/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.views.multitable;

import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.fao.fi.fishstat.core.CoreUtils;
import org.fao.fi.fishstat.core.FocusEntity;
import org.fao.fi.fishstat.data.reference.api.ReferenceObject;
import org.fao.fi.fishstat.data.timeseries.api.Measure;
import org.fao.fi.fishstat.data.timeseries.api.ObservationSeries;
import org.fao.fi.fishstat.data.timeseries.api.exceptions.TimeseriesServiceException;
import org.fao.fi.fishstat.gui.Activator;
import org.fao.fi.fishstat.gui.components.ComponentsCommons;
import org.fao.fi.fishstat.gui.core.properties.CalculatedMeasuresProperties;
import org.fao.fi.fishstat.gui.core.session.GuiSession;
import org.fao.fi.fishstat.gui.views.multitable.CalculationTableLabelProvider;
import org.fao.fi.fishstat.gui.views.multitable.MultiTableAbstractViewer;
import org.fao.fi.fishstat.gui.views.multitable.UnifiedContentProvider;

public class CalculationTableViewer
extends MultiTableAbstractViewer {
    private TableColumn[] columns;
    private CalculatedMeasuresProperties calculatedMeasuresProperties;

    public CalculationTableViewer(Composite parent, int style, GuiSession session) {
        super(parent, style);
        this.session = session;
        this.table = this.getTable();
        this.initComponent();
    }

    private void initComponent() {
        this.setUseHashlookup(true);
        this.table.getVerticalBar().setVisible(false);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        this.table.getHorizontalBar().setEnabled(true);
        this.table.getHorizontalBar().setVisible(true);
        this.setContentProvider((IContentProvider)new UnifiedContentProvider());
        this.setLabelProvider((IBaseLabelProvider)new CalculationTableLabelProvider(this.session.getTimeseriesProperties()));
        this.rebuildTable();
    }

    @Override
    protected void rebuildTable() {
        this.calculatedMeasuresProperties = this.session.getTimeseriesProperties().getCalculatedMesaureProperties();
        if (this.calculatedMeasuresProperties != null) {
            this.getTable().setVisible(false);
            if (this.columns != null) {
                int i = 0;
                while (i < this.columns.length) {
                    if (this.columns[i] != null && !this.columns[i].isDisposed()) {
                        this.columns[i].dispose();
                    }
                    ++i;
                }
            }
            int sizeDataColumns = this.calculatedMeasuresProperties.size() + 1;
            this.columns = new TableColumn[sizeDataColumns];
            this.columns[0] = new TableColumn(this.getTable(), 131072);
            this.columns[0].setResizable(false);
            int i = 1;
            while (i < sizeDataColumns) {
                this.columns[i] = new TableColumn(this.getTable(), 16384);
                this.columns[i].setText(this.getColumnHeader(i));
                this.columns[i].setToolTipText(CoreUtils.getAttributeLabel((Object)this.calculatedMeasuresProperties.getMeasures(i - 1).getMeasure().getFunction().getDescription(), (String)Activator.getLanguage()));
                this.columns[i].setWidth(100);
                this.columns[i].setAlignment(131072);
                new MultiTableAbstractViewer.ColumnViewerSorter(this, (ColumnViewer)this, this.columns[i], i - 1){

                    @Override
                    protected int doCompare(Viewer viewer, Object e1, Object e2) {
                        if (e1 == null && e2 != null) {
                            return -1;
                        }
                        if (e1 != null && e2 == null) {
                            return 1;
                        }
                        try {
                            if (e1 instanceof ObservationSeries && e2 instanceof ObservationSeries) {
                                double dd2;
                                Measure m1 = ((ObservationSeries)e1).getCalculatedMeasure(this.idx);
                                Measure m2 = ((ObservationSeries)e2).getCalculatedMeasure(this.idx);
                                if (((ObservationSeries)e1).getKey(0) == ReferenceObject.OTHERS) {
                                    return this.direction;
                                }
                                if (((ObservationSeries)e2).getKey(0) == ReferenceObject.OTHERS) {
                                    return -1 * this.direction;
                                }
                                double dd1 = m1.getValue();
                                if (dd1 == (dd2 = m2.getValue())) {
                                    return m1.getStatus().toString().compareToIgnoreCase(m2.getStatus().toString());
                                }
                                return dd1 < dd2 ? -1 : 1;
                            }
                        }
                        catch (TimeseriesServiceException e) {
                            ComponentsCommons.showExceptionWithStack((Throwable)e);
                        }
                        return 0;
                    }
                };
                ++i;
            }
        }
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                if (((Table)e.widget).getSelectionIndex() == -1) {
                    return;
                }
                int[] positions = ((Table)e.widget).getSelectionIndices();
                for (MultiTableAbstractViewer tableViewer : CalculationTableViewer.this.getParallelTables()) {
                    if (tableViewer.getColumnsCount() <= 0) continue;
                    tableViewer.getTable().select(positions);
                }
            }
        });
        this.getTable().setVisible(true);
    }

    @Override
    protected String getColumnHeader(int column) {
        if (column == 0) {
            return "";
        }
        return this.calculatedMeasuresProperties.getMeasures(column - 1).getMeasureName();
    }

    @Override
    protected void adjournLastFocusEntity(FocusEntity entity) {
    }
}

