/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.views.multitable;

import java.beans.Beans;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.fao.fi.fishstat.core.CoreUtils;
import org.fao.fi.fishstat.core.FSDimensionColumnDescriptor;
import org.fao.fi.fishstat.core.FocusEntity;
import org.fao.fi.fishstat.core.session.Session;
import org.fao.fi.fishstat.data.reference.api.ReferenceObject;
import org.fao.fi.fishstat.data.timeseries.api.ObservationSeries;
import org.fao.fi.fishstat.gui.Activator;
import org.fao.fi.fishstat.gui.core.properties.TimeSeriesProperties;
import org.fao.fi.fishstat.gui.core.session.GuiSession;
import org.fao.fi.fishstat.gui.views.multitable.DimensionTableLabelProvider;
import org.fao.fi.fishstat.gui.views.multitable.MultiTableAbstractViewer;
import org.fao.fi.fishstat.gui.views.multitable.UnifiedContentProvider;

public class DimensionTableViewer
extends MultiTableAbstractViewer
implements SelectionListener {
    private TimeSeriesProperties timeSeriesProperties;
    private TableColumn[] columns;
    private DimensionTableLabelProvider labelProvider;

    public DimensionTableViewer(Composite parent, int style, GuiSession session) {
        super(parent, style);
        this.session = session;
        this.labelProvider = new DimensionTableLabelProvider((Session)session);
        if (!Beans.isDesignTime()) {
            this.timeSeriesProperties = session.getTimeseriesProperties();
        }
        if (this.timeSeriesProperties != null) {
            this.table = this.getTable();
            this.initComponent();
            this.setContentProvider((IContentProvider)new UnifiedContentProvider());
        }
    }

    private void initComponent() {
        this.setUseHashlookup(true);
        this.table.getVerticalBar().setEnabled(false);
        this.table.getVerticalBar().setVisible(false);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        this.table.getHorizontalBar().setEnabled(true);
        this.table.getHorizontalBar().setVisible(true);
        this.rebuildTable();
    }

    @Override
    protected void rebuildTable() {
        if (this.getTable().isDisposed()) {
            return;
        }
        this.getTable().setVisible(false);
        if (this.timeSeriesProperties != null) {
            Display.getDefault().syncExec(() -> {
                if (this.columns != null) {
                    int i2 = 0;
                    while (i2 < this.columns.length) {
                        if (this.columns[i2] != null && !this.columns[i2].isDisposed()) {
                            this.columns[i2].dispose();
                        }
                        ++i2;
                    }
                }
            });
            FSDimensionColumnDescriptor[] descriptors = this.session.getSessionMetadata().getAllDimColumnDescriptors();
            this.columns = new TableColumn[descriptors.length + 1];
            this.columns[0] = new TableColumn(this.getTable(), 16384);
            this.columns[0].setResizable(false);
            int i = 1;
            while (i < this.columns.length) {
                TableViewerColumn tableViewerColumn = new TableViewerColumn((TableViewer)this, 0);
                tableViewerColumn.setLabelProvider((CellLabelProvider)this.labelProvider);
                this.columns[i] = tableViewerColumn.getColumn();
                this.columns[i].setMoveable(true);
                this.columns[i].setText(this.getColumnHeader(i));
                this.columns[i].setToolTipText(this.getColumnTooltip(i));
                this.columns[i].setWidth(120);
                this.columns[i].addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        try {
                            ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
                            commandService.getCommand("org.fao.fi.fishstat.gui.command.data.sort").executeWithChecks(new ExecutionEvent());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                });
                ++i;
            }
        }
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                if (((Table)e.widget).getSelectionIndex() == -1) {
                    return;
                }
                int[] positions = ((Table)e.widget).getSelectionIndices();
                for (MultiTableAbstractViewer tableViewer : DimensionTableViewer.this.getParallelTables()) {
                    if (tableViewer.getColumnsCount() <= 0) continue;
                    tableViewer.getTable().select(positions);
                }
            }
        });
        this.getTable().setVisible(true);
    }

    @Override
    protected String getColumnHeader(int column) {
        if (column == 0) {
            return "";
        }
        FSDimensionColumnDescriptor columnDescriptor = this.session.getSessionMetadata().getDimColumnDescriptor(column - 1);
        String strDimension = columnDescriptor.getDimension() != null ? CoreUtils.getCurrentLangName((Object)columnDescriptor.getDimension(), (String)Activator.getLanguage()) : "";
        String strConcept = columnDescriptor.getConcept() != null ? CoreUtils.getCurrentLangName((Object)columnDescriptor.getConcept(), (String)Activator.getLanguage()) : "";
        return String.valueOf(strDimension) + " (" + strConcept + ")";
    }

    @Override
    protected String getColumnTooltip(int column) {
        if (column == 0) {
            return null;
        }
        FSDimensionColumnDescriptor columnDescriptor = this.session.getSessionMetadata().getDimColumnDescriptor(column - 1);
        if (columnDescriptor.getAttribute() == null) {
            return "";
        }
        return CoreUtils.getCurrentLangName((Object)columnDescriptor.getAttribute(), (String)Activator.getLanguage());
    }

    @Override
    protected void adjournLastFocusEntity(FocusEntity entity) {
        int[] coord = this.getLastClickedCell();
        if (coord != null) {
            ObservationSeries obs = (ObservationSeries)this.getElementAt(coord[0]);
            try {
                FSDimensionColumnDescriptor dsc = this.session.getSessionMetadata().getDimColumnDescriptor(coord[1] - 1);
                ReferenceObject ro = CoreUtils.calcColumnReferenceObject((FSDimensionColumnDescriptor)dsc, (ReferenceObject)obs.getKey(dsc.getDimensionIdx()));
                entity.setColumnDescriptor((Object)dsc);
                entity.setEntity((Object)ro);
            }
            catch (Exception e) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, "org.fao.fi.fishstat.gui.components", "DimensionTableViewer.getPointedObject", (Throwable)e));
            }
        }
        entity.setSource(1);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
    }
}

