/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.views.multitable;

import java.beans.Beans;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.fao.fi.fishstat.core.CoreUtils;
import org.fao.fi.fishstat.core.FSActions;
import org.fao.fi.fishstat.core.FocusEntity;
import org.fao.fi.fishstat.core.IFSActions;
import org.fao.fi.fishstat.core.session.Session;
import org.fao.fi.fishstat.data.common.api.MultilingualString;
import org.fao.fi.fishstat.gui.Activator;
import org.fao.fi.fishstat.gui.core.GuiCoreActivator;
import org.fao.fi.fishstat.gui.core.session.GuiSession;
import org.fao.fi.fishstat.gui.views.multitable.CalculationTableViewer;
import org.fao.fi.fishstat.gui.views.multitable.DimensionTableViewer;
import org.fao.fi.fishstat.gui.views.multitable.ObservationTableViewer;
import org.fao.fi.fishstat.gui.views.multitable.UnifiedComparator;
import org.fao.fi.fishstat.gui.views.multitable.UnifiedSelectionProvider;

public class MultiTableView
extends ViewPart
implements Observer,
IPropertyChangeListener,
IFSActions {
    public static final String ID = "org.fao.fi.fishstat.gui.display.views.multitable";
    protected static final int KEY_VIEW = 1;
    private Composite compositeRight;
    private DimensionTableViewer keyTableViewer;
    protected static final int OBS_VIEW = 2;
    private Composite compositeCenter;
    private ObservationTableViewer obsTableViewer;
    protected static final int CLC_VIEW = 3;
    private Composite compositeLeft;
    private CalculationTableViewer clcTableViewer;
    private SashForm sashForm;
    private GuiSession session;
    private boolean showLastPeriodOnNextRefresh;
    private MenuManager menuMgr;
    private UnifiedComparator advancedSortComparator;

    public void createPartControl(Composite parent) {
        this.session = (GuiSession)GuiCoreActivator.getDefault().getRegistry().getSessionOnFocus();
        this.session.addObserver((Observer)this);
        this.setPartName(this.composePartName());
        this.setTitleToolTip(CoreUtils.getCurrentLang((MultilingualString)this.session.getTimeseries().getDescription(), (String)Activator.getLanguage()));
        this.advancedSortComparator = new UnifiedComparator(this.session.getTimeseriesProperties());
        this.designSashForm(parent);
        Activator.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        GridLayout glCompositeLeft = new GridLayout(1, false);
        glCompositeLeft.horizontalSpacing = 1;
        glCompositeLeft.marginHeight = 0;
        glCompositeLeft.marginWidth = 0;
        glCompositeLeft.verticalSpacing = 0;
        this.compositeLeft.setLayout((Layout)glCompositeLeft);
        if (!Beans.isDesignTime()) {
            this.keyTableViewer = new DimensionTableViewer(this.compositeLeft, 268501762, this.session);
        }
        Table keyTable = this.keyTableViewer.getTable();
        keyTable.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        keyTable.addPaintListener(e -> {
            int topIndex = keyTable.getTopIndex();
            this.obsTableViewer.getTable().setTopIndex(topIndex);
            this.clcTableViewer.getTable().setTopIndex(topIndex);
        });
        keyTable.setHeaderVisible(true);
        this.keyTableViewer.setUseHashlookup(true);
        GridLayout glCompositeCenter = new GridLayout(1, false);
        glCompositeCenter.verticalSpacing = 0;
        glCompositeCenter.marginWidth = 0;
        glCompositeCenter.marginHeight = 0;
        glCompositeCenter.horizontalSpacing = 1;
        this.compositeCenter.setLayout((Layout)glCompositeCenter);
        this.obsTableViewer = new ObservationTableViewer(this.compositeCenter, 268501762, this.session);
        Table obsTable = this.obsTableViewer.getTable();
        obsTable.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        obsTable.addPaintListener(e -> {
            int topIndex = obsTable.getTopIndex();
            this.keyTableViewer.getTable().setTopIndex(topIndex);
            this.clcTableViewer.getTable().setTopIndex(topIndex);
        });
        this.obsTableViewer.setUseHashlookup(true);
        GridLayout glCompositeRight = new GridLayout(1, false);
        glCompositeRight.marginWidth = 0;
        glCompositeRight.verticalSpacing = 0;
        glCompositeRight.marginHeight = 0;
        glCompositeRight.horizontalSpacing = 1;
        this.compositeRight.setLayout((Layout)glCompositeRight);
        this.clcTableViewer = new CalculationTableViewer(this.compositeRight, 268501762, this.session);
        Table clcTable = this.clcTableViewer.getTable();
        clcTable.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        clcTable.addPaintListener(e -> {
            int topIndex = clcTable.getTopIndex();
            this.keyTableViewer.getTable().setTopIndex(topIndex);
            this.obsTableViewer.getTable().setTopIndex(topIndex);
        });
        this.clcTableViewer.setUseHashlookup(true);
        this.keyTableViewer.addParallelTable(this.obsTableViewer);
        this.keyTableViewer.addParallelTable(this.clcTableViewer);
        this.obsTableViewer.addParallelTable(this.keyTableViewer);
        this.obsTableViewer.addParallelTable(this.clcTableViewer);
        this.clcTableViewer.addParallelTable(this.keyTableViewer);
        this.clcTableViewer.addParallelTable(this.obsTableViewer);
        this.menuMgr = new MenuManager();
        Control control1 = this.keyTableViewer.getControl();
        Menu menu1 = this.menuMgr.createContextMenu(control1);
        control1.setMenu(menu1);
        this.getSite().registerContextMenu(this.menuMgr, (ISelectionProvider)this.obsTableViewer);
        Control control2 = this.obsTableViewer.getControl();
        Menu menu2 = this.menuMgr.createContextMenu(control2);
        control2.setMenu(menu2);
        this.getSite().setSelectionProvider((ISelectionProvider)new UnifiedSelectionProvider((ISelectionProvider)this.keyTableViewer, (ISelectionProvider)this.obsTableViewer, (ISelectionProvider)this.clcTableViewer));
        this.resizeSashWeights();
        this.setCommonComparator(new UnifiedComparator(this.session.getTimeseriesProperties()));
    }

    private void designSashForm(Composite parent) {
        this.sashForm = new SashForm(parent, 0);
        this.compositeLeft = new Composite((Composite)this.sashForm, 0);
        this.compositeLeft.addControlListener(new ControlListener(){

            public void controlResized(ControlEvent e) {
                int topIndex = MultiTableView.this.keyTableViewer.getTable().getTopIndex();
                MultiTableView.this.obsTableViewer.getTable().setTopIndex(topIndex);
                MultiTableView.this.clcTableViewer.getTable().setTopIndex(topIndex);
                MultiTableView.this.keyTableViewer.getTable().getHorizontalBar().setVisible(true);
                MultiTableView.this.keyTableViewer.getTable().layout(true);
            }

            public void controlMoved(ControlEvent e) {
            }
        });
        this.compositeCenter = new Composite((Composite)this.sashForm, 0);
        this.compositeRight = new Composite((Composite)this.sashForm, 0);
    }

    public void setCommonComparator(ViewerComparator c) {
        Display.getDefault().syncExec(() -> {
            this.keyTableViewer.setComparator(c);
            this.obsTableViewer.setComparator(c);
            this.clcTableViewer.setComparator(c);
        });
    }

    public void resetSort() {
        Display.getDefault().syncExec(() -> {
            this.keyTableViewer.resetSortColumn();
            this.obsTableViewer.resetSortColumn();
            this.clcTableViewer.resetSortColumn();
        });
    }

    public void setFocus() {
        this.keyTableViewer.getTable().setFocus();
        int index = this.keyTableViewer.getTable().getSelectionIndex();
        if (index >= 0) {
            Activator.getDefault().getStatusBarController().setRecordNumber(index);
        } else {
            Activator.getDefault().getStatusBarController().cleanRecordNumber();
        }
        Activator.getDefault().getStatusBarController().setTotalRecords(this.session);
        Activator.getDefault().getStatusBarController().setUnit(this.session.getUnitValue());
    }

    public GuiSession getSession() {
        return this.session;
    }

    private void allTablesRefresh() {
        this.keyTableViewer.setInput(this.session);
        this.obsTableViewer.setInput(this.session);
        if (this.sashForm.getChildren()[2].isVisible()) {
            this.clcTableViewer.setInput(this.session);
            this.clcTableViewer.refresh(true);
        }
        Activator.getDefault().getStatusBarController().cleanRecordNumber();
    }

    private void resizeSashWeights() {
        int widthCalculated;
        int widthDisplay = PlatformUI.getWorkbench().getDisplay().getClientArea().width;
        int widthDimensions = this.keyTableViewer.getColumnsTotalWidth() + 20;
        int widthObservations = widthDisplay - widthDimensions - (widthCalculated = this.clcTableViewer.getColumnsTotalWidth() + 20);
        if (widthObservations < 300) {
            widthObservations = 300;
        }
        int[] sashWeigts = new int[]{widthDimensions, widthObservations, widthCalculated};
        this.sashForm.setWeights(sashWeigts);
        this.sashForm.getChildren()[2].setVisible(this.session.hasCalculatedMesaures());
        this.sashForm.layout(true);
    }

    public void showLastPeriodOnNextRefresh() {
        this.showLastPeriodOnNextRefresh = true;
    }

    public void dispose() {
        this.session.deleteObserver((Observer)this);
        Activator.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        if (GuiCoreActivator.getDefault().getRegistry().existSession(this.session.getDescriptor())) {
            GuiCoreActivator.getDefault().getRegistry().closeSession((Session)this.session);
        }
        this.session = null;
        super.dispose();
    }

    public DimensionTableViewer getKeyTableViewer() {
        return this.keyTableViewer;
    }

    public ObservationTableViewer getObsTableViewer() {
        return this.obsTableViewer;
    }

    public CalculationTableViewer getClcTableViewer() {
        return this.clcTableViewer;
    }

    public boolean hasClcTableViewer() {
        return this.clcTableViewer != null;
    }

    private String composePartName() {
        StringBuilder sb = new StringBuilder();
        sb.append(CoreUtils.getCurrentLang((MultilingualString)this.session.getDataset().getName(), (String)Activator.getLanguage()));
        sb.append(" - ");
        sb.append(CoreUtils.getCurrentLang((MultilingualString)this.session.getTimeseries().getName(), (String)Activator.getLanguage()));
        return sb.toString();
    }

    public void propertyChange(PropertyChangeEvent event) {
        String property;
        if (!this.isDisposed() && (property = event.getProperty()).startsWith("display.")) {
            if (property.equals("display.fixed.columns.width")) {
                this.obsTableViewer.rebuildTable();
            }
            this.obsTableViewer.setInput(this.session);
            if (this.sashForm.getChildren()[2].isVisible()) {
                this.clcTableViewer.setInput(this.session);
            }
        }
    }

    @Override
    public void update(Observable o, Object arg) {
        if (arg.equals("VIEW_FLUSH")) {
            this.forcedClean();
        } else if (arg.equals("REFRESH")) {
            this.allTablesRefresh();
        } else if (arg instanceof FocusEntity) {
            this.refreshDynamicMenus((FocusEntity)arg);
        } else if (arg instanceof FSActions) {
            Integer[] actions = ((FSActions)arg).toArray();
            Activator.getDefault().getStatusBarController().setUnit(this.session.getUnitValue());
            Display.getDefault().asyncExec(() -> this.refreshViews(actions));
        }
    }

    public void forcedClean() {
        Display display = Display.getDefault();
        display.syncExec(() -> {
            this.keyTableViewer.setItemCount(0);
            this.obsTableViewer.setItemCount(0);
            this.clcTableViewer.setItemCount(0);
        });
    }

    private void refreshViews(Integer[] actions) {
        ISelection currentSelection = this.keyTableViewer.getSelection();
        ViewerComparator currentComparator = this.keyTableViewer.getComparator();
        this.setCommonComparator(null);
        Integer[] integerArray = actions;
        int n = actions.length;
        int n2 = 0;
        while (n2 < n) {
            Integer action = integerArray[n2];
            switch (action) {
                case 21: {
                    this.keyTableViewer.rebuildTable();
                    this.resizeSashWeights();
                    break;
                }
                case 22: {
                    this.obsTableViewer.rebuildTable();
                    this.resizeSashWeights();
                    break;
                }
                case 23: {
                    this.clcTableViewer.rebuildTable();
                    this.resizeSashWeights();
                    break;
                }
                case 81: {
                    this.keyTableViewer.adjournColumnsHeaders(true);
                    break;
                }
                case 82: {
                    this.obsTableViewer.adjournColumnsHeaders(false);
                    break;
                }
                case 83: {
                    this.clcTableViewer.adjournColumnsHeaders(false);
                    break;
                }
                case 91: {
                    this.keyTableViewer.refresh(true);
                    Activator.getDefault().getStatusBarController().cleanRecordNumber();
                    break;
                }
                case 92: {
                    this.obsTableViewer.refresh(true);
                    Activator.getDefault().getStatusBarController().cleanRecordNumber();
                    break;
                }
                case 93: {
                    this.clcTableViewer.refresh(true);
                    Activator.getDefault().getStatusBarController().cleanRecordNumber();
                    break;
                }
                case 42: {
                    this.setCommonComparator(currentComparator);
                    break;
                }
                case 41: {
                    this.advancedSortComparator.clearCache();
                    this.setCommonComparator(this.advancedSortComparator);
                    break;
                }
                case 43: {
                    this.resetSort();
                    break;
                }
            }
            ++n2;
        }
        this.allTablesRefresh();
        if (this.showLastPeriodOnNextRefresh) {
            this.obsTableViewer.getTable().showColumn(this.obsTableViewer.getTable().getColumn(this.obsTableViewer.getTable().getColumnCount() - 1));
            this.showLastPeriodOnNextRefresh = false;
        }
        this.keyTableViewer.setSelection(currentSelection);
        Activator.getDefault().getStatusBarController().setTotalRecords(this.session);
    }

    private void refreshDynamicMenus(FocusEntity entity) {
    }

    public boolean isDisposed() {
        return this.session == null;
    }
}

