/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.workspaces.wizard;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.HttpURLConnection;
import java.text.MessageFormat;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wb.swt.ResourceManager;
import org.fao.fi.fishstat.gui.Activator;
import org.fao.fi.fishstat.gui.autoupdate.AutoUpdateMain;
import org.fao.fi.fishstat.gui.preferences.IGuiPreferencesConstants;
import org.fao.fi.fishstat.gui.workspaces.wizard.InstallNewWorkspaceWizard;

public class DownloadNewWorkspacePage
extends WizardPage
implements IGuiPreferencesConstants {
    private InstallNewWorkspaceWizard wizard;
    private Composite container;
    private Label lblFileName;
    public static final String ID = "org.fao.fi.fishstat.gui.gui.workspaces.wizard.download";

    public DownloadNewWorkspacePage(InstallNewWorkspaceWizard wizard) {
        super(ID);
        this.setImageDescriptor(ResourceManager.getPluginImageDescriptor("org.fao.fi.fishstat.gui", "icons/actions/sugar-cubes-icon.png"));
        this.wizard = wizard;
        this.setTitle(Activator.getPluginBundle().getString("workspaces.installing.download.title"));
        this.setDescription(Activator.getPluginBundle().getString("workspaces.installing.download.description"));
    }

    public void createControl(Composite parent) {
        this.container = new Composite(parent, 0);
        this.container.setLayout((Layout)new FormLayout());
        Label lblURLtext = new Label(this.container, 16384);
        lblURLtext.setText(Activator.getPluginBundle().getString("workspaces.installing.download.from"));
        FormData fdLblURLtext = new FormData();
        fdLblURLtext.top = new FormAttachment(0, 10);
        fdLblURLtext.left = new FormAttachment(0, 5);
        fdLblURLtext.right = new FormAttachment(100, -10);
        lblURLtext.setLayoutData((Object)fdLblURLtext);
        Label lblURLname = new Label(this.container, 16384);
        lblURLname.setText(this.wizard.getAutoUpdateWks().getUrl());
        FormData fdLblURLname = new FormData();
        fdLblURLname.top = new FormAttachment((Control)lblURLtext, 10);
        fdLblURLname.left = new FormAttachment(0, 5);
        fdLblURLname.right = new FormAttachment(100, -10);
        lblURLname.setLayoutData((Object)fdLblURLname);
        Label lblFiletext = new Label(this.container, 16384);
        lblFiletext.setText(Activator.getPluginBundle().getString("workspaces.installing.download.to"));
        FormData fdLblFileText = new FormData();
        fdLblFileText.top = new FormAttachment((Control)lblURLname, 20);
        fdLblFileText.left = new FormAttachment(0, 5);
        fdLblFileText.right = new FormAttachment(100, 5);
        lblFiletext.setLayoutData((Object)fdLblFileText);
        this.lblFileName = new Label(this.container, 16384);
        this.lblFileName.setText(String.valueOf(Activator.getDefault().getPreferenceStore().getString("workspace.download.folder")) + File.separator + this.wizard.getAutoUpdateWks().getUrl().substring(this.wizard.getAutoUpdateWks().getUrl().lastIndexOf(47) + 1));
        FormData fdLblFileName = new FormData();
        fdLblFileName.top = new FormAttachment((Control)lblFiletext, 20);
        fdLblFileName.left = new FormAttachment(0, 5);
        fdLblFileName.right = new FormAttachment(100, -10);
        this.lblFileName.setLayoutData((Object)fdLblFileName);
        this.setControl((Control)this.container);
        File downloadFodler = new File(Activator.getDefault().getPreferenceStore().getString("workspace.download.folder"));
        if (!downloadFodler.exists() || !downloadFodler.isDirectory()) {
            this.setErrorMessage(Activator.getPluginBundle().getString("workspaces.installing.invalidfolder"));
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Activator.getPluginBundle().getString("workspaces.installing.invalidfolder.title"), (String)(String.valueOf(Activator.getDefault().getPreferenceStore().getString("workspace.download.folder")) + "\n\n" + Activator.getPluginBundle().getString("workspaces.installing.invalidfolder.message")));
            this.setPageComplete(false);
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible && this.getErrorMessage() == null) {
            this.getControl().getDisplay().asyncExec(() -> this.doHTTPdownload());
        }
    }

    private void doHTTPdownload() {
        try {
            this.getContainer().run(false, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    DownloadNewWorkspacePage.this.downloadFromURL(DownloadNewWorkspacePage.this.wizard.getAutoUpdateWks().getUrl(), DownloadNewWorkspacePage.this.lblFileName.getText(), monitor);
                }
            });
            this.downloadCompleted();
        }
        catch (Exception e1) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, ID, "Error: " + e1.getMessage(), (Throwable)e1));
        }
    }

    private void downloadCompleted() {
        if (this.wizard.getWsFile() == null) {
            this.setMessage(Activator.getPluginBundle().getString("workspaces.installing.download.failed"), 3);
        } else {
            this.setPageComplete(true);
            this.setMessage(Activator.getPluginBundle().getString("workspaces.installing.download.complete"), 1);
        }
        this.getWizard().getContainer().updateButtons();
        this.container.update();
    }

    private void downloadFromURL(String httpURL, String filePath, IProgressMonitor progressMon) {
        int retry = 0;
        while (retry < 6) {
            if (this.doGetURL(httpURL, filePath, progressMon)) {
                progressMon.done();
                this.wizard.setWsFile(filePath);
                this.downloadCompleted();
                return;
            }
            String myPath = String.valueOf(System.getProperty("user.home")) + File.separator + "Desktop" + File.separator + httpURL.substring(httpURL.lastIndexOf(47) + 1);
            File myFile = new File(myPath);
            Activator.getDefault().getLog().log((IStatus)new Status(1, ID, "---------- download retry #" + retry + " file=" + myFile.length()));
            try {
                TimeUnit.SECONDS.sleep(3L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++retry;
        }
        progressMon.done();
        this.downloadCompleted();
    }

    private boolean doGetURL(String httpURL, String filePath, IProgressMonitor progressMon) {
        long downloadLength;
        File downloadFile;
        FileOutputStream fileOutStream;
        HttpURLConnection httpConnn;
        block41: {
            block42: {
                block39: {
                    block40: {
                        httpConnn = null;
                        fileOutStream = null;
                        downloadFile = new File(filePath);
                        downloadLength = -1L;
                        if (!downloadFile.exists() || downloadFile.length() <= 10000L) break block39;
                        downloadLength = this.getContentLegth(httpURL);
                        if (downloadFile.length() != downloadLength) break block39;
                        Activator.getDefault().getLog().log((IStatus)new Status(1, ID, "file already on disk; file length=" + downloadFile.length()));
                        if (httpConnn == null) break block40;
                        try {
                            httpConnn.disconnect();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (fileOutStream != null) {
                        try {
                            fileOutStream.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    return true;
                }
                Activator.getDefault().getLog().log((IStatus)new Status(1, ID, "download from " + httpURL));
                httpConnn = AutoUpdateMain.openConnection(httpURL);
                if (httpConnn != null) break block41;
                if (httpConnn == null) break block42;
                try {
                    httpConnn.disconnect();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (fileOutStream != null) {
                try {
                    fileOutStream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return false;
        }
        try {
            try {
                httpConnn.setConnectTimeout(0);
                httpConnn.setReadTimeout(0);
                httpConnn.setRequestMethod("GET");
                long downloadSoFar = 0L;
                if (downloadFile.exists() && downloadFile.length() > 20000L) {
                    downloadSoFar = downloadFile.length();
                    Activator.getDefault().getLog().log((IStatus)new Status(1, ID, "resuming download at offset " + downloadFile.length()));
                    this.setMessage(MessageFormat.format(Activator.getPluginBundle().getString("workspaces.installing.download.resumeat"), downloadFile.length()));
                    httpConnn.setRequestProperty("Range", "bytes=" + downloadFile.length() + "-");
                    fileOutStream = new FileOutputStream(filePath, true);
                } else {
                    fileOutStream = new FileOutputStream(filePath);
                }
                httpConnn.connect();
                int code = httpConnn.getResponseCode();
                if (downloadLength == -1L && httpConnn.getContentLengthLong() != -1L) {
                    downloadLength = httpConnn.getContentLengthLong();
                }
                if (code == 200 || code == 206) {
                    progressMon.beginTask(Activator.getPluginBundle().getString("workspaces.installing.download.progress"), (int)(downloadLength / 10000L));
                    InputStream httpInStream = httpConnn.getInputStream();
                    int bytesRead = -1;
                    byte[] buffer = new byte[10000];
                    while ((bytesRead = httpInStream.read(buffer)) != -1) {
                        fileOutStream.write(buffer, 0, bytesRead);
                        progressMon.worked((int)((downloadSoFar += (long)bytesRead) / 10000L));
                    }
                    httpInStream.close();
                    Activator.getDefault().getLog().log((IStatus)new Status(1, ID, String.valueOf(filePath) + " download OK"));
                } else {
                    Activator.getDefault().getLog().log((IStatus)new Status(4, ID, "Error: received response code=" + code + " (expected 200)"));
                }
            }
            catch (Exception exp) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, ID, "Error: " + exp.getMessage(), (Throwable)exp));
                if (httpConnn != null) {
                    try {
                        httpConnn.disconnect();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (fileOutStream != null) {
                    try {
                        fileOutStream.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return false;
            }
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            if (httpConnn != null) {
                try {
                    httpConnn.disconnect();
                }
                catch (Exception exception) {}
            }
            if (fileOutStream != null) {
                try {
                    fileOutStream.close();
                }
                catch (Exception exception) {}
            }
        }
        return true;
    }

    private long getContentLegth(String url) {
        HttpURLConnection conn = null;
        try {
            conn = AutoUpdateMain.openConnection(url);
            if (conn == null) {
                return -1L;
            }
            conn.setRequestMethod("HEAD");
            conn.getInputStream();
            long l = conn.getContentLengthLong();
            return l;
        }
        catch (Exception e) {
            return -1L;
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }
}

