/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.workspaces.wizard;

import java.io.File;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wb.swt.ResourceManager;
import org.fao.fi.fishstat.core.CoreCommons;
import org.fao.fi.fishstat.core.VersionId;
import org.fao.fi.fishstat.core.model.workspace.WorkspaceModel;
import org.fao.fi.fishstat.core.model.workspace.WorkspaceModelImpl;
import org.fao.fi.fishstat.core.workspaces.WorkspacesInstaller;
import org.fao.fi.fishstat.gui.Activator;
import org.fao.fi.fishstat.gui.components.composites.WorkspaceMetadataPanel;
import org.fao.fi.fishstat.gui.workspaces.wizard.InstallNewWorkspacePage1a;
import org.fao.fi.fishstat.gui.workspaces.wizard.InstallNewWorkspacePage2;
import org.fao.fi.fishstat.gui.workspaces.wizard.InstallNewWorkspaceWizard;

public class InstallNewWorkspacePage1
extends WizardPage {
    public static final String ID = "org.fao.fi.fishstat.gui.gui.workspaces.wizard.page01";
    private InstallNewWorkspaceWizard wizard;
    private Label txtFilePath;
    protected Group grpWorkspaceMetadata;
    protected WorkspaceMetadataPanel workspaceMetadataPanel;
    private boolean wizardIsUpdated = false;
    private WorkspaceModelImpl metadata;
    private IWizardPage nextPage;

    public InstallNewWorkspacePage1(InstallNewWorkspaceWizard wizard) {
        super(ID);
        this.setImageDescriptor(ResourceManager.getPluginImageDescriptor("org.fao.fi.fishstat.gui", "icons/actions/sugar-cubes-icon.png"));
        this.wizard = wizard;
        this.setTitle(Activator.getPluginBundle().getString("workspaces.installing.page1.title"));
        this.setDescription(Activator.getPluginBundle().getString("workspaces.installing.page1.description"));
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 3;
        layout.marginWidth = 3;
        layout.horizontalSpacing = 3;
        layout.verticalSpacing = 3;
        layout.numColumns = 3;
        container.setLayout((Layout)layout);
        Label lblSelectFile = new Label(container, 0);
        GridData gdLblSelectFile = new GridData(16384, 0x1000000, false, false, 1, 1);
        lblSelectFile.setLayoutData((Object)gdLblSelectFile);
        lblSelectFile.setText(Activator.getPluginBundle().getString("workspaces.installing.page1.selected"));
        this.txtFilePath = new Label(container, 2052);
        this.txtFilePath.setText("");
        GridData gdTxtFilePath = new GridData(768);
        this.txtFilePath.setLayoutData((Object)gdTxtFilePath);
        this.grpWorkspaceMetadata = new Group(container, 0);
        this.grpWorkspaceMetadata.setBackgroundMode(2);
        GridData gdGrpWorkspaceMetadata = new GridData(4, 4, false, true, 3, 1);
        this.grpWorkspaceMetadata.setVisible(false);
        this.grpWorkspaceMetadata.setLayout((Layout)new FillLayout(256));
        gdGrpWorkspaceMetadata.verticalIndent = 10;
        this.grpWorkspaceMetadata.setLayoutData((Object)gdGrpWorkspaceMetadata);
        this.grpWorkspaceMetadata.setText(Activator.getPluginBundle().getString("workspaces.installing.page1.metadata"));
        this.workspaceMetadataPanel = new WorkspaceMetadataPanel((Composite)this.grpWorkspaceMetadata, 0x1000000, Activator.getLanguage());
        GridLayout gridLayout = (GridLayout)this.workspaceMetadataPanel.getLayout();
        gridLayout.verticalSpacing = 3;
        this.setControl((Control)container);
        this.setPageComplete(false);
    }

    public IWizardPage getPreviousPage() {
        return null;
    }

    public IWizardPage getNextPage() {
        return this.nextPage;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.getControl().getDisplay().asyncExec(() -> this.activatePage());
        }
    }

    private void activatePage() {
        if (this.wizardIsUpdated) {
            return;
        }
        this.wizardIsUpdated = true;
        this.txtFilePath.setText(this.wizard.getWsFile());
        try {
            BusyIndicator.showWhile((Display)Display.getDefault(), () -> {
                try {
                    String xmlMetadata = WorkspacesInstaller.validateWorkspaceFile((File)new File(this.wizard.getWsFile()));
                    this.setMetadata(new WorkspaceModelImpl(xmlMetadata));
                }
                catch (Exception e) {
                    Activator.getDefault().getLog().log((IStatus)new Status(4, ID, "validating workspace " + this.wizard.getWsFile(), (Throwable)e));
                }
            });
            File wsFile = new File(this.wizard.getWsFile());
            this.metadata.setLocationDir(wsFile.getParentFile());
            Activator.getDefault().getLog().log((IStatus)new Status(1, ID, "FishStatJ CoreCommons.COMPATIBILITY = v" + CoreCommons.COMPATIBILITY_MAX.getMajor() + "." + CoreCommons.COMPATIBILITY_MAX.getMinor()));
            Activator.getDefault().getLog().log((IStatus)new Status(1, ID, "check " + this.metadata.getAcronym() + " = v" + this.metadata.getCompatibility().getMajor() + "." + this.metadata.getCompatibility().getMinor()));
            if (!CoreCommons.checkCompatibility((VersionId)this.metadata.getCompatibility())) {
                this.workspaceMetadataPanel.setMetadata((Object)this.metadata);
                this.grpWorkspaceMetadata.setVisible(true);
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Activator.getPluginBundle().getString("workspaces.installing.compatibilityerror.title"), (String)MessageFormat.format(Activator.getPluginBundle().getString("workspaces.installing.compatibilityerror.program.update"), this.metadata.getCompatibility().toString()));
                this.setMessage(Activator.getPluginBundle().getString("workspaces.installing.invalid.version"), 1);
                return;
            }
            this.workspaceMetadataPanel.setMetadata((Object)this.metadata);
            this.grpWorkspaceMetadata.setVisible(true);
            this.setMessage(Activator.getPluginBundle().getString("workspaces.installing.valid.next"), 1);
            int checkLoaded = this.chkWorkspaceNewer(this.metadata);
            if (checkLoaded == 0) {
                this.setPageComplete(true);
                ((WizardPage)this.wizard.getPage("org.fao.fi.fishstat.gui.gui.workspaces.wizard.page01a")).setPageComplete(true);
                ((InstallNewWorkspacePage2)this.wizard.getPage("org.fao.fi.fishstat.gui.gui.workspaces.wizard.page02")).setMetadata(this.metadata);
                this.nextPage = this.wizard.getPage("org.fao.fi.fishstat.gui.gui.workspaces.wizard.page02");
                this.getControl().getDisplay().asyncExec(() -> this.refreshDisplay());
                return;
            }
            this.workspaceMetadataPanel.setMetadata((Object)this.metadata);
            if (checkLoaded == 1) {
                this.setPageComplete(true);
                ((WizardPage)this.wizard.getPage("org.fao.fi.fishstat.gui.gui.workspaces.wizard.page01a")).setPageComplete(false);
                ((InstallNewWorkspacePage2)this.wizard.getPage("org.fao.fi.fishstat.gui.gui.workspaces.wizard.page02")).setMetadata(this.metadata);
                this.nextPage = this.wizard.getPage("org.fao.fi.fishstat.gui.gui.workspaces.wizard.page01a");
                this.getControl().getDisplay().asyncExec(() -> this.refreshDisplay());
            }
            if (checkLoaded == 3) {
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Activator.getPluginBundle().getString("workspaces.installing.compatibilityerror.title"), (String)Activator.getPluginBundle().getString("workspaces.installing.version.smaller.message"));
            }
            if (checkLoaded == 2) {
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Activator.getPluginBundle().getString("workspaces.installing.compatibilityerror.title"), (String)Activator.getPluginBundle().getString("workspaces.installing.version.equal.message"));
            }
            ((InstallNewWorkspacePage1a)this.wizard.getPage("org.fao.fi.fishstat.gui.gui.workspaces.wizard.page01a")).getWorkspaceMetadataPanel().setMetadata((Object)this.metadata);
            ((InstallNewWorkspacePage1a)this.wizard.getPage("org.fao.fi.fishstat.gui.gui.workspaces.wizard.page01a")).getTxtFilePath().setText(this.txtFilePath.getText());
        }
        catch (Exception e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, ID, "loading workspace", (Throwable)e));
            this.setMessage(Activator.getPluginBundle().getString("workspaces.installing.invalid.compatible"), 3);
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Activator.getPluginBundle().getString("workspaces.installing.compatibilityerror.title"), (String)(e.getMessage() == null ? Activator.getPluginBundle().getString("workspaces.installing.page1.cannotload") : e.getMessage()));
        }
    }

    private void refreshDisplay() {
        this.getContainer().updateButtons();
    }

    private int chkWorkspaceNewer(WorkspaceModelImpl metadata) {
        List wsLoaded = CoreCommons.getWorkspacesManager().getRegisteredWorkspaces(metadata.getAcronym());
        if (wsLoaded.isEmpty()) {
            Activator.getDefault().getLog().log((IStatus)new Status(1, ID, "chkWorkspaceNewer 0: new workspace"));
            return 0;
        }
        Activator.getDefault().getLog().log((IStatus)new Status(1, ID, "metadata: " + metadata.getAcronym() + " = v" + metadata.getVersion().getMajor() + "." + metadata.getVersion().getMinor() + "." + metadata.getVersion().getFixes()));
        for (WorkspaceModel wsLoadedMetadata : wsLoaded) {
            Activator.getDefault().getLog().log((IStatus)new Status(1, ID, String.valueOf(wsLoadedMetadata.getAcronym()) + " = v" + wsLoadedMetadata.getVersion().getMajor() + "." + wsLoadedMetadata.getVersion().getMinor() + "." + wsLoadedMetadata.getVersion().getFixes()));
        }
        for (WorkspaceModel wsLoadedMetadata : wsLoaded) {
            if (!metadata.getVersion().equals((Object)wsLoadedMetadata.getVersion())) continue;
            Activator.getDefault().getLog().log((IStatus)new Status(1, ID, "chkWorkspaceNewer 2: same version of an existing workspace" + wsLoadedMetadata.getAcronym() + " = v" + wsLoadedMetadata.getVersion().getMajor() + "." + metadata.getVersion().getMinor() + "." + wsLoadedMetadata.getVersion().getFixes()));
            return 2;
        }
        for (WorkspaceModel wsLoadedMetadata : wsLoaded) {
            if (metadata.getVersion().compareTo(wsLoadedMetadata.getVersion()) >= 0) continue;
            Activator.getDefault().getLog().log((IStatus)new Status(1, ID, "chkWorkspaceNewer 3: older version of an existing workspace" + wsLoadedMetadata.getAcronym() + " = v" + wsLoadedMetadata.getVersion().getMajor() + "." + metadata.getVersion().getMinor() + "." + wsLoadedMetadata.getVersion().getFixes()));
            return 3;
        }
        Activator.getDefault().getLog().log((IStatus)new Status(1, ID, "chkWorkspaceNewer 1: new version of an existing workspace"));
        return 1;
    }

    public void wizardHasNewData() {
        this.wizardIsUpdated = false;
    }

    public void setMetadata(WorkspaceModelImpl metadata) {
        this.metadata = metadata;
    }
}

