/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.data.timeseries.api.management.impl;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.ddlutils.model.Column;
import org.apache.ddlutils.model.Database;
import org.apache.ddlutils.model.Index;
import org.apache.ddlutils.model.IndexColumn;
import org.apache.ddlutils.model.NonUniqueIndex;
import org.apache.ddlutils.model.Table;
import org.apache.ddlutils.model.UniqueIndex;
import org.fao.fi.fishstat.data.common.Commons;
import org.fao.fi.fishstat.data.common.api.MultilingualString;
import org.fao.fi.fishstat.data.common.api.daosupport.GenericDAO;
import org.fao.fi.fishstat.data.common.ddlutils.DdlUtilsHelper;
import org.fao.fi.fishstat.data.reference.api.AttributeType;
import org.fao.fi.fishstat.data.timeseries.api.Attachment;
import org.fao.fi.fishstat.data.timeseries.api.Dataset;
import org.fao.fi.fishstat.data.timeseries.api.Dimension;
import org.fao.fi.fishstat.data.timeseries.api.ObservationPeriod;
import org.fao.fi.fishstat.data.timeseries.api.Timeseries;
import org.fao.fi.fishstat.data.timeseries.api.TimeseriesServiceFactory;
import org.fao.fi.fishstat.data.timeseries.api.impl.DatasetFactory;
import org.fao.fi.fishstat.data.timeseries.api.impl.TimeseriesFactory;
import org.fao.fi.fishstat.data.timeseries.api.impl.TimeseriesServiceHelper;
import org.fao.fi.fishstat.data.timeseries.api.management.TimeseriesManagementService;
import org.fao.fi.fishstat.data.timeseries.api.management.descriptors.AttachmentDescriptor;
import org.fao.fi.fishstat.data.timeseries.api.management.descriptors.DatasetDescriptor;
import org.fao.fi.fishstat.data.timeseries.api.management.descriptors.DimensionDescriptor;
import org.fao.fi.fishstat.data.timeseries.api.management.descriptors.TimeseriesDescriptor;
import org.fao.fi.fishstat.data.timeseries.api.management.exceptions.TimeseriesManagementException;

public class TimeseriesManagementServiceImpl
implements TimeseriesManagementService {
    private static final int VALUE_COLUMN_SIZE = 52;
    private static final int SYMBOL_COLUMN_SIZE = 20;
    private static final String VALUE_COLUMN_PRFIX = "VALUE_";
    private static final String SYMBOL_COLUMN_PRFIX = "SYMBOL_";
    private static final String DIMENSION_WHERE = "DATASET_ID = ?";
    private static final String ATTRIBUTE_WHERE = "TIMESERIES_ID = ?";
    private static final String KEYS_IDX_SUFFIX = "_KEYS_IDX";

    @Override
    public Dataset createDataset(DatasetDescriptor descriptor) throws TimeseriesManagementException {
        try {
            if (descriptor == null) {
                throw new IllegalArgumentException("Dataset descriptor can not be null");
            }
            if (descriptor.getAcronym() == null) {
                throw new IllegalArgumentException("Dataset acronym can not be null");
            }
            if (descriptor.getDimensions() == null || descriptor.getDimensions().size() == 0) {
                throw new IllegalArgumentException("Dataset definition can not be without dimensions");
            }
            Dataset existing = TimeseriesServiceFactory.getService().getDataset(descriptor.getAcronym());
            if (existing != null) {
                throw new IllegalArgumentException("Dataset with acronym: " + descriptor.getAcronym() + " already exists: " + existing.getName());
            }
            Dataset dataset = this.addDatasetEntry(descriptor);
            this.addDimensionsEntries(dataset, descriptor);
            return dataset;
        }
        catch (Exception e) {
            throw new TimeseriesManagementException("Unable to create the dataset", e);
        }
    }

    private Dataset addDatasetEntry(DatasetDescriptor descriptor) throws Exception {
        return DatasetFactory.instance().create(descriptor.getAcronym(), descriptor.getName(), descriptor.getDescription(), descriptor.getDataSource(), descriptor.getUrl(), descriptor.getVersion(), descriptor.getCitation());
    }

    private void addDimensionsEntries(Dataset dataset, DatasetDescriptor descriptor) throws Exception {
        for (DimensionDescriptor dimension : descriptor.getDimensions()) {
            this.addDimensionEntry(dataset, dimension);
        }
    }

    private void addDimensionEntry(Dataset dataset, DimensionDescriptor dimension) throws Exception {
        GenericDAO dimension_dao = TimeseriesServiceHelper.getTsmDimensionDao();
        Class c = TimeseriesServiceHelper.getTsmDimensionDTOClass();
        Constructor constructor = c.getConstructor(new Class[0]);
        Object dimension_dto = constructor.newInstance(new Object[0]);
        Commons.setDTOIdentifier(dimension_dto, (String)dimension_dao.generateId());
        Commons.setDTOAttribute(dimension_dto, (String)"ACRONYM", (Object)dimension.getAcronym(), String.class);
        Commons.setDTOAttribute(dimension_dto, (String)"CONCEPT", (Object)dimension.getConcept().getAcronym(), String.class);
        Commons.setDTOAttribute(dimension_dto, (String)"ATTRIBUTE", (Object)dimension.getAttribute().getAcronym(), String.class);
        Commons.setDTOAttribute(dimension_dto, (String)"DATASET_ID", (Object)dataset.getId().stringValue(), String.class);
        Commons.setDTOAttribute(dimension_dto, (String)"IS_MEASURE", (Object)(dimension.isObservedMeasure() ? (short)1 : 0), Short.class);
        Commons.setMultilingualDTOAttribute(dimension_dto, (String)"NAME", (MultilingualString)dimension.getName());
        Commons.setMultilingualDTOAttribute(dimension_dto, (String)"DESCRIPTION", (MultilingualString)dimension.getDescription());
        dimension_dao.insert(dimension_dto);
    }

    private void removeDimensionEntries(Dataset dataset) throws Exception {
        GenericDAO dimension_dao = TimeseriesServiceHelper.getTsmDimensionDao();
        List dimension_dtos = dimension_dao.findByDynamicWhere(DIMENSION_WHERE, (Object[])new String[]{dataset.getId().stringValue()});
        for (Object dimension_dto : dimension_dtos) {
            dimension_dao.delete(Commons.getDTOPk(dimension_dto));
        }
    }

    @Override
    public void removeDataset(Dataset dataset) throws TimeseriesManagementException {
        try {
            if (dataset == null) {
                throw new IllegalArgumentException("Dataset can not be null");
            }
            Database model = DdlUtilsHelper.reloadDatabase();
            ArrayList to_be_removed = new ArrayList(dataset.getTimeseries());
            for (Timeseries timeseries : to_be_removed) {
                this.removeTimeseriesTable(timeseries, model);
                this.removeTimeseriesEntry(timeseries);
            }
            this.removeDimensionEntries(dataset);
            this.removeDatasetEntry(dataset);
            DdlUtilsHelper.alterDatabase((Database)model);
        }
        catch (Exception e) {
            throw new TimeseriesManagementException("Unable to remove the dataset", e);
        }
    }

    private void removeDatasetEntry(Dataset dataset) throws Exception {
        DatasetFactory.instance().remove(dataset);
    }

    @Override
    public Timeseries createTimeseries(TimeseriesDescriptor descriptor) throws TimeseriesManagementException {
        try {
            if (descriptor == null) {
                throw new IllegalArgumentException("Timeseries descriptor can not be null");
            }
            if (descriptor.getAcronym() == null) {
                throw new IllegalArgumentException("Timeseries acronym can not be null");
            }
            if (descriptor.getDataset() == null) {
                throw new IllegalArgumentException("Dataset reference can not be null");
            }
            Timeseries existing = descriptor.getDataset().getTimeseries(descriptor.getAcronym());
            if (existing != null) {
                throw new IllegalArgumentException("Timeseries with acronym: " + descriptor.getAcronym() + " already exists for dataset: " + descriptor.getDataset().getAcronym());
            }
            Timeseries timeseries = this.addTimeseriesEntry(descriptor);
            this.createTimeseriesTable(descriptor);
            return timeseries;
        }
        catch (Exception e) {
            throw new TimeseriesManagementException("Unable to create the timeseries", e);
        }
    }

    private void createTimeseriesTable(TimeseriesDescriptor descriptor) throws Exception {
        Database model = DdlUtilsHelper.reloadDatabase();
        Table table = new Table();
        table.setSchema("FISHSTAT");
        table.setName("TSD_" + descriptor.getDataset().getAcronym().toUpperCase(Locale.ENGLISH) + "_" + descriptor.getAcronym().toUpperCase(Locale.ENGLISH));
        Column id = new Column();
        id.setName("ID");
        id.setTypeCode(AttributeType.STRING.getJdbcType());
        id.setSize(String.valueOf(20));
        id.setPrimaryKey(true);
        table.addColumn(id);
        UniqueIndex keys_idx = new UniqueIndex();
        keys_idx.setName(String.valueOf(table.getName()) + KEYS_IDX_SUFFIX);
        for (Dimension dimension : descriptor.getDataset().getDimensions()) {
            Column column = new Column();
            column.setName(dimension.getConcept().getAcronym());
            column.setDescription(dimension.getConcept().getDescription().getValue("en"));
            column.setTypeCode(dimension.getAttribute().getType().getJdbcType());
            column.setSize(String.valueOf(dimension.getAttribute().getSize()));
            column.setScale((int)dimension.getAttribute().getScale());
            table.addColumn(column);
            IndexColumn idx_column = new IndexColumn(column);
            NonUniqueIndex idx = new NonUniqueIndex();
            idx.setName(String.valueOf(table.getName()) + "_" + column.getName() + "_IDX");
            idx.addColumn(idx_column);
            table.addIndex((Index)idx);
            keys_idx.addColumn(idx_column);
        }
        table.addIndex((Index)keys_idx);
        for (ObservationPeriod period : descriptor.getObservationPeriods()) {
            Column value_column = new Column();
            value_column.setName(VALUE_COLUMN_PRFIX + period.toString());
            value_column.setTypeCode(AttributeType.DOUBLE.getJdbcType());
            value_column.setSize(String.valueOf(52));
            table.addColumn(value_column);
            Column symbol_column = new Column();
            symbol_column.setName(SYMBOL_COLUMN_PRFIX + period.toString());
            symbol_column.setTypeCode(AttributeType.STRING.getJdbcType());
            symbol_column.setSize(String.valueOf(20));
            table.addColumn(symbol_column);
        }
        model.addTable(table);
        DdlUtilsHelper.alterDatabase((Database)model);
    }

    private Timeseries addTimeseriesEntry(TimeseriesDescriptor descriptor) throws Exception {
        return TimeseriesFactory.instance().create(descriptor.getDataset(), descriptor.getAcronym(), descriptor.getName(), descriptor.getDescription(), descriptor.getDataSource(), descriptor.getTimeResolution(), descriptor.getFirstObservationPeriod(), descriptor.getLastObservationPeriod(), descriptor.getAttributes(), descriptor.getVersion());
    }

    @Override
    public void removeTimeseries(Timeseries timeseries) throws TimeseriesManagementException {
        try {
            if (timeseries == null) {
                throw new IllegalArgumentException("Timeseries can not be null");
            }
            Database model = DdlUtilsHelper.reloadDatabase();
            this.removeTimeseriesTable(timeseries, model);
            this.removeTimeseriesEntry(timeseries);
            DdlUtilsHelper.alterDatabase((Database)model);
        }
        catch (Exception e) {
            throw new TimeseriesManagementException("Unable to create the dataset", e);
        }
    }

    private void removeTimeseriesEntry(Timeseries timeseries) throws Exception {
        GenericDAO attribute_dao = TimeseriesServiceHelper.getTsmAttributeDao();
        List attributes = attribute_dao.findByDynamicWhere(ATTRIBUTE_WHERE, (Object[])new String[]{timeseries.getId().stringValue()});
        if (attributes != null) {
            for (Object attribute_dto : attributes) {
                attribute_dao.delete(Commons.getDTOPk(attribute_dto));
            }
        }
        TimeseriesFactory.instance().remove(timeseries);
    }

    private void removeTimeseriesTable(Timeseries timeseries, Database model) {
        Table table = model.findTable("TSD_" + timeseries.getDataset().getAcronym().toUpperCase(Locale.ENGLISH) + "_" + timeseries.getAcronym().toUpperCase(Locale.ENGLISH));
        model.removeTable(table);
    }

    @Override
    public Attachment addAttachment(AttachmentDescriptor descriptor) throws TimeseriesManagementException {
        try {
            if (descriptor == null) {
                throw new IllegalArgumentException("Attachment descriptor can not be null");
            }
            if (descriptor.getAcronym() == null) {
                throw new IllegalArgumentException("Attachment acronym can not be null");
            }
            if (descriptor.getDataset() == null) {
                throw new IllegalArgumentException("Attachment dataset can not be null");
            }
            if (descriptor.getType() == null) {
                throw new IllegalArgumentException("Attachment type can not be null");
            }
            return DatasetFactory.instance().addAttachment(descriptor.getDataset(), descriptor.getAcronym(), descriptor.getName(), descriptor.getDescription(), descriptor.getType(), descriptor.getMimeType(), descriptor.getFileName());
        }
        catch (Exception e) {
            throw new TimeseriesManagementException(e);
        }
    }

    @Override
    public void removeAttachemnt(Attachment attachment) throws Exception {
        DatasetFactory.instance().remove(attachment);
    }

    @Override
    public int removeAllAttachemnts() throws Exception {
        return TimeseriesServiceHelper.removeAllAttachments();
    }

    @Override
    public void checkDescriptor(AttachmentDescriptor descriptor) throws TimeseriesManagementException {
        if (descriptor.getDataset() == null) {
            throw new TimeseriesManagementException("Dataset cannot be null in attachment descriptor");
        }
        if (descriptor.getType() == null) {
            throw new TimeseriesManagementException("Attachment type cannot be null");
        }
        if (descriptor.getDescription().getLength() > 399) {
            throw new TimeseriesManagementException("Description longer than 400; length=" + descriptor.getDescription().getLength());
        }
        if (descriptor.getName().getLength() > 79) {
            throw new TimeseriesManagementException("Name longer than 80; length=" + descriptor.getName().getLength());
        }
        if (descriptor.getAcronym().length() > 49) {
            throw new TimeseriesManagementException("Acronym longer than 50; length=" + descriptor.getAcronym().length());
        }
    }
}

