/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.data.timeseries.api;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AttachmentType
implements Serializable {
    private static final long serialVersionUID = 672401874483636015L;
    private static final String TYPE_BITMAP = "bmp";
    private static final String TYPE_JPG = "jpg";
    private static final String TYPE_TEXT = "txt";
    private static final String TYPE_PDF = "pdf";
    private static final String TYPE_HTML = "html";
    public static final AttachmentType BITMAP = new AttachmentType("bmp");
    public static final AttachmentType JPG = new AttachmentType("jpg");
    public static final AttachmentType TEXT = new AttachmentType("txt");
    public static final AttachmentType PDF = new AttachmentType("pdf");
    public static final AttachmentType HTML = new AttachmentType("html");
    private static final List<String> TYPE_KEYS = Collections.unmodifiableList(Arrays.asList("bmp", "jpg", "txt", "html", "pdf"));
    public static final Set<AttachmentType> TYPES = Collections.unmodifiableSet(new HashSet<AttachmentType>(Arrays.asList(BITMAP, JPG, TEXT, HTML, PDF)));
    public static final Map<String, String> TYPES_EXTENSION;
    public static final Map<String, String> TYPES_DESCRIPTION;
    public static final Map<String, String> TYPES_MIMETYPES;
    private String type;

    static {
        HashMap<String, String> typesExtension = new HashMap<String, String>();
        typesExtension.put(TYPE_BITMAP, ".bmp");
        typesExtension.put(TYPE_JPG, ".jpg");
        typesExtension.put(TYPE_TEXT, ".txt");
        typesExtension.put(TYPE_PDF, ".pdf");
        typesExtension.put(TYPE_HTML, ".html");
        TYPES_EXTENSION = Collections.unmodifiableMap(typesExtension);
        HashMap<String, String> typesDescription = new HashMap<String, String>();
        typesDescription.put(TYPE_BITMAP, "bmp file");
        typesDescription.put(TYPE_JPG, "jpg file");
        typesDescription.put(TYPE_TEXT, "txt file");
        typesDescription.put(TYPE_HTML, "html file");
        typesDescription.put(TYPE_PDF, "pdf file");
        TYPES_DESCRIPTION = Collections.unmodifiableMap(typesDescription);
        HashMap<String, String> mimeTypes = new HashMap<String, String>();
        mimeTypes.put("image/tiff", "tif");
        mimeTypes.put("image/jpeg", TYPE_JPG);
        mimeTypes.put("image/bmp", TYPE_BITMAP);
        mimeTypes.put("image/jpeg", "jpeg");
        mimeTypes.put("application/plain", "text");
        mimeTypes.put("text/plain", TYPE_TEXT);
        mimeTypes.put("text/html", TYPE_HTML);
        mimeTypes.put("application/pdf", TYPE_PDF);
        TYPES_MIMETYPES = Collections.unmodifiableMap(mimeTypes);
    }

    private AttachmentType(String type) {
        this.type = type;
    }

    private String getType() {
        return this.type;
    }

    public static AttachmentType valueOf(String type) {
        if (TYPE_KEYS.contains(type)) {
            return new AttachmentType(type);
        }
        throw new IllegalArgumentException("Invalid attachment type: " + type);
    }

    public String toString() {
        return this.getType();
    }

    public String getTypeExtension() {
        return TYPES_EXTENSION.get(this.type);
    }

    public String getTypeDescription() {
        return TYPES_DESCRIPTION.get(this.type);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttachmentType)) {
            return false;
        }
        AttachmentType other = (AttachmentType)obj;
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }
}

