/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.data.timeseries.api;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.fao.fi.fishstat.data.common.api.Identifier;
import org.fao.fi.fishstat.data.common.api.MultilingualString;
import org.fao.fi.fishstat.data.common.api.Versioned;
import org.fao.fi.fishstat.data.reference.api.ReferenceObject;
import org.fao.fi.fishstat.data.timeseries.api.Attribute;
import org.fao.fi.fishstat.data.timeseries.api.DataSource;
import org.fao.fi.fishstat.data.timeseries.api.Dataset;
import org.fao.fi.fishstat.data.timeseries.api.Dimension;
import org.fao.fi.fishstat.data.timeseries.api.ObservationPeriod;
import org.fao.fi.fishstat.data.timeseries.api.ObservationSeries;
import org.fao.fi.fishstat.data.timeseries.api.Selection;
import org.fao.fi.fishstat.data.timeseries.api.TimeResolution;
import org.fao.fi.fishstat.data.timeseries.api.TopCriteria;
import org.fao.fi.fishstat.data.timeseries.api.calculated.CalculatedMeasureDefinition;

public interface Timeseries
extends Versioned {
    public Identifier getId();

    public String getAcronym();

    public MultilingualString getName();

    public void setName(MultilingualString var1);

    public MultilingualString getDescription();

    public void setDescription(MultilingualString var1);

    public DataSource getDataSource();

    public void setDataSource(DataSource var1);

    public Dataset getDataset();

    public ObservationSeries getTotals(ReferenceObject var1);

    public Map<Attribute, String> getAttributes();

    public List<ObservationSeries> getObservations();

    public void filter(Selection var1);

    public void select(String var1, Object[] var2);

    public void aggregate(Selection var1);

    public void aggregate(TopCriteria var1, ObservationPeriod var2);

    public void aggregate(TopCriteria var1, CalculatedMeasureDefinition var2);

    public void reset();

    public boolean compatible(ObservationSeries var1);

    public void add(ObservationSeries var1);

    public void add(List<ObservationSeries> var1);

    public void update(ObservationSeries var1);

    public void remove(ObservationSeries var1);

    public void clean();

    public TimeResolution getTimeResolution();

    public ObservationPeriod getFirstObservationPeriod();

    public ObservationPeriod getLastObservationPeriod();

    public List<ObservationPeriod> getObservationPeriods();

    public CalculatedMeasureDefinition getCalculatedMeasureDefinition(String var1);

    public void addCalculatedMeasureDefinition(CalculatedMeasureDefinition var1);

    public void addCalculatedMeasureDefinitions(Collection<CalculatedMeasureDefinition> var1);

    public void removeCalculatedMeasureDefinition(String var1);

    public void removeCalculatedMeasureDefinition(CalculatedMeasureDefinition var1);

    public void removeCalculatedMeasureDefinitions(Collection<CalculatedMeasureDefinition> var1);

    public Collection<CalculatedMeasureDefinition> getCalculatedMeasureDefinitions();

    public void sort(ObservationPeriod var1);

    public void sort(CalculatedMeasureDefinition var1);

    public Collection<ReferenceObject> getReferencedObjects(Dimension var1);

    public Collection<ReferenceObject> getAllReferencedObjects(Dimension var1);

    public int getRowCount();

    public ObservationSeries create();

    public void createGandTotals();

    public List<ReferenceObject> getObsMeasures();
}

