/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.data.timeseries.api.calculated.functions.impl;

import java.util.List;
import java.util.Map;
import org.fao.fi.fishstat.data.reference.api.ReferenceObject;
import org.fao.fi.fishstat.data.timeseries.api.calculated.functions.Descriptive;
import org.fao.fi.fishstat.data.timeseries.api.calculated.functions.impl.FunctionBase;
import org.fao.fi.fishstat.data.timeseries.api.calculated.parameters.Parameter;
import org.fao.fi.fishstat.data.timeseries.api.impl.TimeseriesServiceHelper;

public class Percentile
extends FunctionBase
implements Descriptive {
    public Percentile() {
    }

    public Percentile(ReferenceObject function) {
        super(function);
    }

    @Override
    public double evaluate(List<Double> values, Map<Parameter, String> parameters) {
        int n = values.size();
        if (n == 0) {
            return 0.0;
        }
        double percentile = 100.0;
        try {
            String parameter = parameters.get(this.getParameter(Parameters.PERCENTILE.name()));
            percentile = Double.parseDouble(parameter);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new org.apache.commons.math.stat.descriptive.rank.Percentile().evaluate(TimeseriesServiceHelper.toArray(values), percentile);
    }

    @Override
    public boolean isValidParameterValue(Parameter parameter, String value) {
        if (parameter == null) {
            return true;
        }
        if (Parameters.PERCENTILE.name().equals(parameter.getAcronym())) {
            try {
                double percentile = Double.parseDouble(value);
                return percentile >= 0.0 && percentile <= 100.0;
            }
            catch (Exception e) {
                return false;
            }
        }
        throw new IllegalArgumentException("Not a Percentile parameter: " + parameter);
    }

    public static enum Parameters {
        PERCENTILE;

    }
}

