/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.data.timeseries.api.calculated.functions.impl;

import java.util.Map;
import org.apache.commons.math.stat.regression.SimpleRegression;
import org.fao.fi.fishstat.data.reference.api.ReferenceObject;
import org.fao.fi.fishstat.data.timeseries.api.ObservationPeriod;
import org.fao.fi.fishstat.data.timeseries.api.calculated.functions.Regression;
import org.fao.fi.fishstat.data.timeseries.api.calculated.functions.impl.FunctionBase;
import org.fao.fi.fishstat.data.timeseries.api.calculated.parameters.Parameter;
import org.fao.fi.fishstat.data.timeseries.api.impl.TimeseriesServiceHelper;

public class RegPredict
extends FunctionBase
implements Regression {
    public RegPredict() {
    }

    public RegPredict(ReferenceObject function) {
        super(function);
    }

    @Override
    public double evaluate(Map<Double, Double> values, Map<Parameter, String> parameters) {
        int n = values.size();
        if (n == 0) {
            return 0.0;
        }
        String parameter = parameters.get(this.getParameter(Parameters.PREDICTED_PERIOD.name()));
        ObservationPeriod period = ObservationPeriod.valueOf(parameter);
        int x = period.getOrdinalNumber();
        SimpleRegression regression = new SimpleRegression();
        regression.addData(TimeseriesServiceHelper.toArray(values));
        try {
            return Math.max(0.0, regression.predict((double)x));
        }
        catch (Exception e) {
            return Double.NaN;
        }
    }

    @Override
    public boolean isValidParameterValue(Parameter parameter, String value) {
        if (parameter == null) {
            return true;
        }
        if (Parameters.PREDICTED_PERIOD.name().equalsIgnoreCase(parameter.getAcronym())) {
            try {
                return ObservationPeriod.isValid(value);
            }
            catch (Exception e) {
                return false;
            }
        }
        throw new IllegalArgumentException("Not a valid observation period parameter: " + parameter);
    }

    public static enum Parameters {
        PREDICTED_PERIOD;

    }
}

