/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.data.timeseries.api.calculated.functions.impl;

import java.util.List;
import java.util.Map;
import org.fao.fi.fishstat.data.reference.api.ReferenceObject;
import org.fao.fi.fishstat.data.timeseries.api.calculated.functions.Descriptive;
import org.fao.fi.fishstat.data.timeseries.api.calculated.functions.impl.FunctionBase;
import org.fao.fi.fishstat.data.timeseries.api.calculated.parameters.Parameter;
import org.fao.fi.fishstat.data.timeseries.api.impl.TimeseriesServiceHelper;

public class Variance
extends FunctionBase
implements Descriptive {
    public Variance() {
    }

    public Variance(ReferenceObject function) {
        super(function);
    }

    @Override
    public double evaluate(List<Double> values, Map<Parameter, String> parameters) {
        int n = values.size();
        if (n == 0) {
            return 0.0;
        }
        String parameter = parameters.get(this.getParameter(Parameters.BIAS_CORRECTED.name()));
        boolean bias_corrected = true;
        try {
            bias_corrected = Boolean.parseBoolean(parameter);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new org.apache.commons.math.stat.descriptive.moment.Variance(bias_corrected).evaluate(TimeseriesServiceHelper.toArray(values));
    }

    @Override
    public String[] getParameterEnumeratedValues(Parameter parameter) {
        if (Parameters.BIAS_CORRECTED.name().equals(parameter.getAcronym())) {
            return new String[]{Boolean.TRUE.toString(), Boolean.FALSE.toString()};
        }
        return null;
    }

    @Override
    public boolean isValidParameterValue(Parameter parameter, String value) {
        if (parameter == null) {
            return true;
        }
        if (Parameters.BIAS_CORRECTED.name().equals(parameter.getAcronym())) {
            try {
                Boolean.parseBoolean(value);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        throw new IllegalArgumentException("Not a variance parameter: " + parameter);
    }

    public static enum Parameters {
        BIAS_CORRECTED;

    }
}

