/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.data.timeseries.api.impl;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.fao.fi.fishstat.data.common.Commons;
import org.fao.fi.fishstat.data.common.api.Identifier;
import org.fao.fi.fishstat.data.common.api.IdentifierFactory;
import org.fao.fi.fishstat.data.common.api.MultilingualString;
import org.fao.fi.fishstat.data.common.api.Version;
import org.fao.fi.fishstat.data.common.api.daosupport.GenericDAO;
import org.fao.fi.fishstat.data.common.api.impl.VersionHelper;
import org.fao.fi.fishstat.data.common.register.RegistryFactory;
import org.fao.fi.fishstat.data.common.register.StructuralChangeEvent;
import org.fao.fi.fishstat.data.common.register.StructuralChangeEventListener;
import org.fao.fi.fishstat.data.timeseries.api.Attachment;
import org.fao.fi.fishstat.data.timeseries.api.AttachmentType;
import org.fao.fi.fishstat.data.timeseries.api.DataSource;
import org.fao.fi.fishstat.data.timeseries.api.Dataset;
import org.fao.fi.fishstat.data.timeseries.api.exceptions.TimeseriesServiceException;
import org.fao.fi.fishstat.data.timeseries.api.impl.AttachmentImpl;
import org.fao.fi.fishstat.data.timeseries.api.impl.DatasetImpl;
import org.fao.fi.fishstat.data.timeseries.api.impl.TimeseriesServiceHelper;

public class DatasetFactory
implements StructuralChangeEventListener {
    private static DatasetFactory instance;
    private Map<Identifier, String> keys;
    private Map<String, Dataset> datasets;

    public static DatasetFactory instance() throws Exception {
        if (instance == null) {
            instance = new DatasetFactory();
        }
        return instance;
    }

    private DatasetFactory() throws Exception {
        this.init();
        this.register();
    }

    private void init() throws Exception {
        this.datasets = Collections.synchronizedMap(new HashMap());
        this.keys = Collections.synchronizedMap(new HashMap());
        List dataset_dtos = null;
        try {
            dataset_dtos = TimeseriesServiceHelper.getTsmDatasetDao().findAll();
        }
        catch (Exception e) {
            throw new TimeseriesServiceException("finder method call failed: " + e.getMessage(), e);
        }
        if (dataset_dtos == null) {
            throw new TimeseriesServiceException("finder method returned null or less than 1 result");
        }
        for (Object dto : dataset_dtos) {
            String id = Commons.getDTOIdentifier(dto);
            String acronym = (String)Commons.getDTOAttributeByAcronym(dto, (String)"ACRONYM");
            this.datasets.put(acronym, new DatasetImpl(dto));
            this.keys.put(IdentifierFactory.instance((String)id), acronym);
        }
    }

    private void register() {
        RegistryFactory.getRegistry((Object)this).registerListener(StructuralChangeEvent.WORKSPACE_CHANGE, (StructuralChangeEventListener)this);
    }

    private Map<String, Dataset> datasets() throws Exception {
        if (this.datasets == null) {
            this.init();
        }
        return this.datasets;
    }

    private Map<Identifier, String> keys() throws Exception {
        if (this.keys == null) {
            this.init();
        }
        return this.keys;
    }

    public synchronized Collection<Dataset> getDatasets() throws Exception {
        return this.datasets().values();
    }

    public synchronized Dataset getDataset(String acronym) throws Exception {
        return this.datasets().get(acronym);
    }

    public synchronized Dataset getDataset(Identifier id) throws Exception {
        return this.datasets().get(this.keys().get(id));
    }

    private synchronized void reset() {
        if (this.keys != null) {
            this.keys.clear();
            this.keys = null;
        }
        if (this.datasets != null) {
            this.datasets.clear();
            this.datasets = null;
        }
    }

    public synchronized Dataset create(String acronym, MultilingualString name, MultilingualString description, DataSource dataSource, String url, Version version, String citation) throws Exception {
        GenericDAO dataset_dao = TimeseriesServiceHelper.getTsmDatasetDao();
        Class<?> c = TimeseriesServiceHelper.getTsmDatasetDTOClass();
        Constructor<?> constructor = c.getConstructor(new Class[0]);
        Identifier id = IdentifierFactory.instance((String)dataset_dao.generateId());
        Object dataset_dto = constructor.newInstance(new Object[0]);
        Commons.setDTOIdentifier(dataset_dto, (String)id.stringValue());
        Commons.setDTOAttribute(dataset_dto, (String)"ACRONYM", (Object)acronym, String.class);
        Commons.setDTOAttribute(dataset_dto, (String)"DATA_SOURCE", (Object)dataSource.getName(), String.class);
        Commons.setMultilingualDTOAttribute(dataset_dto, (String)"NAME", (MultilingualString)name);
        Commons.setMultilingualDTOAttribute(dataset_dto, (String)"DESCRIPTION", (MultilingualString)description);
        Commons.setDTOAttribute(dataset_dto, (String)"URL", (Object)url, String.class);
        Commons.setDTOAttribute(dataset_dto, (String)"CITATION", (Object)citation, String.class);
        VersionHelper.setVersion(dataset_dto, (Version)version);
        dataset_dao.insert(dataset_dto);
        DatasetImpl dataset = new DatasetImpl(dataset_dto);
        this.datasets().put(acronym, dataset);
        this.keys().put(id, acronym);
        return dataset;
    }

    public synchronized void remove(Dataset dataset) throws Exception {
        Identifier id = dataset.getId();
        GenericDAO dataset_dao = TimeseriesServiceHelper.getTsmDatasetDao();
        Object dataset_dto = dataset_dao.findById(dataset.getId().stringValue());
        dataset_dao.delete(Commons.getDTOPk((Object)dataset_dto));
        this.datasets().remove(this.keys().remove(id));
    }

    public void onStructuralChangeEvent(StructuralChangeEvent change) throws IllegalStateException {
        this.reset();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.keys == null ? 0 : this.keys.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatasetFactory)) {
            return false;
        }
        DatasetFactory other = (DatasetFactory)obj;
        return !(this.keys == null ? other.keys != null : !this.keys.equals(other.keys));
    }

    public synchronized List<Attachment> getAttachments(Dataset dataset) throws Exception {
        List<Attachment> attachments = Collections.synchronizedList(new ArrayList());
        List attachments_dtos = null;
        try {
            attachments_dtos = TimeseriesServiceHelper.getTsmDatasetAttachmentDao().findByAttribute("DATASET_ID", String.class, (Object)dataset.getId().stringValue());
        }
        catch (Exception e) {
            throw new TimeseriesServiceException("finder method call failed: " + e.getMessage(), e);
        }
        if (attachments_dtos == null) {
            throw new TimeseriesServiceException("finder method returned null or less than 1 result");
        }
        for (Object dto : attachments_dtos) {
            attachments.add(new AttachmentImpl(dto));
        }
        return attachments;
    }

    public synchronized Attachment getAttachment(Dataset dataset, String acronym) throws Exception {
        for (Attachment att : this.getAttachments(dataset)) {
            if (!att.getAcronym().equals(acronym)) continue;
            return att;
        }
        return null;
    }

    public synchronized Attachment addAttachment(Dataset dataset, String acronym, MultilingualString name, MultilingualString description, AttachmentType type, String mimeType, MultilingualString fileName) throws Exception {
        GenericDAO attachment_dao = TimeseriesServiceHelper.getTsmDatasetAttachmentDao();
        Class<?> c = TimeseriesServiceHelper.getTsmAttachmentDTOClass();
        Constructor<?> constructor = c.getConstructor(new Class[0]);
        Identifier id = IdentifierFactory.instance((String)attachment_dao.generateId());
        Object attachment_dto = constructor.newInstance(new Object[0]);
        Commons.setDTOIdentifier(attachment_dto, (String)id.stringValue());
        Commons.setDTOAttribute(attachment_dto, (String)"ACRONYM", (Object)acronym, String.class);
        Commons.setDTOAttribute(attachment_dto, (String)"DATASET_ID", (Object)dataset.getId().stringValue(), String.class);
        Commons.setMultilingualDTOAttribute(attachment_dto, (String)"NAME", (MultilingualString)name);
        Commons.setMultilingualDTOAttribute(attachment_dto, (String)"DESCRIPTION", (MultilingualString)description);
        Commons.setDTOAttribute(attachment_dto, (String)"TYPE_ATTACHMENT", (Object)type.toString(), String.class);
        Commons.setMultilingualDTOAttribute(attachment_dto, (String)"SOURCE_FILE_NAME", (MultilingualString)fileName);
        Commons.setDTOAttribute(attachment_dto, (String)"MIME_TYPE", (Object)mimeType, String.class);
        attachment_dao.insert(attachment_dto);
        AttachmentImpl attachment = new AttachmentImpl(attachment_dto);
        return attachment;
    }

    public synchronized void remove(Attachment attachment) throws Exception {
        GenericDAO attachment_dao = TimeseriesServiceHelper.getTsmDatasetAttachmentDao();
        Object attachment_dto = attachment_dao.findById(attachment.getId().stringValue());
        attachment_dao.delete(Commons.getDTOPk((Object)attachment_dto));
    }
}

