/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.data.timeseries.api.impl;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.fao.fi.fishstat.data.common.Commons;
import org.fao.fi.fishstat.data.common.api.Identifier;
import org.fao.fi.fishstat.data.common.api.IdentifierFactory;
import org.fao.fi.fishstat.data.common.api.MultilingualString;
import org.fao.fi.fishstat.data.common.api.Version;
import org.fao.fi.fishstat.data.common.api.daosupport.GenericDAO;
import org.fao.fi.fishstat.data.common.api.impl.VersionHelper;
import org.fao.fi.fishstat.data.common.register.RegistryFactory;
import org.fao.fi.fishstat.data.common.register.StructuralChangeEvent;
import org.fao.fi.fishstat.data.common.register.StructuralChangeEventListener;
import org.fao.fi.fishstat.data.timeseries.api.Attribute;
import org.fao.fi.fishstat.data.timeseries.api.DataSource;
import org.fao.fi.fishstat.data.timeseries.api.Dataset;
import org.fao.fi.fishstat.data.timeseries.api.ObservationPeriod;
import org.fao.fi.fishstat.data.timeseries.api.TimeResolution;
import org.fao.fi.fishstat.data.timeseries.api.Timeseries;
import org.fao.fi.fishstat.data.timeseries.api.exceptions.TimeseriesServiceException;
import org.fao.fi.fishstat.data.timeseries.api.impl.DatasetFactory;
import org.fao.fi.fishstat.data.timeseries.api.impl.TimeseriesImpl;
import org.fao.fi.fishstat.data.timeseries.api.impl.TimeseriesServiceHelper;

public class TimeseriesFactory
implements StructuralChangeEventListener {
    private static TimeseriesFactory instance;
    private Map<Identifier, String> keys;
    private Map<String, Timeseries> timeseries;

    private TimeseriesFactory() throws Exception {
        this.init();
        this.register();
    }

    private void init() throws Exception {
        this.timeseries = Collections.synchronizedMap(new HashMap());
        this.keys = Collections.synchronizedMap(new HashMap());
        List timeseries_dtos = null;
        try {
            timeseries_dtos = TimeseriesServiceHelper.getTsmTimeseriesDao().findAll();
        }
        catch (Exception e) {
            throw new TimeseriesServiceException("finder method call failed: " + e.getMessage(), e);
        }
        if (timeseries_dtos == null) {
            throw new TimeseriesServiceException("finder method returned null");
        }
        for (Object dto : timeseries_dtos) {
            String id = Commons.getDTOIdentifier(dto);
            String acronym = (String)Commons.getDTOAttributeByAcronym(dto, (String)"ACRONYM");
            Dataset dataset = DatasetFactory.instance().getDataset(IdentifierFactory.instance((String)((String)Commons.getDTOAttributeByAcronym(dto, (String)"DATASET_ID"))));
            String full_acronym = TimeseriesFactory.buildAcronym(dataset, acronym);
            this.timeseries.put(full_acronym, new TimeseriesImpl(dto, dataset));
            this.keys.put(IdentifierFactory.instance((String)id), full_acronym);
        }
    }

    public static TimeseriesFactory instance() throws Exception {
        if (instance == null) {
            instance = new TimeseriesFactory();
        }
        return instance;
    }

    private Map<String, Timeseries> timeseries() throws Exception {
        if (this.timeseries == null) {
            this.init();
        }
        return this.timeseries;
    }

    private Map<Identifier, String> keys() throws Exception {
        if (this.keys == null) {
            this.init();
        }
        return this.keys;
    }

    public synchronized Collection<Timeseries> getTimeseries() throws Exception {
        return this.timeseries().values();
    }

    public synchronized Timeseries getTimeseries(Dataset dataset, String acronym) throws Exception {
        return this.timeseries().get(TimeseriesFactory.buildAcronym(dataset, acronym));
    }

    private static String buildAcronym(Dataset dataset, String acronym) {
        StringBuilder builder = new StringBuilder();
        return builder.append(dataset.getAcronym()).append("_").append(acronym).toString();
    }

    public synchronized Timeseries getTimeseries(Identifier id) throws Exception {
        return this.timeseries().get(this.keys().get(id));
    }

    public synchronized void reset() {
        if (this.keys != null) {
            this.keys.clear();
            this.keys = null;
        }
        if (this.timeseries != null) {
            this.timeseries.clear();
            this.timeseries = null;
        }
    }

    public synchronized Timeseries create(Dataset dataset, String acronym, MultilingualString name, MultilingualString description, DataSource datasource, TimeResolution resolution, ObservationPeriod firstObservationPeriod, ObservationPeriod lastObservationPeriod, Map<Attribute, String> attributes, Version version) throws Exception {
        GenericDAO timeseries_dao = TimeseriesServiceHelper.getTsmTimeseriesDao();
        Class<?> c = TimeseriesServiceHelper.getTsmTimeseriesDTOClass();
        Constructor<?> constructor = c.getConstructor(new Class[0]);
        Object timeseries_dto = constructor.newInstance(new Object[0]);
        Identifier id = IdentifierFactory.instance((String)timeseries_dao.generateId());
        Commons.setDTOIdentifier(timeseries_dto, (String)id.stringValue());
        Commons.setDTOAttribute(timeseries_dto, (String)"ACRONYM", (Object)acronym, String.class);
        Commons.setDTOAttribute(timeseries_dto, (String)"DATASET_ID", (Object)dataset.getId().stringValue(), String.class);
        Commons.setDTOAttribute(timeseries_dto, (String)"DATA_SOURCE", (Object)datasource.getName(), String.class);
        Commons.setDTOAttribute(timeseries_dto, (String)"FIRST_PERIOD", (Object)firstObservationPeriod.toString(), String.class);
        Commons.setDTOAttribute(timeseries_dto, (String)"LAST_PERIOD", (Object)lastObservationPeriod.toString(), String.class);
        Commons.setDTOAttribute(timeseries_dto, (String)"TIME_RESOLUTION", (Object)resolution.toString(), String.class);
        Commons.setMultilingualDTOAttribute(timeseries_dto, (String)"NAME", (MultilingualString)name);
        Commons.setMultilingualDTOAttribute(timeseries_dto, (String)"DESCRIPTION", (MultilingualString)description);
        VersionHelper.setVersion(timeseries_dto, (Version)version);
        timeseries_dao.insert(timeseries_dto);
        if (attributes != null) {
            GenericDAO attribute_dao = TimeseriesServiceHelper.getTsmAttributeDao();
            for (Map.Entry<Attribute, String> entry : attributes.entrySet()) {
                Attribute attribute = entry.getKey();
                String value = entry.getValue();
                Class<?> clazz = TimeseriesServiceHelper.getTsmAttributeDTOClass();
                Constructor<?> attribute_constructor = clazz.getConstructor(new Class[0]);
                Object attribute_dto = attribute_constructor.newInstance(new Object[0]);
                Commons.setDTOIdentifier(attribute_dto, (String)attribute_dao.generateId());
                Commons.setDTOAttribute(attribute_dto, (String)"ACRONYM", (Object)attribute.getAcronym(), String.class);
                Commons.setDTOAttribute(attribute_dto, (String)"TIMESERIES_ID", (Object)Commons.getDTOIdentifier(timeseries_dto), String.class);
                Commons.setMultilingualDTOAttribute(attribute_dto, (String)"NAME", (MultilingualString)attribute.getName());
                Commons.setMultilingualDTOAttribute(attribute_dto, (String)"DESCRIPTION", (MultilingualString)attribute.getDescription());
                Commons.setDTOAttribute(attribute_dto, (String)"VALUE", (Object)value, String.class);
                attribute_dao.insert(attribute_dto);
            }
        }
        TimeseriesImpl timeseries = new TimeseriesImpl(timeseries_dto, dataset);
        String full_acronym = TimeseriesFactory.buildAcronym(dataset, acronym);
        this.timeseries().put(full_acronym, timeseries);
        this.keys().put(id, full_acronym);
        return timeseries;
    }

    public synchronized void remove(Timeseries timeseries) throws Exception {
        Identifier id = timeseries.getId();
        GenericDAO timeseries_dao = TimeseriesServiceHelper.getTsmTimeseriesDao();
        Object timeseries_dto = timeseries_dao.findById(timeseries.getId().stringValue());
        timeseries_dao.delete(Commons.getDTOPk((Object)timeseries_dto));
        this.timeseries().remove(this.keys().remove(id));
    }

    public synchronized Collection<Timeseries> getTimeseries(Dataset dataset) throws Exception {
        ArrayList<Timeseries> result = new ArrayList<Timeseries>();
        for (Timeseries timeseries : this.getTimeseries()) {
            if (!timeseries.getDataset().equals(dataset)) continue;
            result.add(timeseries);
        }
        return result;
    }

    private void register() {
        RegistryFactory.getRegistry((Object)this).registerListener(StructuralChangeEvent.WORKSPACE_CHANGE, (StructuralChangeEventListener)this);
    }

    public void onStructuralChangeEvent(StructuralChangeEvent change) throws IllegalStateException {
        this.reset();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.keys == null ? 0 : this.keys.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimeseriesFactory)) {
            return false;
        }
        TimeseriesFactory other = (TimeseriesFactory)obj;
        return !(this.keys == null ? other.keys != null : !this.keys.equals(other.keys));
    }
}

