/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.data.timeseries.test;

import java.util.List;
import org.fao.fi.fishstat.data.common.utils.JUnitTestHelper;
import org.fao.fi.fishstat.data.reference.api.Concept;
import org.fao.fi.fishstat.data.reference.api.ReferenceObject;
import org.fao.fi.fishstat.data.reference.api.ReferenceServiceFactory;
import org.fao.fi.fishstat.data.timeseries.api.ObservationSeries;
import org.fao.fi.fishstat.data.timeseries.api.Selection;
import org.fao.fi.fishstat.data.timeseries.api.Timeseries;
import org.fao.fi.fishstat.data.timeseries.api.TimeseriesServiceFactory;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestDatasetTestCase {
    @BeforeClass
    public static void setUp() throws Exception {
        JUnitTestHelper.setTestActiveWorkspace();
    }

    @Test
    public void testUnknownKey() throws Exception {
        Timeseries timeseries = TimeseriesServiceFactory.getService().getDataset("AQUACULTURE").getTimeseries("QUANTITY");
        for (ObservationSeries series : timeseries.getObservations()) {
            System.out.println(series);
        }
    }

    @Test
    public void testGroupByContinent() throws Exception {
        Timeseries timeseries = TimeseriesServiceFactory.getService().getDataset("AQUACULTURE").getTimeseries("QUANTITY");
        Selection selection = Selection.instance();
        Concept country = ReferenceServiceFactory.getService().getConcept("COUNTRY");
        Concept continent = ReferenceServiceFactory.getService().getConcept("CONTINENT");
        for (ReferenceObject object : continent.getObjects()) {
            selection.add(country, object);
        }
        System.out.println("selection:\n" + selection);
        System.out.println("grouping by continent...");
        timeseries.aggregate(selection);
        List<ObservationSeries> result = timeseries.getObservations();
        System.out.println("found: " + result.size());
        for (ObservationSeries observation : result) {
            System.out.println(observation);
        }
    }
}

