package @package@;

import java.io.*;
import java.sql.*;

/**
 * Generic Base class for DAO classes.
 *
 * This is a customizable template within FireStorm/DAO.
 */
public abstract class AbstractDAO
{
	/** 
	 * SQL COUNT(*) statement for this table
	 */
	protected final String SQL_COUNT = "SELECT COUNT(*) FROM FISHSTAT." + getTableName();
	
	protected final String SQL_TRUNCATE = "TRUNCATE TABLE " + getTableName();

	protected final String SQL_DELETE_ALL = "DELETE FROM " + getTableName();

	protected abstract String getTableName();
	
	public void truncate() {
		Connection conn = null;
		PreparedStatement stmt = null;
		
		try {
			// get the user-specified connection or get a connection from the ResourceManager
			conn = ResourceManager.getConnection();
		
			// prepare statement
			stmt = conn.prepareStatement( SQL_TRUNCATE );
		
			stmt.executeUpdate();
		} catch (Exception e) {
			System.err.println("Failed to truncate table due to Exception: " + e.getMessage());
	    } finally {
			ResourceManager.close(stmt);
			ResourceManager.close(conn);
	    }
			
	}
	
	public void deleteAll() {
		Connection conn = null;
		PreparedStatement stmt = null;
		
		try {
			// get the user-specified connection or get a connection from the ResourceManager
			conn = ResourceManager.getConnection();
		
			// prepare statement
			stmt = conn.prepareStatement( SQL_DELETE_ALL );
		
			stmt.executeUpdate();
		} catch (Exception e) {
			System.err.println("Failed to delete all due to Exception: " + e.getMessage());
	    } finally {
			ResourceManager.close(stmt);
			ResourceManager.close(conn);
	    }
			
	}
	
	public int getRowCount() {
		Connection conn = null;
		PreparedStatement stmt = null;
		ResultSet rs = null;
		
		try {
			// get the user-specified connection or get a connection from the ResourceManager
			conn = ResourceManager.getConnection();
		
			// prepare statement
			stmt = conn.prepareStatement( SQL_COUNT );
		
			rs = stmt.executeQuery();
			if (rs.next()) {
				return rs.getInt(1);
			} else {
				return -1;
			}
		} catch (Exception e) {
			System.err.println("Failed to read table row count due to Exception: " + e.getMessage());
			return -1;
	    } finally {
			ResourceManager.close(stmt);
			ResourceManager.close(conn);
	    }
			
	}
	
    public byte[] getBlobColumn(ResultSet rs, int columnIndex)
            throws SQLException
    {
        try {
            Blob blob = rs.getBlob( columnIndex );
            if (blob == null) {
                return null;
            }

            InputStream is = blob.getBinaryStream();
            ByteArrayOutputStream bos = new ByteArrayOutputStream();

            if (is == null) {
                return null;
            }
            else {
                byte buffer[] = new byte[ 64 ];
                int c = is.read( buffer );
                while (c>0) {
                    bos.write( buffer, 0, c );
                    c = is.read( buffer );
                }
                return bos.toByteArray();
            }
        }
        catch (IOException e) {
            throw new SQLException( "Failed to read BLOB column due to IOException: " + e.getMessage() );
        }
    }

    public void setBlobColumn(PreparedStatement stmt, int parameterIndex, byte[] value)
            throws SQLException
    {
        if (value == null) {
            stmt.setNull( parameterIndex, Types.BLOB );
        }
        else {
            stmt.setBinaryStream( parameterIndex, new ByteArrayInputStream(value), value.length );
        }
    }

    public String getClobColumn(ResultSet rs, int columnIndex)
        throws SQLException
    {
        try {
            Clob clob = rs.getClob( columnIndex );
            if (clob == null) {
                return null;
            }

            StringBuffer ret = new StringBuffer();
            InputStream is = clob.getAsciiStream();

            if (is == null) {
                return null;
            }
            else {
                byte buffer[] = new byte[ 64 ];
                int c = is.read( buffer );
                while (c>0) {
                    ret.append( new String(buffer, 0, c) );
                    c = is.read( buffer );
                }
                return ret.toString();
            }
        }
        catch (IOException e) {
            throw new SQLException( "Failed to read CLOB column due to IOException: " + e.getMessage() );
        }
    }

    public void setClobColumn(PreparedStatement stmt, int parameterIndex, String value)
        throws SQLException
    {
        if (value == null) {
            stmt.setNull( parameterIndex, Types.CLOB );
        }
        else {
            stmt.setAsciiStream( parameterIndex, new ByteArrayInputStream(value.getBytes()), value.length() );
        }
    }
}