/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.data.timeseries.api;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.fao.fi.fishstat.data.reference.api.Concept;
import org.fao.fi.fishstat.data.reference.api.ReferenceObject;

public class Selection
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Map<Concept, Set<ReferenceObject>> selection = new LinkedHashMap<Concept, Set<ReferenceObject>>();

    protected Selection() {
    }

    public static Selection instance() {
        return new Selection();
    }

    public Set<ReferenceObject> get(Concept concept) {
        return this.selection.get(concept);
    }

    public void set(Concept concept, Set<ReferenceObject> objects) {
        this.selection.put(concept, objects);
    }

    public void add(Concept concept, ReferenceObject object) {
        if (this.selection.get(concept) == null) {
            this.selection.put(concept, new HashSet());
        }
        this.selection.get(concept).add(object);
    }

    public void addAll(Concept concept, Collection<ReferenceObject> objects) {
        if (this.selection.get(concept) == null) {
            this.selection.put(concept, new HashSet());
        }
        this.selection.get(concept).addAll(objects);
    }

    public void remove(Concept concept, ReferenceObject object) {
        Set<ReferenceObject> objects = this.selection.get(concept);
        if (objects != null) {
            objects.remove(object);
        }
    }

    public Set<Concept> dimensions() {
        return this.selection.keySet();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        for (Concept concept : this.selection.keySet()) {
            buffer.append(concept.getAcronym()).append('\n');
            for (ReferenceObject object : this.selection.get(concept)) {
                buffer.append('[').append(object.getId()).append(']');
            }
            buffer.append('\n');
        }
        return buffer.toString();
    }
}

