/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.data.timeseries.api.impl;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections15.map.LinkedMap;
import org.fao.fi.fishstat.data.common.Commons;
import org.fao.fi.fishstat.data.common.api.Identifier;
import org.fao.fi.fishstat.data.common.api.JdbcResourceManager;
import org.fao.fi.fishstat.data.common.api.MultilingualString;
import org.fao.fi.fishstat.data.common.api.Version;
import org.fao.fi.fishstat.data.common.api.impl.IdentifierHelper;
import org.fao.fi.fishstat.data.common.api.impl.VersionHelper;
import org.fao.fi.fishstat.data.reference.api.Concept;
import org.fao.fi.fishstat.data.timeseries.api.Attachment;
import org.fao.fi.fishstat.data.timeseries.api.DataSource;
import org.fao.fi.fishstat.data.timeseries.api.Dataset;
import org.fao.fi.fishstat.data.timeseries.api.Dimension;
import org.fao.fi.fishstat.data.timeseries.api.DimensionNote;
import org.fao.fi.fishstat.data.timeseries.api.Timeseries;
import org.fao.fi.fishstat.data.timeseries.api.exceptions.TimeseriesServiceException;
import org.fao.fi.fishstat.data.timeseries.api.impl.DatasetFactory;
import org.fao.fi.fishstat.data.timeseries.api.impl.DimensionImpl;
import org.fao.fi.fishstat.data.timeseries.api.impl.DimensionNoteImpl;
import org.fao.fi.fishstat.data.timeseries.api.impl.TimeseriesFactory;
import org.fao.fi.fishstat.data.timeseries.api.impl.TimeseriesServiceHelper;

public class DatasetImpl
implements Dataset,
Serializable {
    private static final long serialVersionUID = 6973317287446296108L;
    private Object datasetDto;
    private LinkedMap<String, Dimension> dimensions;
    private List<Concept> concepts;
    private Identifier identifier;
    private List<DimensionNote> notes = new ArrayList<DimensionNote>();

    public DatasetImpl(Object datasetDto) throws TimeseriesServiceException {
        try {
            if (datasetDto == null) {
                throw new TimeseriesServiceException("Expecting not null dataset DTO");
            }
            this.datasetDto = datasetDto;
            this.identifier = IdentifierHelper.instance((String)Commons.getDTOIdentifier((Object)datasetDto));
        }
        catch (Exception e) {
            throw new TimeseriesServiceException("Unable to instantiate the dataset", e);
        }
    }

    private LinkedMap<String, Dimension> dimensions() throws Exception {
        List tsm_dimensions;
        if (this.dimensions == null && (tsm_dimensions = TimeseriesServiceHelper.getTsmDimensionDao().findByAttribute("DATASET_ID", String.class, (Object)this.getId().stringValue())) != null) {
            this.dimensions = new LinkedMap();
            int index = 0;
            for (Object dimension_dto : tsm_dimensions) {
                this.dimensions.put((Object)((String)Commons.getDTOAttributeByAcronym(dimension_dto, (String)"ACRONYM")), (Object)new DimensionImpl(dimension_dto, index));
                ++index;
            }
        }
        return this.dimensions;
    }

    @Override
    public Identifier getId() {
        return this.identifier;
    }

    @Override
    public String getAcronym() throws TimeseriesServiceException {
        try {
            return (String)Commons.getDTOAttributeByAcronym((Object)this.datasetDto, (String)"ACRONYM");
        }
        catch (Exception e) {
            throw new TimeseriesServiceException("Unable to get the acronym", e);
        }
    }

    @Override
    public MultilingualString getName() throws TimeseriesServiceException {
        try {
            return Commons.getMultilingualDTOAttribute((Object)this.datasetDto, (String)"NAME");
        }
        catch (Exception e) {
            throw new TimeseriesServiceException("Unable to get the name", e);
        }
    }

    @Override
    public void setName(MultilingualString name) throws TimeseriesServiceException {
        try {
            Commons.setMultilingualDTOAttribute((Object)this.datasetDto, (String)"NAME", (MultilingualString)name);
            this.update();
        }
        catch (Exception e) {
            throw new TimeseriesServiceException("Unable to set the name", e);
        }
    }

    @Override
    public MultilingualString getDescription() throws TimeseriesServiceException {
        try {
            return Commons.getMultilingualDTOAttribute((Object)this.datasetDto, (String)"DESCRIPTION");
        }
        catch (Exception e) {
            throw new TimeseriesServiceException("Unable to get the description", e);
        }
    }

    @Override
    public void setDescription(MultilingualString description) throws TimeseriesServiceException {
        try {
            Commons.setMultilingualDTOAttribute((Object)this.datasetDto, (String)"DESCRIPTION", (MultilingualString)description);
            this.update();
        }
        catch (Exception e) {
            throw new TimeseriesServiceException("Unable to set the description", e);
        }
    }

    @Override
    public List<Dimension> getDimensions() throws TimeseriesServiceException {
        try {
            return new ArrayList<Dimension>(this.dimensions().values());
        }
        catch (Exception e) {
            throw new TimeseriesServiceException("Unable to get dataset dimensions: " + e.getMessage(), e);
        }
    }

    @Override
    public List<Dimension> getDimensionsNoUnit() throws TimeseriesServiceException {
        try {
            this.dimensions();
        }
        catch (Exception e) {
            throw new TimeseriesServiceException("Unable to get dataset dimensions: " + e.getMessage(), e);
        }
        ArrayList<Dimension> dimensionsNoUunit = new ArrayList<Dimension>();
        for (Dimension dimension : this.dimensions.values()) {
            if (dimension.getAcronym().equals("MEASURE")) continue;
            dimensionsNoUunit.add(dimension);
        }
        return dimensionsNoUunit;
    }

    @Override
    public List<Attachment> getAttachments() throws TimeseriesServiceException {
        try {
            ArrayList<Attachment> listOfEntries = new ArrayList<Attachment>(DatasetFactory.instance().getAttachments(this));
            Comparator<Attachment> attachmentComparator = new Comparator<Attachment>(){

                @Override
                public int compare(Attachment a1, Attachment a2) {
                    return Integer.compare(a1.getId().intValue(), a2.getId().intValue());
                }
            };
            Collections.sort(listOfEntries, attachmentComparator);
            return listOfEntries;
        }
        catch (Exception e) {
            throw new TimeseriesServiceException("Unable to get dataset extension: " + e.getMessage(), e);
        }
    }

    @Override
    public Attachment getAttachment(String acronym) throws TimeseriesServiceException {
        if (acronym == null) {
            throw new IllegalArgumentException("Dataset extension acronym can not be null");
        }
        try {
            return DatasetFactory.instance().getAttachment(this, acronym);
        }
        catch (Exception e) {
            throw new TimeseriesServiceException("Unable to get timeseries: " + e.getMessage(), e);
        }
    }

    @Override
    public Collection<Timeseries> getTimeseries() throws TimeseriesServiceException {
        try {
            return TimeseriesFactory.instance().getTimeseries(this);
        }
        catch (Exception e) {
            throw new TimeseriesServiceException("Unable to get timeseries: " + e.getMessage(), e);
        }
    }

    @Override
    public Timeseries getTimeseries(String acronym) throws TimeseriesServiceException {
        if (acronym == null) {
            throw new IllegalArgumentException("Timeseries acronym can not be null");
        }
        try {
            return TimeseriesFactory.instance().getTimeseries(this, acronym);
        }
        catch (Exception e) {
            throw new TimeseriesServiceException("Unable to get timeseries: " + e.getMessage(), e);
        }
    }

    private void update() throws TimeseriesServiceException {
        try {
            TimeseriesServiceHelper.getTsmDatasetDao().update(Commons.getDTOPk((Object)this.datasetDto), this.datasetDto);
        }
        catch (Exception e) {
            throw new TimeseriesServiceException("Unable to update dataset: " + e.getMessage(), e);
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[").append(this.getId()).append("]").append("[").append(this.getAcronym()).append("]").append("[").append(this.getName()).append("]").append("[").append(this.getDescription()).append("]").append("[").append(this.getVersion()).append("]");
        return buffer.toString();
    }

    @Override
    public DataSource getDataSource() throws TimeseriesServiceException {
        try {
            return new DataSource((String)Commons.getDTOAttributeByAcronym((Object)this.datasetDto, (String)"DATA_SOURCE"));
        }
        catch (Exception e) {
            throw new TimeseriesServiceException("Unable to get data source: " + e.getMessage(), e);
        }
    }

    @Override
    public void setDataSource(DataSource datasource) throws TimeseriesServiceException {
        try {
            Commons.setDTOAttribute((Object)this.datasetDto, (String)"DATA_SOURCE", (Object)datasource.getName(), String.class);
            this.update();
        }
        catch (Exception e) {
            throw new TimeseriesServiceException("Unable to set data source: " + e.getMessage(), e);
        }
    }

    @Override
    public boolean isCompatible(Timeseries timeseries) throws TimeseriesServiceException {
        try {
            return TimeseriesServiceHelper.compatible(this, timeseries);
        }
        catch (Exception e) {
            throw new TimeseriesServiceException("Unable to check for compatibility: " + e.getMessage(), e);
        }
    }

    @Override
    public String getUrl() throws TimeseriesServiceException {
        try {
            return (String)Commons.getDTOAttributeByAcronym((Object)this.datasetDto, (String)"URL");
        }
        catch (Exception e) {
            throw new TimeseriesServiceException("Unable to get URL: " + e.getMessage(), e);
        }
    }

    @Override
    public void setUrl(String url) throws TimeseriesServiceException {
        try {
            Commons.setDTOAttribute((Object)this.datasetDto, (String)"URL", (Object)url, String.class);
            this.update();
        }
        catch (Exception e) {
            throw new TimeseriesServiceException("Unable to set URL: " + e.getMessage(), e);
        }
    }

    @Override
    public List<Concept> getConcepts() throws TimeseriesServiceException {
        try {
            return Collections.unmodifiableList(this.concepts());
        }
        catch (Exception e) {
            throw new TimeseriesServiceException("Unable to get dataset concepts: " + e.getMessage(), e);
        }
    }

    private List<Concept> concepts() throws Exception {
        if (this.concepts == null) {
            this.concepts = new ArrayList<Concept>();
            for (Dimension dimension : this.dimensions().values()) {
                this.concepts.add(dimension.getConcept());
            }
        }
        return this.concepts;
    }

    @Override
    public Dimension getDimension(String acronym) throws TimeseriesServiceException {
        try {
            return (Dimension)this.dimensions().get((Object)acronym);
        }
        catch (Exception e) {
            throw new TimeseriesServiceException("Unable to get the dataset dimension: " + e.getMessage(), e);
        }
    }

    @Override
    public Dimension getObservedMeasureDimension() throws TimeseriesServiceException {
        try {
            for (Dimension dimension : this.dimensions().values()) {
                if (!dimension.isObservedMeasure()) continue;
                return dimension;
            }
            return null;
        }
        catch (Exception e) {
            throw new TimeseriesServiceException("Unable to get the dataset observed measure dimension: " + e.getMessage(), e);
        }
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.identifier == null ? 0 : this.identifier.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Dataset)) {
            return false;
        }
        Dataset other = (Dataset)obj;
        return !(this.identifier == null ? other.getId() != null : !this.identifier.equals(other.getId()));
    }

    @Override
    public int getDimensionIndex(String acronym) throws TimeseriesServiceException {
        try {
            if (acronym == null) {
                throw new IllegalArgumentException("The dimension acronym can not be null");
            }
            return this.dimensions().indexOf((Object)acronym);
        }
        catch (Exception e) {
            throw new TimeseriesServiceException("Unable to get dimension index", e);
        }
    }

    @Override
    public Dimension getDimension(int index) throws TimeseriesServiceException {
        try {
            return (Dimension)this.dimensions().getValue(index);
        }
        catch (Exception e) {
            throw new TimeseriesServiceException("Unable to get the dimension", e);
        }
    }

    public Version getVersion() throws TimeseriesServiceException {
        try {
            return VersionHelper.getVersion((Object)this.datasetDto);
        }
        catch (Exception e) {
            throw new TimeseriesServiceException("Unable to get version", e);
        }
    }

    public void setVersion(Version version) throws TimeseriesServiceException {
        try {
            VersionHelper.setVersion((Object)this.datasetDto, (Version)version);
            this.update();
        }
        catch (Exception e) {
            throw new TimeseriesServiceException("Unable to set version", e);
        }
    }

    @Override
    public MultilingualString getCitation() throws TimeseriesServiceException {
        try {
            return Commons.getMultilingualDTOAttribute((Object)this.datasetDto, (String)"CITATION");
        }
        catch (Exception exception) {
            String res;
            block5: {
                try {
                    res = (String)Commons.getDTOAttributeByAcronym((Object)this.datasetDto, (String)"CITATION");
                    if (res != null && !res.isEmpty()) break block5;
                    return null;
                }
                catch (Exception exception2) {
                    return null;
                }
            }
            MultilingualString mlStr = new MultilingualString();
            mlStr.setValue("en", res);
            mlStr.setValue("fr", res);
            mlStr.setValue("es", res);
            return mlStr;
        }
    }

    @Override
    public void setCitation(MultilingualString citation) throws TimeseriesServiceException {
        try {
            Commons.setDTOAttribute((Object)this.datasetDto, (String)"CITATION", (Object)citation, String.class);
            this.update();
        }
        catch (Exception e) {
            throw new TimeseriesServiceException("Unable to set Citation: " + e.getMessage(), e);
        }
    }

    private List<DimensionNote> notes(String lang) throws TimeseriesServiceException {
        try {
            if (this.notes.isEmpty()) {
                for (Dimension dimension : this.dimensions().values()) {
                    if (!dimension.hasNote()) continue;
                    DimensionNoteImpl note = new DimensionNoteImpl(this, dimension);
                    note.setNoteString(this.getNotesText(note.getAcronym(), lang));
                    this.notes.add(note);
                }
            }
            return this.notes;
        }
        catch (Exception e) {
            throw new TimeseriesServiceException("Unable to get DimensionNotes", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<Integer, String> getNotesText(String notesTable, String lang) {
        System.out.println("reading from database ....");
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        String sqlQuery1 = "SELECT ID, NAME_" + lang.toUpperCase() + " FROM " + "FISHSTAT" + "." + notesTable;
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try {
                Connection dbConn = JdbcResourceManager.getConnection();
                try {
                    block21: {
                        PreparedStatement ps1 = dbConn.prepareStatement(sqlQuery1);
                        try {
                            try (ResultSet rs1 = ps1.executeQuery();){
                                while (rs1.next()) {
                                    result.put(rs1.getInt(1), rs1.getString(2));
                                }
                            }
                            if (ps1 == null) break block21;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            if (ps1 == null) throw throwable;
                            ps1.close();
                            throw throwable;
                        }
                        ps1.close();
                    }
                    if (dbConn == null) return result;
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    if (dbConn == null) throw throwable;
                    dbConn.close();
                    throw throwable;
                }
                dbConn.close();
                return result;
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                    throw throwable;
                }
                if (throwable == throwable4) throw throwable;
                throwable.addSuppressed(throwable4);
                throw throwable;
            }
        }
        catch (Exception e) {
            throw new TimeseriesServiceException("Unable to read DimensionNotes", e);
        }
    }

    @Override
    public List<DimensionNote> getNotes(String lang) throws TimeseriesServiceException {
        return this.notes(lang);
    }

    @Override
    public DimensionNote getNotes(Concept concept, String lang) throws TimeseriesServiceException {
        if (concept == null) {
            throw new IllegalArgumentException("The concept can not be null");
        }
        for (DimensionNote note : this.notes(lang)) {
            if (!note.getDimension().getConcept().equals(concept)) continue;
            return note;
        }
        return null;
    }
}

