/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.data.timeseries.api.impl;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections15.map.ListOrderedMap;
import org.fao.fi.fishstat.data.common.Commons;
import org.fao.fi.fishstat.data.common.api.JdbcResourceManager;
import org.fao.fi.fishstat.data.common.api.daosupport.DAOAdapter;
import org.fao.fi.fishstat.data.common.api.daosupport.GenericDAO;
import org.fao.fi.fishstat.data.common.api.exceptions.ReflectionException;
import org.fao.fi.fishstat.data.common.classloader.ClassLoaderFactory;
import org.fao.fi.fishstat.data.reference.api.Attribute;
import org.fao.fi.fishstat.data.reference.api.Concept;
import org.fao.fi.fishstat.data.reference.api.MultiReferenceObject;
import org.fao.fi.fishstat.data.reference.api.ReferenceObject;
import org.fao.fi.fishstat.data.reference.api.ReferenceServiceFactory;
import org.fao.fi.fishstat.data.timeseries.api.Dataset;
import org.fao.fi.fishstat.data.timeseries.api.Dimension;
import org.fao.fi.fishstat.data.timeseries.api.Measure;
import org.fao.fi.fishstat.data.timeseries.api.MeasureFactory;
import org.fao.fi.fishstat.data.timeseries.api.MeasureStatus;
import org.fao.fi.fishstat.data.timeseries.api.ObservationPeriod;
import org.fao.fi.fishstat.data.timeseries.api.ObservationSeries;
import org.fao.fi.fishstat.data.timeseries.api.TimeResolution;
import org.fao.fi.fishstat.data.timeseries.api.Timeseries;
import org.fao.fi.fishstat.data.timeseries.api.calculated.CalculatedMeasureDefinition;
import org.fao.fi.fishstat.data.timeseries.api.calculated.functions.Descriptive;
import org.fao.fi.fishstat.data.timeseries.api.calculated.functions.Function;
import org.fao.fi.fishstat.data.timeseries.api.calculated.functions.PeriodsFunction;
import org.fao.fi.fishstat.data.timeseries.api.calculated.functions.Regression;
import org.fao.fi.fishstat.data.timeseries.api.exceptions.TimeseriesServiceException;
import org.fao.fi.fishstat.data.timeseries.api.impl.MeasureImpl;

public class TimeseriesServiceHelper {
    private static final String DATASET_CLASSNAME_PREFIX = "Tsd";
    private static final String TIMESERIES_CLASSNAME_PREFIX = "Tsd";
    private static final String SQL_COUNT_PREFIX = "SELECT COUNT(*) FROM FISHSTAT.";

    private static Class<?> getTsmDatasetDAOFactoryClass() throws ClassNotFoundException {
        StringBuffer buffer = new StringBuffer("org.fao.fi.fishstat.data.generated.factory.");
        buffer.append("TsmDatasetDaoFactory");
        return ClassLoaderFactory.getClassLoader().loadClass(buffer.toString());
    }

    public static Class<?> getTsmDatasetDTOClass() throws ClassNotFoundException {
        StringBuffer buffer = new StringBuffer("org.fao.fi.fishstat.data.generated.dto.");
        buffer.append("TsmDataset");
        return ClassLoaderFactory.getClassLoader().loadClass(buffer.toString());
    }

    private static Class<?> getTsmDatasetAttachmentDAOFactoryClass() throws ClassNotFoundException {
        StringBuffer buffer = new StringBuffer("org.fao.fi.fishstat.data.generated.factory.");
        buffer.append("TsmDatasetAttachmentDaoFactory");
        return ClassLoaderFactory.getClassLoader().loadClass(buffer.toString());
    }

    public static Class<?> getTsmAttachmentDTOClass() throws ClassNotFoundException {
        StringBuffer buffer = new StringBuffer("org.fao.fi.fishstat.data.generated.dto.");
        buffer.append("TsmDatasetAttachment");
        return ClassLoaderFactory.getClassLoader().loadClass(buffer.toString());
    }

    public static GenericDAO getTsmDatasetDao() throws ReflectionException {
        try {
            Class<?> factory_class = TimeseriesServiceHelper.getTsmDatasetDAOFactoryClass();
            Method create = factory_class.getMethod("create", null);
            Object dao = create.invoke(null, null);
            return new DAOAdapter(dao);
        }
        catch (Exception e) {
            throw new ReflectionException((Throwable)e);
        }
    }

    public static GenericDAO getTsmDatasetAttachmentDao() throws ReflectionException {
        try {
            Class<?> factory_class = TimeseriesServiceHelper.getTsmDatasetAttachmentDAOFactoryClass();
            Method create = factory_class.getMethod("create", null);
            Object dao = create.invoke(null, null);
            return new DAOAdapter(dao);
        }
        catch (Exception e) {
            throw new ReflectionException((Throwable)e);
        }
    }

    private static Class<?> getTsmTimeseriesDAOFactoryClass() throws ClassNotFoundException {
        StringBuffer buffer = new StringBuffer("org.fao.fi.fishstat.data.generated.factory.");
        buffer.append("TsmTimeseriesDaoFactory");
        return ClassLoaderFactory.getClassLoader().loadClass(buffer.toString());
    }

    public static Class<?> getTsmTimeseriesDTOClass() throws ClassNotFoundException {
        StringBuffer buffer = new StringBuffer("org.fao.fi.fishstat.data.generated.dto.");
        buffer.append("TsmTimeseries");
        return ClassLoaderFactory.getClassLoader().loadClass(buffer.toString());
    }

    public static GenericDAO getTsmTimeseriesDao() throws ReflectionException {
        try {
            Class<?> factory_class = TimeseriesServiceHelper.getTsmTimeseriesDAOFactoryClass();
            Method create = factory_class.getMethod("create", null);
            Object dao = create.invoke(null, null);
            return new DAOAdapter(dao);
        }
        catch (Exception e) {
            throw new ReflectionException((Throwable)e);
        }
    }

    private static Class<?> getTsmAttributeDAOFactoryClass() throws ClassNotFoundException {
        StringBuffer buffer = new StringBuffer("org.fao.fi.fishstat.data.generated.factory.");
        buffer.append("TsmAttributeDaoFactory");
        return ClassLoaderFactory.getClassLoader().loadClass(buffer.toString());
    }

    public static Class<?> getTsmAttributeDTOClass() throws ClassNotFoundException {
        StringBuffer buffer = new StringBuffer("org.fao.fi.fishstat.data.generated.dto.");
        buffer.append("TsmAttribute");
        return ClassLoaderFactory.getClassLoader().loadClass(buffer.toString());
    }

    public static GenericDAO getTsmAttributeDao() throws ReflectionException {
        try {
            Class<?> factory_class = TimeseriesServiceHelper.getTsmAttributeDAOFactoryClass();
            Method create = factory_class.getMethod("create", null);
            Object dao = create.invoke(null, null);
            return new DAOAdapter(dao);
        }
        catch (Exception e) {
            throw new ReflectionException((Throwable)e);
        }
    }

    private static Class<?> getTsmDimensionDAOFactoryClass() throws ClassNotFoundException {
        StringBuffer buffer = new StringBuffer("org.fao.fi.fishstat.data.generated.factory.");
        buffer.append("TsmDimensionDaoFactory");
        return ClassLoaderFactory.getClassLoader().loadClass(buffer.toString());
    }

    public static Class<?> getTsmDimensionDTOClass() throws ClassNotFoundException {
        StringBuffer buffer = new StringBuffer("org.fao.fi.fishstat.data.generated.dto.");
        buffer.append("TsmDimension");
        return ClassLoaderFactory.getClassLoader().loadClass(buffer.toString());
    }

    public static GenericDAO getTsmDimensionDao() throws ReflectionException {
        try {
            Class<?> factory_class = TimeseriesServiceHelper.getTsmDimensionDAOFactoryClass();
            Method create = factory_class.getMethod("create", null);
            Object dao = create.invoke(null, null);
            return new DAOAdapter(dao);
        }
        catch (Exception e) {
            throw new ReflectionException((Throwable)e);
        }
    }

    private static Class<?> getTimeseriesDAOFactoryClass(String datasetAcronym, String timeseriesAcronym) throws ClassNotFoundException {
        StringBuffer buffer = new StringBuffer("org.fao.fi.fishstat.data.generated.factory.");
        buffer.append("Tsd").append(Commons.getJavaName((String)datasetAcronym)).append(Commons.getJavaName((String)timeseriesAcronym)).append("DaoFactory");
        return ClassLoaderFactory.getClassLoader().loadClass(buffer.toString());
    }

    public static GenericDAO getTimeseriesDAO(String datasetAcronym, String timeseriesAcronym) throws ReflectionException {
        try {
            Class<?> factory_class = TimeseriesServiceHelper.getTimeseriesDAOFactoryClass(datasetAcronym, timeseriesAcronym);
            Method create = factory_class.getMethod("create", null);
            Object dao = create.invoke(null, null);
            return new DAOAdapter(dao);
        }
        catch (Exception e) {
            throw new ReflectionException((Throwable)e);
        }
    }

    public static Class<?> getTimeseriesDTOClass(String datasetAcronym, String timeseriesAcronym) throws ClassNotFoundException {
        StringBuffer acronym = new StringBuffer().append(datasetAcronym).append("_").append(timeseriesAcronym);
        StringBuffer name = new StringBuffer("org.fao.fi.fishstat.data.generated.dto.").append("Tsd").append(Commons.getJavaName((String)acronym.toString()));
        return ClassLoaderFactory.getClassLoader().loadClass(name.toString());
    }

    public static Map<ObservationPeriod, Measure> cloneSeriesMeasures(Map<ObservationPeriod, Measure> measures) {
        if (measures == null) {
            return null;
        }
        LinkedHashMap<ObservationPeriod, Measure> cloned = new LinkedHashMap<ObservationPeriod, Measure>();
        for (Map.Entry<ObservationPeriod, Measure> entry : measures.entrySet()) {
            MeasureImpl cloned_measure = new MeasureImpl(entry.getValue());
            cloned.put(entry.getKey(), cloned_measure);
        }
        return cloned;
    }

    public static String calculatedMeasuresToString(Map<CalculatedMeasureDefinition, Measure> measures) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[");
        if (measures != null) {
            for (Map.Entry<CalculatedMeasureDefinition, Measure> measure : measures.entrySet()) {
                buffer.append("[").append(measure.getKey().getName()).append("=").append(measure.getValue()).append("]");
            }
        }
        buffer.append("]");
        return buffer.toString();
    }

    public static String seriesToString(ObservationSeries series) {
        StringBuffer buffer = new StringBuffer();
        try {
            buffer.append(TimeseriesServiceHelper.keysToString(series.getKeys()));
            buffer.append(TimeseriesServiceHelper.measuresToString(series.getMeasures()));
            buffer.append(TimeseriesServiceHelper.calculatedMeasuresToString(series.getCalculatedMeasures()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return buffer.toString();
    }

    public static String keysToString(MultiReferenceObject keys) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[");
        if (keys != null) {
            ReferenceObject[] referenceObjectArray = keys.elements();
            int n = referenceObjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                ReferenceObject object = referenceObjectArray[n2];
                buffer.append("[").append(object.getAttribute("NAME")).append("]");
                ++n2;
            }
        }
        buffer.append("]");
        return buffer.toString();
    }

    public static String measuresToString(Map<ObservationPeriod, Measure> measures) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[");
        if (measures != null) {
            for (Map.Entry<ObservationPeriod, Measure> measure : measures.entrySet()) {
                buffer.append("[").append(measure.getKey()).append("=").append(measure.getValue()).append("]");
            }
        }
        buffer.append("]");
        return buffer.toString();
    }

    public static List<ObservationPeriod> calculateObservationPeriods(ObservationPeriod start, ObservationPeriod end, TimeResolution resolution) {
        ArrayList<ObservationPeriod> periods = new ArrayList<ObservationPeriod>();
        int start_yr = Integer.parseInt(start.getYear());
        int end_yr = Integer.parseInt(end.getYear());
        if (TimeResolution.YEAR.equals(resolution)) {
            int i = start_yr;
            while (i <= end_yr) {
                periods.add(new ObservationPeriod(new StringBuffer(TimeResolution.YEAR.toString()).append(i).toString()));
                ++i;
            }
        } else if (TimeResolution.QUARTER.equals(resolution)) {
            int start_quarter = Integer.parseInt(start.getQuarter());
            int end_quarter = Integer.parseInt(end.getQuarter());
            int i = start_yr;
            while (i <= end_yr) {
                int j = start_quarter;
                while (!(i == end_yr ? j > end_quarter : j > 4)) {
                    periods.add(new ObservationPeriod(new StringBuffer(TimeResolution.YEAR.toString()).append(i).append(TimeResolution.MONTH.toString()).append(j).toString()));
                    ++j;
                }
                ++i;
            }
        } else if (TimeResolution.MONTH.equals(resolution)) {
            int start_month = Integer.parseInt(start.getMonth());
            int end_month = Integer.parseInt(end.getMonth());
            int i = start_yr;
            while (i <= end_yr) {
                int j = i == start_yr ? start_month : 1;
                while (!(i == end_yr ? j > end_month : j > 12)) {
                    periods.add(new ObservationPeriod(new StringBuffer(TimeResolution.YEAR.toString()).append(i).append(TimeResolution.MONTH.toString()).append(j).toString()));
                    ++j;
                }
                ++i;
            }
        } else {
            throw new UnsupportedOperationException("Time resolutuion not supported");
        }
        return periods;
    }

    public static boolean compatible(Timeseries timeseries, ObservationSeries series) throws Exception {
        List<Concept> series_concepts = TimeseriesServiceHelper.getConcepts(series);
        if (!timeseries.getDataset().getConcepts().containsAll(series_concepts) || !series_concepts.containsAll(timeseries.getDataset().getConcepts())) {
            return false;
        }
        return timeseries.getObservationPeriods().containsAll(series.getMeasures().keySet()) && series.getMeasures().keySet().containsAll(timeseries.getObservationPeriods());
    }

    public static boolean compatible(Dataset dataset, Timeseries timeseries) throws Exception {
        return timeseries.getDataset().getConcepts().containsAll(dataset.getConcepts()) && dataset.getConcepts().containsAll(timeseries.getDataset().getConcepts());
    }

    public static List<Concept> getConcepts(ObservationSeries series) throws Exception {
        return new ArrayList<Concept>(series.getKeys().asMap().keySet());
    }

    public static List<ObservationSeries> sort(List<ObservationSeries> observations, ObservationPeriod period) {
        Collections.sort(observations, new SeriesComparator(period));
        return observations;
    }

    public static List<ObservationSeries> sort(List<ObservationSeries> observations, CalculatedMeasureDefinition definition) {
        Collections.sort(observations, new SeriesComparator(definition));
        return observations;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int getRowCount(Timeseries timeseries) throws TimeseriesServiceException {
        try {
            Connection conn = null;
            Statement stmt = null;
            ResultSet rs = null;
            try {
                conn = JdbcResourceManager.getConnection();
                stmt = conn.prepareStatement("SELECT COUNT(*) FROM FISHSTAT.TSD_" + timeseries.getDataset().getAcronym() + "_" + timeseries.getAcronym());
                rs = stmt.executeQuery();
                if (!rs.next()) return -1;
                int n = rs.getInt(1);
                return n;
            }
            catch (Exception e) {
                System.err.println("Failed to read table row count due to Exception: " + e.getMessage());
                return -1;
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
        }
        catch (Exception e) {
            throw new TimeseriesServiceException("Failed to retrieve row-count: " + e.getMessage(), e);
        }
    }

    public static Collection<ReferenceObject> getAllReferencedObjects(Timeseries timeseries, Dimension dimension) throws TimeseriesServiceException {
        try {
            String ref_table = "REF_" + dimension.getConcept().getAcronym();
            Attribute ref_attribute = dimension.getAttribute();
            String tsd_table = "TSD_" + timeseries.getDataset().getAcronym() + "_" + timeseries.getAcronym();
            String sql = "select * from " + ref_table + " A inner join (select distinct(" + dimension.getConcept().getAcronym() + ") CODE from " + tsd_table + ") B on A." + ref_attribute.getAcronym() + " = B.CODE";
            return ReferenceServiceFactory.getService().getObjects(dimension.getConcept(), sql, null);
        }
        catch (Exception e) {
            throw new TimeseriesServiceException("Unable to get the local code list: " + e.getMessage(), e);
        }
    }

    public static double[] toArray(Collection<Double> values) {
        if (values == null) {
            return new double[0];
        }
        double[] result = new double[values.size()];
        int i = 0;
        Iterator<Double> iterator = values.iterator();
        while (iterator.hasNext()) {
            double value;
            result[i] = value = iterator.next().doubleValue();
            ++i;
        }
        return result;
    }

    public static double[][] toArray(Map<Double, Double> distribution) {
        if (distribution == null) {
            return new double[0][0];
        }
        double[][] data = new double[distribution.size()][2];
        int i = 0;
        for (Map.Entry<Double, Double> entry : distribution.entrySet()) {
            data[i][0] = entry.getKey();
            data[i][1] = entry.getValue();
            ++i;
        }
        return data;
    }

    public static ListOrderedMap<CalculatedMeasureDefinition, Measure> evaluateCalculatedMeasures(ObservationSeries series) throws TimeseriesServiceException {
        try {
            ListOrderedMap calculated_measures = new ListOrderedMap();
            for (CalculatedMeasureDefinition definition : series.getTimeseries().getCalculatedMeasureDefinitions()) {
                if (definition.getFunction() instanceof PeriodsFunction) {
                    TimeseriesServiceHelper.evaluateCalculationPeriods(series, (ListOrderedMap<CalculatedMeasureDefinition, Measure>)calculated_measures, definition);
                    continue;
                }
                if (!(definition.getFunction() instanceof Regression) && !(definition.getFunction() instanceof Descriptive)) continue;
                TimeseriesServiceHelper.evaluateCalculationDescriptive(series, (ListOrderedMap<CalculatedMeasureDefinition, Measure>)calculated_measures, definition);
            }
            return calculated_measures;
        }
        catch (Exception e) {
            throw new TimeseriesServiceException("Unable to get calculated measures", e);
        }
    }

    private static void evaluateCalculationPeriods(ObservationSeries series, ListOrderedMap<CalculatedMeasureDefinition, Measure> calculated_measures, CalculatedMeasureDefinition definition) throws Exception {
        List<ObservationPeriod> periods = definition.getPeriods();
        if (periods == null || periods.isEmpty()) {
            periods = series.getTimeseries().getObservationPeriods();
        }
        LinkedHashMap<ObservationPeriod, Double> calcSeries = new LinkedHashMap<ObservationPeriod, Double>();
        Map<ObservationPeriod, Measure> measures = series.getMeasures();
        for (ObservationPeriod period : periods) {
            Measure measure = measures.get(period);
            MeasureStatus status = measure.getStatus();
            if (definition.getSkipStatus() != null && definition.getSkipStatus().contains(status)) continue;
            calcSeries.put(period, measure.getValue());
        }
        Measure calculated_measure = MeasureFactory.create();
        calculated_measure.setStatus(MeasureStatus.STATUS_OFFICIAL);
        calculated_measure.setValue(((PeriodsFunction)definition.getFunction()).evaluate(calcSeries, definition.getParameters()));
        calculated_measures.put((Object)definition, (Object)calculated_measure);
    }

    private static void evaluateCalculationDescriptive(ObservationSeries series, ListOrderedMap<CalculatedMeasureDefinition, Measure> calculated_measures, CalculatedMeasureDefinition definition) throws Exception {
        List<ObservationPeriod> periods = definition.getPeriods();
        if (periods == null || periods.isEmpty()) {
            periods = series.getTimeseries().getObservationPeriods();
        }
        LinkedHashMap<Double, Double> distribution = new LinkedHashMap<Double, Double>();
        Map<ObservationPeriod, Measure> measures = series.getMeasures();
        for (ObservationPeriod period : periods) {
            double y;
            Measure measure = measures.get(period);
            MeasureStatus status = measure.getStatus();
            if (definition.getSkipStatus() != null && definition.getSkipStatus().contains(status) || !((y = measure.getValue()) >= definition.getMinValue()) || !(y <= definition.getMaxValue())) continue;
            distribution.put(Double.valueOf(period.getOrdinalNumber()), y);
        }
        Measure calculated_measure = MeasureFactory.create();
        calculated_measure.setStatus(MeasureStatus.STATUS_OFFICIAL);
        Function f = definition.getFunction();
        if (f instanceof Regression) {
            Regression rf = (Regression)f;
            calculated_measure.setValue(rf.evaluate(distribution, definition.getParameters()));
        } else if (f instanceof Descriptive) {
            Descriptive df = (Descriptive)f;
            calculated_measure.setValue(df.evaluate(new ArrayList<Double>(distribution.values()), definition.getParameters()));
        }
        calculated_measures.put((Object)definition, (Object)calculated_measure);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int removeAllAttachments() throws TimeseriesServiceException {
        int res = -1;
        try {
            Connection conn = null;
            Statement stmt = null;
            try {
                try {
                    conn = JdbcResourceManager.getConnection();
                    stmt = conn.prepareStatement("DELETE FROM FISHSTAT.TSM_DATASET_ATTACHMENT");
                    res = stmt.executeUpdate();
                    return res;
                }
                catch (Exception e) {
                    System.err.println("Failed to delete attachments table. Exception: " + e.getMessage());
                    int n = res;
                    if (stmt != null) {
                        stmt.close();
                    }
                    if (conn == null) return n;
                    conn.close();
                    return n;
                }
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
        }
        catch (Exception e) {
            throw new TimeseriesServiceException("Failed to delete attachments table. Exception:: " + e.getMessage(), e);
        }
    }

    public static class SeriesComparator
    implements Comparator<ObservationSeries>,
    Serializable {
        private static final long serialVersionUID = 7152176617571048076L;
        private ObservationPeriod period;
        private CalculatedMeasureDefinition definition;

        public SeriesComparator(ObservationPeriod period) {
            this.period = period;
        }

        public SeriesComparator(CalculatedMeasureDefinition definition) {
            this.definition = definition;
        }

        @Override
        public int compare(ObservationSeries o1, ObservationSeries o2) {
            Measure m2;
            Measure m1;
            if (this.period != null) {
                m1 = o1.getMeasure(this.period);
                m2 = o2.getMeasure(this.period);
            } else {
                m1 = o1.getCalculatedMeasure(this.definition);
                m2 = o2.getCalculatedMeasure(this.definition);
            }
            if (m1 == null) {
                if (m2 == null) {
                    return 0;
                }
                return 1;
            }
            if (m2 == null) {
                return -1;
            }
            if (m1.getValue() < m2.getValue()) {
                return 1;
            }
            if (m1.getValue() > m2.getValue()) {
                return -1;
            }
            return 0;
        }
    }
}

