/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.core.session;

import java.util.LinkedList;
import org.fao.fi.fishstat.core.CoreUtils;
import org.fao.fi.fishstat.core.FSDimensionColumnDescriptor;
import org.fao.fi.fishstat.core.model.aggregation.AggregationWrapper;
import org.fao.fi.fishstat.core.model.aggregation.DimensionAggregation;
import org.fao.fi.fishstat.core.session.FSSessionMetadata;
import org.fao.fi.fishstat.core.session.Session;
import org.fao.fi.fishstat.data.reference.api.Concept;
import org.fao.fi.fishstat.gui.core.properties.ConceptProperties;
import org.fao.fi.fishstat.gui.core.properties.DatasetProperties;
import org.fao.fi.fishstat.gui.core.properties.DimensionProperties;
import org.fao.fi.fishstat.gui.core.session.GuiSession;

public class FSGuiSessionMetadata
extends FSSessionMetadata {
    public FSGuiSessionMetadata(GuiSession session) {
        super((Session)session);
        this.refreshMetadata();
    }

    private void refreshMetadata() {
        this.dimColumnDescriptor = new LinkedList();
        DatasetProperties dsProps = ((GuiSession)this.session).getDatasetProperties();
        for (DimensionProperties dimProps : dsProps.getDimensionsProperties()) {
            for (ConceptProperties conProps : dimProps.getDescriptors()) {
                FSDimensionColumnDescriptor descriptor = new FSDimensionColumnDescriptor(dimProps.getDimension());
                descriptor.setDimensionIdx(dimProps.getDimensionIdx());
                if (this.session.hasAggregationRequest()) {
                    AggregationWrapper aggRequest = this.session.getAggregationRequest();
                    if (!aggRequest.isDisaggregated()) {
                        DimensionAggregation dimAggRequest = aggRequest.getDimensionAggregation(dimProps.getDimensionIdx());
                        switch (dimAggRequest.getType()) {
                            case 1: {
                                Concept aggregator = dimAggRequest.getBasicAggregator();
                                descriptor.setConcept(aggregator);
                                descriptor.setRelationship(CoreUtils.getRelationship((Concept)descriptor.getConcept(), (Concept)descriptor.getDimensionConcept()));
                                descriptor.setAttribute(conProps.getConcept().equals(aggregator) ? conProps.getAttribute() : (conProps.hasParentAttribute(aggregator.getAcronym()) ? aggregator.getAttribute(conProps.getParentAttribute(aggregator.getAcronym())) : dimAggRequest.getBasicAggregator().getNameAttribute()));
                                descriptor.setAlternate(conProps.getConcept().equals(dimAggRequest.getBasicAggregator()) ? conProps.getAlternate() : dimAggRequest.getBasicAggregator().getNameAttribute());
                                break;
                            }
                            default: {
                                descriptor.setConcept(conProps.getConcept());
                                descriptor.setAttribute(conProps.getAttribute());
                                descriptor.setAlternate(conProps.getAlternate());
                                descriptor.setRelationship(conProps.getRelationship());
                                break;
                            }
                        }
                    } else {
                        descriptor.setConcept(conProps.getConcept());
                        descriptor.setAttribute(conProps.getAttribute());
                        descriptor.setAlternate(conProps.getAlternate());
                        descriptor.setRelationship(conProps.getRelationship());
                    }
                } else {
                    descriptor.setConcept(conProps.getConcept());
                    descriptor.setAttribute(conProps.getAttribute());
                    descriptor.setAlternate(conProps.getAlternate());
                    descriptor.setRelationship(conProps.getRelationship());
                }
                this.dimColumnDescriptor.add(descriptor);
            }
        }
    }
}

