/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.components.widgets.trees;

import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;
import org.fao.fi.fishstat.data.timeseries.api.Dataset;
import org.fao.fi.fishstat.data.timeseries.api.DimensionNote;
import org.fao.fi.fishstat.data.timeseries.api.Timeseries;
import org.fao.fi.fishstat.data.timeseries.api.exceptions.TimeseriesServiceException;
import org.fao.fi.fishstat.gui.components.ComponentsActivator;
import org.fao.fi.fishstat.gui.components.Graphics;

public class DatasetsTreeLabelProvider
implements ILabelProvider {
    public Image getImage(Object element) {
        if (element instanceof Dataset) {
            return Graphics.ICON_DATASET_16;
        }
        if (element instanceof Timeseries) {
            return Graphics.ICON_TIMESERIES;
        }
        if (element instanceof DimensionNote) {
            return Graphics.ICON_DIMENSION_NOTE;
        }
        return null;
    }

    public String getText(Object element) {
        if (element instanceof Dataset) {
            return ((Dataset)element).getName().getValue(ComponentsActivator.getLanguage());
        }
        if (element instanceof Timeseries) {
            String rowCount = null;
            try {
                rowCount = Integer.toString(((Timeseries)element).getRowCount());
            }
            catch (TimeseriesServiceException timeseriesServiceException) {
                rowCount = "n.a.";
            }
            return String.valueOf(((Timeseries)element).getName().getValue(ComponentsActivator.getLanguage())) + " - " + rowCount + " rows";
        }
        if (element instanceof DimensionNote) {
            return ((DimensionNote)element).getAcronym();
        }
        return null;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

