/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.core;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import org.fao.fi.fishstat.data.common.api.MultilingualString;

public class MultilingualStringWrapper
implements Cloneable {
    private MultilingualString instance;
    private PropertyChangeListener owner;
    private String propertyId;

    public MultilingualStringWrapper() {
        this.instance = new MultilingualString();
        this.propertyId = "";
    }

    public MultilingualStringWrapper(MultilingualString instance) {
        this.instance = new MultilingualString(instance);
        this.propertyId = "";
    }

    public MultilingualStringWrapper(String propertyId, MultilingualString mls) {
        this.instance = new MultilingualString(mls);
        this.propertyId = propertyId;
    }

    public MultilingualStringWrapper(String propertyId, PropertyChangeListener owner) {
        this.instance = new MultilingualString();
        this.owner = owner;
        this.propertyId = propertyId;
    }

    public MultilingualStringWrapper(String property_id, MultilingualString mls, PropertyChangeListener owner) {
        this.propertyId = property_id;
        this.instance = new MultilingualString(mls);
        this.owner = owner;
    }

    public String getValue(Locale locale) {
        return this.instance.getValue(locale);
    }

    public String getValue(String lang) {
        return this.instance.getValue(lang);
    }

    public void setValue(Locale locale, String value) {
        String oldVal = this.instance.getValue(locale);
        this.instance.setValue(locale, value.equals("") ? null : value);
        if (this.owner != null) {
            this.owner.propertyChange(new PropertyChangeEvent(this, String.valueOf(this.propertyId) + "@" + locale.getLanguage(), oldVal, value));
        }
    }

    public void setValue(String lang, String value) {
        String oldVal = this.instance.getValue(lang);
        if (value == null) {
            this.instance.setValue(lang, null);
        } else {
            this.instance.setValue(lang, value.equals("") ? null : value);
        }
        if (this.owner != null) {
            this.owner.propertyChange(new PropertyChangeEvent(this, String.valueOf(this.propertyId) + "@" + lang, oldVal, value));
        }
    }

    public String toString() {
        return this.instance.toString();
    }

    public MultilingualString getInstance() {
        return this.instance;
    }

    public PropertyChangeListener getOwner() {
        return this.owner;
    }

    public void setOwner(PropertyChangeListener owner) {
        this.owner = owner;
    }

    public boolean hasOwner() {
        return this.owner != null;
    }

    public boolean hasAllValuesIdentical() {
        if (this.instance == null) {
            return false;
        }
        String value = this.instance.getValue((String)MultilingualString.LANGUAGES.get(0));
        if (value == null) {
            return false;
        }
        for (String lang : MultilingualString.LANGUAGES) {
            if (value.equals(this.instance.getValue(lang))) continue;
            return false;
        }
        return true;
    }

    public boolean hasAllValuesFilled() {
        for (String lang : MultilingualString.LANGUAGES) {
            if (this.instance.getValue(lang) != null && this.instance.getValue(lang).length() != 0) continue;
            return false;
        }
        return true;
    }

    public boolean isEmpty() {
        for (String lang : MultilingualString.LANGUAGES) {
            if (this.instance.getValue(lang) == null || this.instance.getValue(lang).length() <= 0) continue;
            return false;
        }
        return true;
    }

    public MultilingualStringWrapper clone() {
        if (this.owner != null) {
            return new MultilingualStringWrapper(this.propertyId, this.instance, this.owner);
        }
        return new MultilingualStringWrapper(this.propertyId, this.instance);
    }
}

