/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.core.model.customgroups;

import java.util.List;
import java.util.Vector;
import org.fao.fi.fishstat.core.MultilingualStringWrapper;
import org.fao.fi.fishstat.core.model.customgroups.CustomGroupDao;
import org.fao.fi.fishstat.core.model.customgroups.CustomGroupModel;
import org.fao.fi.fishstat.core.model.customgroups.CustomGroupModelImpl;
import org.fao.fi.fishstat.data.common.api.Identifier;
import org.fao.fi.fishstat.data.common.api.MultilingualString;
import org.fao.fi.fishstat.data.reference.api.Concept;
import org.fao.fi.fishstat.data.reference.api.CustomGroup;
import org.fao.fi.fishstat.data.reference.api.CustomGroupFactory;
import org.fao.fi.fishstat.data.reference.api.ReferenceObject;
import org.fao.fi.fishstat.data.reference.api.ReferenceServiceFactory;

public class CustomGroupDaoImpl
implements CustomGroupDao {
    @Override
    public void delete(String acronym) {
    }

    @Override
    public List<CustomGroupModel> findAll(String dimension) {
        Concept concept = ReferenceServiceFactory.getService().getConcept(dimension);
        return this.findAll(concept);
    }

    @Override
    public List<CustomGroupModel> findAll(Concept concept) {
        List groups = CustomGroupFactory.get((Concept)concept);
        Vector<CustomGroupModel> result = new Vector<CustomGroupModel>(groups.size());
        for (CustomGroup group : groups) {
            result.add(this.createModel(group));
        }
        return result;
    }

    @Override
    public int size(String dimension) {
        Concept concept = ReferenceServiceFactory.getService().getConcept(dimension);
        return CustomGroupFactory.get((Concept)concept).size();
    }

    @Override
    public Identifier insert(CustomGroupModel customGroupModel) {
        Concept dimension = customGroupModel.getSelection().getConcept();
        CustomGroup group = CustomGroupFactory.create((MultilingualString)customGroupModel.getName().getInstance(), (MultilingualString)customGroupModel.getDescription().getInstance(), (Concept)dimension);
        List<ReferenceObject> selection = customGroupModel.getSelection().getIncludesList();
        for (ReferenceObject referenceObject : selection) {
            group.addMember(referenceObject);
        }
        ((CustomGroupModelImpl)customGroupModel).setInstance(group);
        return customGroupModel.getId();
    }

    @Override
    public void update(CustomGroupModel customGroupModel) {
        CustomGroup customGroup = CustomGroupFactory.get((Identifier)customGroupModel.getId());
        customGroup.setName(customGroupModel.getName().getInstance());
        customGroup.setDescription(customGroupModel.getDescription().getInstance());
        customGroup.cleanMembers();
        List<ReferenceObject> selection = customGroupModel.getSelection().getIncludesList();
        for (ReferenceObject referenceObject : selection) {
            customGroup.addMember(referenceObject);
        }
    }

    @Override
    public CustomGroupModelImpl get(Identifier id) {
        return this.createModel(CustomGroupFactory.get((Identifier)id));
    }

    private CustomGroupModelImpl createModel(CustomGroup customGroup) {
        CustomGroupModelImpl model = new CustomGroupModelImpl(customGroup.getMembersConcept());
        model.setInstance(customGroup);
        model.setName(new MultilingualStringWrapper(customGroup.getName()));
        model.setDescription(new MultilingualStringWrapper(customGroup.getDescription()));
        model.getSelection().addIncludes(customGroup.getMembers());
        return model;
    }
}

