/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.core.model.dataset;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.fao.fi.fishstat.core.CoreCommons;
import org.fao.fi.fishstat.core.MultilingualStringWrapper;
import org.fao.fi.fishstat.core.VersionId;
import org.fao.fi.fishstat.core.model.dataset.DatasetModel;
import org.fao.fi.fishstat.core.model.dataset.DimensionModel;
import org.fao.fi.fishstat.core.model.dataset.DimensionModelImpl;
import org.fao.fi.fishstat.data.common.api.MultilingualString;
import org.fao.fi.fishstat.data.common.api.Version;
import org.fao.fi.fishstat.data.reference.api.ReferenceServiceFactory;
import org.fao.fi.fishstat.data.timeseries.api.DataSource;
import org.fao.fi.fishstat.data.timeseries.api.Dataset;
import org.fao.fi.fishstat.data.timeseries.api.Dimension;
import org.fao.fi.fishstat.data.timeseries.api.management.TimeseriesManagementServiceFactory;
import org.fao.fi.fishstat.data.timeseries.api.management.descriptors.DatasetDescriptor;
import org.fao.fi.fishstat.data.timeseries.api.management.descriptors.DescriptorsFactory;
import org.fao.fi.fishstat.data.timeseries.api.management.descriptors.DimensionDescriptor;

public class DatasetModelImpl
implements DatasetModel,
Cloneable,
PropertyChangeListener {
    private Dataset originalInstance;
    private String acronym;
    private MultilingualStringWrapper name;
    private MultilingualStringWrapper description;
    private DataSource datasource;
    private VersionId version;
    private String url;
    private MultilingualStringWrapper citation;
    protected List<DimensionModel> dimensions;
    protected PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    @Override
    public VersionId getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(VersionId version) {
        this.version = version;
        this.propertyChangeSupport.firePropertyChange("version", this.version, this.version);
    }

    public DatasetModelImpl() {
        this.name = new MultilingualStringWrapper();
        this.description = new MultilingualStringWrapper();
        this.citation = new MultilingualStringWrapper();
        this.version = new VersionId();
        this.dimensions = new LinkedList<DimensionModel>();
    }

    public DatasetModelImpl(Dataset dataset, boolean clone) {
        this.originalInstance = dataset;
        this.name = new MultilingualStringWrapper();
        this.description = new MultilingualStringWrapper();
        this.citation = new MultilingualStringWrapper();
        this.version = new VersionId();
        this.dimensions = new LinkedList<DimensionModel>();
        this.syncInstance(dataset);
        List coll = dataset.getDimensions();
        for (Dimension dimension : coll) {
            this.dimensions.add(new DimensionModelImpl(this, dimension, clone));
        }
    }

    @Override
    public String getAcronym() {
        return this.acronym;
    }

    @Override
    public void setAcronym(String acronym) {
        this.acronym = acronym;
        this.propertyChangeSupport.firePropertyChange("acronym", this.acronym, this.acronym);
    }

    @Override
    public MultilingualStringWrapper getName() {
        return this.name;
    }

    @Override
    public void setName(MultilingualStringWrapper name) {
        this.name = name;
        this.propertyChangeSupport.firePropertyChange("name", this.name, this.name);
    }

    @Override
    public MultilingualStringWrapper getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(MultilingualStringWrapper description) {
        this.description = description;
        this.propertyChangeSupport.firePropertyChange("description", this.description, this.description);
    }

    @Override
    public DataSource getDatasource() {
        return this.datasource;
    }

    @Override
    public void setDatasource(DataSource datasource) {
        this.datasource = datasource;
        this.propertyChangeSupport.firePropertyChange("datasource", this.datasource, this.datasource);
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public void setUrl(String url) {
        this.url = url;
        this.propertyChangeSupport.firePropertyChange("url", this.url, this.url);
    }

    @Override
    public boolean isNative() {
        return this.originalInstance != null;
    }

    @Override
    public boolean isSynchronised() {
        if (this.originalInstance == null) {
            return false;
        }
        if (!(this.originalInstance.getAcronym() == this.acronym || this.originalInstance.getAcronym() != null && this.originalInstance.getAcronym().equals(this.acronym))) {
            return false;
        }
        if (this.originalInstance.getDataSource() != this.datasource && !this.originalInstance.getDataSource().getName().equals(this.datasource.getName())) {
            return false;
        }
        if (this.originalInstance.getDescription() != this.description.getInstance() && !this.originalInstance.getDescription().equals((Object)this.description.getInstance())) {
            return false;
        }
        if (this.citation != null && this.originalInstance.getCitation() != this.citation.getInstance() && !this.originalInstance.getCitation().equals((Object)this.citation.getInstance())) {
            return false;
        }
        if (!this.originalInstance.getName().equals((Object)this.name.getInstance())) {
            return false;
        }
        if (this.url != null && !this.url.equals(this.originalInstance.getUrl())) {
            return false;
        }
        if (this.originalInstance.getDimensions().size() != this.dimensions.size()) {
            return false;
        }
        for (DimensionModel dimensionModel : this.dimensions) {
            if (dimensionModel.isSynchronised()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Dataset getInstance() {
        return this.originalInstance;
    }

    public void setInstance(Dataset instance) {
        this.originalInstance = instance;
    }

    @Override
    public List<DimensionModel> getDimensionModels() {
        return this.dimensions;
    }

    @Override
    public List<DimensionDescriptor> getDimensionDescriptors() throws Exception {
        LinkedList<DimensionDescriptor> res = new LinkedList<DimensionDescriptor>();
        for (DimensionModel dimensionModel : this.dimensions) {
            DimensionDescriptor dimensionDesc = dimensionModel.getDimensionDescriptor();
            res.add(dimensionDesc);
        }
        return res;
    }

    @Override
    public int getDimensionsSize() {
        return this.dimensions != null ? this.dimensions.size() : 0;
    }

    @Override
    public DimensionModel getDimension(String acronym) {
        for (DimensionModel dimensionModel : this.dimensions) {
            if (!dimensionModel.getAcronym().equals(acronym)) continue;
            return dimensionModel;
        }
        return null;
    }

    @Override
    public void addDimension(DimensionModel dimension) {
        int old_size = this.dimensions.size();
        this.dimensions.add(dimension);
        this.propertyChangeSupport.firePropertyChange("dimensions_size", old_size, old_size + 1);
    }

    @Override
    public boolean hasDimension(String acronym) {
        for (DimensionModel dimensionModel : this.dimensions) {
            if (!dimensionModel.getAcronym().equals(acronym)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void removeDimension(DimensionModel dimension) {
        int old_size = this.dimensions.size();
        this.dimensions.remove(dimension);
        this.propertyChangeSupport.firePropertyChange("dimensions_size", old_size, old_size - 1);
    }

    public static String getNewConceptAcronym() {
        String base = "NEW_CONCEPT";
        int i = 0;
        while (i <= 100) {
            if (ReferenceServiceFactory.getService().getConcept(String.valueOf(base) + "_" + i) == null) {
                return String.valueOf(base) + "_" + i;
            }
            ++i;
        }
        return null;
    }

    @Override
    public void persistModel(IProgressMonitor progressMonitor) throws Exception {
        if (this.isNative()) {
            throw new Exception("Dataset modification is not possible; delete then add");
        }
        this.originalInstance = this.persistNewDataset(progressMonitor);
    }

    private Dataset persistNewDataset(IProgressMonitor monitor) throws Exception {
        if (monitor != null) {
            monitor.beginTask("Saving dataset...", 10);
        }
        if (monitor != null) {
            monitor.worked(1);
        }
        DatasetDescriptor descriptor = DescriptorsFactory.createDatasetDescriptor((DataSource)this.getDatasource(), this.getDimensionDescriptors(), (String)this.getAcronym(), (MultilingualString)this.getName().getInstance(), (MultilingualString)this.getDescription().getInstance(), (String)this.getUrl(), (Version)new Version(this.getVersion().getNumber(), this.getVersion().getDateDate(), this.getVersion().getAuthor()), (MultilingualString)this.getCitation().getInstance());
        Dataset dataset = TimeseriesManagementServiceFactory.getService().createDataset(descriptor);
        if (monitor != null) {
            monitor.internalWorked(1.0);
        }
        CoreCommons.getWorkspaceStatus().fireModifyEvent(Dataset.class);
        return dataset;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.propertyChangeSupport.firePropertyChange(evt);
    }

    protected DatasetModelImpl clone() throws CloneNotSupportedException {
        DatasetModelImpl res = new DatasetModelImpl();
        if (this.acronym != null) {
            res.acronym = new String(this.acronym);
        }
        if (this.datasource != null) {
            res.datasource = new DataSource(this.datasource.getName());
        }
        if (this.name != null) {
            res.name = this.name.clone();
        }
        if (this.description != null) {
            res.description = this.description.clone();
        }
        if (this.url != null) {
            res.url = new String(this.url);
        }
        if (this.version != null) {
            res.version = this.version.clone();
        }
        if (this.citation != null) {
            res.citation = this.citation.clone();
        }
        return res;
    }

    @Override
    public DimensionModel createNewDimension() {
        return new DimensionModelImpl(this);
    }

    private void syncInstance(Dataset dataset) {
        this.acronym = dataset.getAcronym();
        this.datasource = dataset.getDataSource();
        this.name = new MultilingualStringWrapper("name", dataset.getName(), this);
        this.description = new MultilingualStringWrapper("description", dataset.getDescription(), this);
        this.url = dataset.getUrl();
        this.citation = new MultilingualStringWrapper("citation", dataset.getCitation(), this);
        this.getVersion().setAuthor(dataset.getVersion().getAuthor());
        this.getVersion().setDateDate(dataset.getVersion().getDate());
        if (dataset.getVersion().getNumber() != null) {
            this.getVersion().setNumber(dataset.getVersion().getNumber());
        }
    }

    @Override
    public MultilingualStringWrapper getCitation() {
        return this.citation;
    }

    @Override
    public void setCitation(MultilingualStringWrapper citation) {
        this.citation = citation;
        this.propertyChangeSupport.firePropertyChange("citation", this.citation, this.citation);
    }
}

