/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.core.session;

import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.fao.fi.fishstat.core.CoreCache;
import org.fao.fi.fishstat.core.FSActions;
import org.fao.fi.fishstat.core.FocusEntity;
import org.fao.fi.fishstat.core.IActionRequestWrapper;
import org.fao.fi.fishstat.core.IFSActions;
import org.fao.fi.fishstat.core.dataset.FullTimeSeriesRequest;
import org.fao.fi.fishstat.core.dataset.RemoveActionRequest;
import org.fao.fi.fishstat.core.model.aggregation.AggregationWrapper;
import org.fao.fi.fishstat.core.model.aggregation.TopCriteriaWrapper;
import org.fao.fi.fishstat.core.model.concept.selection.FilterWrapper;
import org.fao.fi.fishstat.core.session.FSSessionMetadata;
import org.fao.fi.fishstat.core.session.SessionDescriptor;
import org.fao.fi.fishstat.data.timeseries.api.Attribute;
import org.fao.fi.fishstat.data.timeseries.api.Dataset;
import org.fao.fi.fishstat.data.timeseries.api.Timeseries;

public abstract class Session
extends Observable
implements Observer,
IFSActions {
    protected SessionDescriptor descriptor = null;
    protected FSSessionMetadata sessionMetadata = null;
    protected FSActions actions;
    protected FilterWrapper filterRequest;
    protected AggregationWrapper aggregationRequest;
    protected TopCriteriaWrapper topOthersRequest;
    protected String[] unitValue;
    protected Timeseries lastResult;
    protected int currentSize = 0;
    protected FocusEntity lastFocusEntity = null;
    protected boolean showSeriesDetails = false;
    protected boolean tsResetRequired;
    protected boolean calcGrandTotals;

    public Session(Timeseries timeseries) {
        this.descriptor = new SessionDescriptor();
        this.descriptor.timeseries = timeseries;
        this.descriptor.size = CoreCache.getTimeseriesSize(timeseries);
        this.lastFocusEntity = new FocusEntity();
        this.unitValue = this.calcUnitAndMultiplierValue();
        this.tsResetRequired = true;
        this.actions = new FSActions();
    }

    public Session(SessionDescriptor descriptor) {
        this.lastFocusEntity = new FocusEntity();
        this.descriptor = descriptor;
        this.unitValue = this.calcUnitAndMultiplierValue();
        this.tsResetRequired = true;
        this.actions = new FSActions();
    }

    public void addAction(int action) {
        this.actions.add(action);
    }

    public Timeseries getTimeseries() {
        return this.descriptor.timeseries;
    }

    public int getGlobalTimeSeriesSize() {
        return this.descriptor.size;
    }

    public SessionDescriptor getDescriptor() {
        return this.descriptor;
    }

    public Dataset getDataset() {
        return this.descriptor.getDataset();
    }

    public FilterWrapper getFilterRequest() {
        return this.filterRequest;
    }

    public void setFilterRequest(FilterWrapper wrapper) {
        this.tsResetRequired = this.isTimeSeriesResetRequired(wrapper);
        this.filterRequest = wrapper;
    }

    private void removeFilterRequest() {
        this.tsResetRequired = true;
        this.filterRequest = null;
        this.actions.add(42);
    }

    protected boolean isTimeSeriesResetRequired(IActionRequestWrapper request) {
        if (request instanceof RemoveActionRequest || request instanceof FullTimeSeriesRequest) {
            return true;
        }
        switch (request.getAction()) {
            case 2: {
                if (this.filterRequest == null && this.aggregationRequest == null && this.topOthersRequest == null) break;
                return true;
            }
            case 3: {
                if (this.aggregationRequest == null && this.topOthersRequest == null) break;
                return true;
            }
            case 4: {
                if (this.topOthersRequest == null) break;
                return true;
            }
        }
        return false;
    }

    public AggregationWrapper getAggregationRequest() {
        return this.aggregationRequest;
    }

    public void setAggregationRequest(AggregationWrapper wrapper) {
        this.tsResetRequired = this.isTimeSeriesResetRequired(wrapper);
        this.actions.add(81);
        this.aggregationRequest = wrapper;
    }

    private void removeAggregationRequest() {
        this.aggregationRequest = null;
        this.tsResetRequired = true;
        this.actions.add(42, 81);
    }

    public TopCriteriaWrapper getTopOthersRequest() {
        return this.topOthersRequest;
    }

    public boolean hasAggregationRequest() {
        return this.aggregationRequest != null;
    }

    public boolean hasTopCriteriaRequest() {
        return this.topOthersRequest != null;
    }

    public void setTopOthersRequest(TopCriteriaWrapper wrapper) {
        this.tsResetRequired = this.isTimeSeriesResetRequired(wrapper);
        this.topOthersRequest = wrapper;
    }

    private void removeTopOtherRequest() {
        this.topOthersRequest = null;
        this.tsResetRequired = true;
        this.actions.remove(42);
        this.actions.add(41);
    }

    public void execActionRequest(IActionRequestWrapper request, IProgressMonitor pm) {
        switch (request.getAction()) {
            case 2: {
                this.setFilterRequest((FilterWrapper)request);
                this.actions.add(42);
                break;
            }
            case 3: {
                this.setAggregationRequest((AggregationWrapper)request);
                this.actions.add(42);
                break;
            }
            case 4: {
                this.setTopOthersRequest((TopCriteriaWrapper)request);
                break;
            }
        }
        this.compute("", pm);
    }

    public void removeActionRequest(int action, IProgressMonitor pm) {
        switch (action) {
            case 2: {
                this.removeFilterRequest();
                break;
            }
            case 3: {
                this.removeAggregationRequest();
                break;
            }
            case 4: {
                this.removeTopOtherRequest();
                break;
            }
        }
        this.compute("", pm);
    }

    public FocusEntity getLastFocusEntity() {
        return this.lastFocusEntity;
    }

    public void resetFocusEntity() {
        this.lastFocusEntity = null;
    }

    public boolean hasLastFocusEntity() {
        return this.lastFocusEntity != null;
    }

    public void setLastFocusEntity(FocusEntity lastFocusEntity) {
        this.lastFocusEntity = lastFocusEntity;
        this.setChanged();
        this.notifyObservers(lastFocusEntity);
    }

    public Timeseries getLastResult() {
        return this.lastResult;
    }

    public abstract boolean hasCalculatedMesaures();

    public boolean getShowSeriesDetails() {
        return this.showSeriesDetails;
    }

    public void setShowSeriesDetails(boolean showSeriesDetails) {
        this.showSeriesDetails = showSeriesDetails;
    }

    public boolean getCalcGrandTotals() {
        return this.calcGrandTotals;
    }

    public void setCalcGrandTotals(boolean calcGrandTotals) {
        this.calcGrandTotals = calcGrandTotals;
    }

    public void loadFullTimeseries(String message, IProgressMonitor pm) {
        this.tsResetRequired = true;
        this.actions.add(41);
        this.compute(message, pm);
    }

    private String[] calcUnitAndMultiplierValue() {
        Set attributes = this.descriptor.timeseries.getAttributes().keySet();
        String[] res = new String[2];
        for (Attribute attribute : attributes) {
            if (attribute.getAcronym().equalsIgnoreCase("UNIT")) {
                res[0] = (String)this.descriptor.timeseries.getAttributes().get(attribute);
            }
            if (!attribute.getAcronym().equalsIgnoreCase("UNIT_MULTIPLIER")) continue;
            res[1] = (String)this.descriptor.timeseries.getAttributes().get(attribute);
        }
        return res;
    }

    public abstract void compute(String var1, IProgressMonitor var2);

    public FSSessionMetadata getSessionMetadata() {
        return this.sessionMetadata;
    }

    public void notifyMultiTableView() {
        this.setChanged();
        this.notifyObservers(this.actions);
        this.actions.clear();
    }

    public String[] getUnitValue() {
        return this.unitValue;
    }

    public String getUUID() {
        return this.descriptor.getUuid().toString();
    }

    public abstract void dispose();
}

